/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.id.apache.serial;

import java.io.Serializable;
import org.openspcoop2.utils.id.apache.AbstractLongIdentifierGenerator;
import org.openspcoop2.utils.id.apache.serial.MaxReachedException;

public class LongGenerator
extends AbstractLongIdentifierGenerator
implements Serializable {
    private static final long serialVersionUID = 20060122L;
    private boolean wrapping;
    private long count = 0L;

    public LongGenerator(boolean wrap, long initialValue) {
        this.wrapping = wrap;
        this.count = initialValue;
    }

    public boolean isWrap() {
        return this.wrapping;
    }

    public void setWrap(boolean wrap) {
        this.wrapping = wrap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long nextLongIdentifier() throws MaxReachedException {
        long value = 0L;
        if (this.wrapping) {
            LongGenerator longGenerator = this;
            synchronized (longGenerator) {
                value = this.count++;
            }
        }
        LongGenerator longGenerator = this;
        synchronized (longGenerator) {
            if (this.count == Long.MAX_VALUE) {
                throw new MaxReachedException("The maximum number of identifiers has been reached");
            }
            value = this.count++;
        }
        return value;
    }
}

