/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.ArchiveType;
import org.openspcoop2.utils.io.CompressorType;
import org.openspcoop2.utils.io.Entry;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class CompressorUtilities {
    private static final String COMPRESSO_DIMENSIONE = "Compresso, dimensione: ";
    private static final String COMPRESSO_IN_STRING = "Compresso, in stringa: ";
    private static final String DECOMPRESSO_IN_STRING = "De-Compresso, in stringa: ";
    private static final String INFORMAZIONE_DECOMPRESSA_DIFFERENTE = "Informazione decompressa non uguale al sorgente";
    private static final String INFORMAZIONE_DECOMPRESSA_DIFFERENTE_SIZE = "Informazione decompressa non uguale al sorgente (size)";
    private static final String INFORMAZIONE_DECOMPRESSA_DIFFERENTE_ENTRY_1 = "Informazione decompressa non uguale al sorgente (entry1 name:";
    private static final String INFORMAZIONE_DECOMPRESSA_DIFFERENTE_ENTRY_2 = "Informazione decompressa non uguale al sorgente (entry2 name:";
    private static final String INFORMAZIONE_DECOMPRESSA_DIFFERENTE_ENTRY_1_DIFFERENTE = "Informazione decompressa non uguale al sorgente (entry1 contenuto differente)";
    private static final String INFORMAZIONE_DECOMPRESSA_UGUALE = "De-Compresso: test di comparazione completati con successo";
    private static final String DECOMPRESSO = "De-Compresso: ";
    private static final String ATTESO = " atteso:";

    public static void main(String[] args) throws Exception {
        CompressorUtilities.testCompressor(null);
        CompressorUtilities.testArchive(null);
    }

    private static void print(String msg) {
        System.out.println(msg);
    }

    public static void testCompressor(CompressorType tipo) throws UtilsException {
        String decompresso;
        byte[] compress;
        String test = "<prova xmlns=\"www.test.it\">PROVA</prova>";
        byte[] testB = test.getBytes();
        if (tipo == null || CompressorType.DEFLATER.equals((Object)tipo)) {
            CompressorUtilities.print("\n\n=== DEFLATER ===");
            compress = CompressorUtilities.compress(testB, CompressorType.DEFLATER);
            CompressorUtilities.print(COMPRESSO_DIMENSIONE + compress.length);
            CompressorUtilities.print(COMPRESSO_IN_STRING + new String(compress));
            decompresso = new String(CompressorUtilities.decompress(compress, CompressorType.DEFLATER));
            CompressorUtilities.print(DECOMPRESSO_IN_STRING + decompresso);
            if (!decompresso.equals(test)) {
                throw new UtilsException(INFORMAZIONE_DECOMPRESSA_DIFFERENTE);
            }
        }
        if (tipo == null || CompressorType.GZIP.equals((Object)tipo)) {
            CompressorUtilities.print("\n\n=== GZIP ===");
            compress = CompressorUtilities.compress(testB, CompressorType.GZIP);
            CompressorUtilities.print(COMPRESSO_DIMENSIONE + compress.length);
            CompressorUtilities.print(COMPRESSO_IN_STRING + new String(compress));
            decompresso = new String(CompressorUtilities.decompress(compress, CompressorType.GZIP));
            CompressorUtilities.print(DECOMPRESSO_IN_STRING + decompresso);
            if (!decompresso.equals(test)) {
                throw new UtilsException(INFORMAZIONE_DECOMPRESSA_DIFFERENTE);
            }
        }
        if (tipo == null || CompressorType.ZIP.equals((Object)tipo)) {
            CompressorUtilities.print("\n\n=== ZIP ===");
            compress = CompressorUtilities.compress(testB, CompressorType.ZIP);
            CompressorUtilities.print(COMPRESSO_DIMENSIONE + compress.length);
            CompressorUtilities.print(COMPRESSO_IN_STRING + new String(compress));
            decompresso = new String(CompressorUtilities.decompress(compress, CompressorType.ZIP));
            CompressorUtilities.print(DECOMPRESSO_IN_STRING + decompresso);
            if (!decompresso.equals(test)) {
                throw new UtilsException(INFORMAZIONE_DECOMPRESSA_DIFFERENTE);
            }
        }
    }

    public static void testArchive(ArchiveType tipo) throws Exception {
        Entry entryRead2;
        Entry entryRead1;
        List<Entry> entriesRead;
        byte[] compress;
        String entryName = "entry1";
        String test = "<prova xmlns=\"www.test.it\">PROVA</prova>";
        byte[] testB = test.getBytes();
        String entryName2 = "dir/subdir/entry2";
        String test2 = "<prova xmlns=\"www.test.it\">PROVA2</prova>";
        byte[] test2B = test2.getBytes();
        ArrayList<Entry> entries = new ArrayList<Entry>();
        entries.add(new Entry(entryName, testB));
        entries.add(new Entry(entryName2, test2B));
        if (tipo == null || ArchiveType.ZIP.equals((Object)tipo)) {
            CompressorUtilities.print("\n\n=== ZIP ===");
            compress = CompressorUtilities.archive(entries, ArchiveType.ZIP);
            CompressorUtilities.print(COMPRESSO_DIMENSIONE + compress.length);
            entriesRead = CompressorUtilities.read(compress, ArchiveType.ZIP);
            CompressorUtilities.print(DECOMPRESSO + entriesRead.size());
            if (entriesRead.size() != 2) {
                throw new UtilsException(INFORMAZIONE_DECOMPRESSA_DIFFERENTE_SIZE);
            }
            entryRead1 = entriesRead.get(0);
            entryRead2 = entriesRead.get(1);
            if (!entryName.equals(entryRead1.getName())) {
                throw new UtilsException(INFORMAZIONE_DECOMPRESSA_DIFFERENTE_ENTRY_1 + entryRead1.getName() + ATTESO + entryName + ")");
            }
            if (!entryName2.equals(entryRead2.getName())) {
                throw new UtilsException(INFORMAZIONE_DECOMPRESSA_DIFFERENTE_ENTRY_2 + entryRead2.getName() + ATTESO + entryName2 + ")");
            }
            if (!test.equals(new String(entryRead1.getContent()))) {
                throw new UtilsException(INFORMAZIONE_DECOMPRESSA_DIFFERENTE_ENTRY_1_DIFFERENTE);
            }
            if (!test2.equals(new String(entryRead2.getContent()))) {
                throw new UtilsException(INFORMAZIONE_DECOMPRESSA_DIFFERENTE_ENTRY_1_DIFFERENTE);
            }
            CompressorUtilities.print(INFORMAZIONE_DECOMPRESSA_UGUALE);
        }
        if (tipo == null || ArchiveType.TAR.equals((Object)tipo)) {
            CompressorUtilities.print("\n\n=== TAR ===");
            compress = CompressorUtilities.archive(entries, ArchiveType.TAR);
            CompressorUtilities.print(COMPRESSO_DIMENSIONE + compress.length);
            entriesRead = CompressorUtilities.read(compress, ArchiveType.TAR);
            CompressorUtilities.print(DECOMPRESSO + entriesRead.size());
            if (entriesRead.size() != 2) {
                throw new UtilsException(INFORMAZIONE_DECOMPRESSA_DIFFERENTE_SIZE);
            }
            entryRead1 = entriesRead.get(0);
            entryRead2 = entriesRead.get(1);
            if (!entryName.equals(entryRead1.getName())) {
                throw new UtilsException(INFORMAZIONE_DECOMPRESSA_DIFFERENTE_ENTRY_1 + entryRead1.getName() + ATTESO + entryName + ")");
            }
            if (!entryName2.equals(entryRead2.getName())) {
                throw new UtilsException(INFORMAZIONE_DECOMPRESSA_DIFFERENTE_ENTRY_2 + entryRead2.getName() + ATTESO + entryName2 + ")");
            }
            if (!test.equals(new String(entryRead1.getContent()))) {
                throw new UtilsException(INFORMAZIONE_DECOMPRESSA_DIFFERENTE_ENTRY_1_DIFFERENTE);
            }
            if (!test2.equals(new String(entryRead2.getContent()))) {
                throw new UtilsException(INFORMAZIONE_DECOMPRESSA_DIFFERENTE_ENTRY_1_DIFFERENTE);
            }
            CompressorUtilities.print(INFORMAZIONE_DECOMPRESSA_UGUALE);
        }
        if (tipo == null || ArchiveType.TGZ.equals((Object)tipo)) {
            CompressorUtilities.print("\n\n=== TGZ ===");
            compress = CompressorUtilities.archive(entries, ArchiveType.TGZ);
            CompressorUtilities.print(COMPRESSO_DIMENSIONE + compress.length);
            entriesRead = CompressorUtilities.read(compress, ArchiveType.TGZ);
            CompressorUtilities.print(DECOMPRESSO + entriesRead.size());
            if (entriesRead.size() != 2) {
                throw new UtilsException(INFORMAZIONE_DECOMPRESSA_DIFFERENTE_SIZE);
            }
            entryRead1 = entriesRead.get(0);
            entryRead2 = entriesRead.get(1);
            if (!entryName.equals(entryRead1.getName())) {
                throw new UtilsException(INFORMAZIONE_DECOMPRESSA_DIFFERENTE_ENTRY_1 + entryRead1.getName() + ATTESO + entryName + ")");
            }
            if (!entryName2.equals(entryRead2.getName())) {
                throw new UtilsException(INFORMAZIONE_DECOMPRESSA_DIFFERENTE_ENTRY_2 + entryRead2.getName() + ATTESO + entryName2 + ")");
            }
            if (!test.equals(new String(entryRead1.getContent()))) {
                throw new UtilsException(INFORMAZIONE_DECOMPRESSA_DIFFERENTE_ENTRY_1_DIFFERENTE);
            }
            if (!test2.equals(new String(entryRead2.getContent()))) {
                throw new UtilsException(INFORMAZIONE_DECOMPRESSA_DIFFERENTE_ENTRY_1_DIFFERENTE);
            }
            CompressorUtilities.print(INFORMAZIONE_DECOMPRESSA_UGUALE);
        }
    }

    public static byte[] compress(byte[] content, CompressorType type) throws UtilsException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            OutputStream out = null;
            switch (type) {
                case DEFLATER: {
                    out = new DeflaterOutputStream(baos);
                    out.write(content);
                    break;
                }
                case GZIP: {
                    out = new GZIPOutputStream(baos);
                    out.write(content);
                    break;
                }
                case ZIP: {
                    out = new ZipOutputStream(baos);
                    ((ZipOutputStream)out).putNextEntry(new ZipEntry("dat"));
                    out.write(content);
                    ((ZipOutputStream)out).closeEntry();
                }
            }
            if (out == null) {
                throw new UtilsException("OutputStream undefined");
            }
            out.flush();
            out.close();
            baos.flush();
            baos.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static byte[] archive(List<Entry> entries, ArchiveType type) throws UtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            TarArchiveOutputStream out = null;
            GzipCompressorOutputStream compressorOut = null;
            switch (type) {
                case TAR: {
                    out = new TarArchiveOutputStream((OutputStream)bout);
                    break;
                }
                case TGZ: {
                    compressorOut = new GzipCompressorOutputStream((OutputStream)bout);
                    out = new TarArchiveOutputStream((OutputStream)compressorOut);
                    break;
                }
                case ZIP: {
                    out = new ZipArchiveOutputStream((OutputStream)bout);
                }
            }
            if (out == null) {
                throw new UtilsException("OutputStream undefined");
            }
            for (Entry entry : entries) {
                String name = entry.getName();
                TarArchiveEntry archiveEntry = null;
                switch (type) {
                    case TAR: 
                    case TGZ: {
                        archiveEntry = new TarArchiveEntry(name);
                        archiveEntry.setSize((long)entry.getContent().length);
                        break;
                    }
                    case ZIP: {
                        archiveEntry = new ZipArchiveEntry(name);
                    }
                }
                switch (type) {
                    case TAR: 
                    case TGZ: {
                        out.putArchiveEntry(archiveEntry);
                        break;
                    }
                    case ZIP: {
                        ((ZipArchiveOutputStream)out).putArchiveEntry((ZipArchiveEntry)archiveEntry);
                    }
                }
                out.write(entry.getContent());
                out.closeArchiveEntry();
            }
            out.flush();
            out.close();
            if (compressorOut != null) {
                compressorOut.flush();
                compressorOut.close();
            }
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new UtilsException("Errore durante la scrittura '" + type + "': " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] bytes, CompressorType type) throws UtilsException {
        InputStream in = null;
        ByteArrayInputStream bin = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            bin = new ByteArrayInputStream(bytes);
            byte[] buffer = new byte[8192];
            switch (type) {
                case DEFLATER: {
                    int len;
                    in = new InflaterInputStream(bin);
                    while ((len = in.read(buffer)) > 0) {
                        baos.write(buffer, 0, len);
                    }
                    break;
                }
                case GZIP: {
                    int len;
                    in = new GZIPInputStream(bin);
                    while ((len = in.read(buffer)) > 0) {
                        baos.write(buffer, 0, len);
                    }
                    break;
                }
                case ZIP: {
                    File f = FileSystemUtilities.createTempFile("unzip", "zip");
                    ZipFile zf = null;
                    try {
                        int len;
                        FileSystemUtilities.writeFile(f, bytes);
                        zf = new ZipFile(f);
                        ZipEntry ze = zf.entries().nextElement();
                        in = zf.getInputStream(ze);
                        while ((len = in.read(buffer)) > 0) {
                            baos.write(buffer, 0, len);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (f != null) {
                                Files.delete(f.toPath());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (zf != null) {
                                zf.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        if (f != null) {
                            Files.delete(f.toPath());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (zf == null) break;
                        zf.close();
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
            baos.flush();
            baos.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static List<Entry> read(byte[] archiveContent, ArchiveType type) throws UtilsException {
        try {
            ArchiveEntry entry;
            ArrayList<Entry> list = new ArrayList<Entry>();
            ByteArrayInputStream bin = new ByteArrayInputStream(archiveContent);
            TarArchiveInputStream in = null;
            GzipCompressorInputStream compressorIn = null;
            switch (type) {
                case TAR: {
                    in = new TarArchiveInputStream((InputStream)bin);
                    break;
                }
                case TGZ: {
                    compressorIn = new GzipCompressorInputStream((InputStream)bin);
                    in = new TarArchiveInputStream((InputStream)compressorIn);
                    break;
                }
                case ZIP: {
                    in = new ZipArchiveInputStream((InputStream)bin);
                }
            }
            if (in == null) {
                throw new UtilsException("InputStream undefined");
            }
            while ((entry = in.getNextEntry()) != null) {
                int direct;
                String name = entry.getName();
                if (name == null || name.endsWith("/") || name.endsWith("\\")) continue;
                Entry zentry = new Entry();
                zentry.setName(name);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                byte[] contents = new byte[4096];
                while ((direct = in.read(contents, 0, contents.length)) >= 0) {
                    bout.write(contents, 0, direct);
                }
                bout.flush();
                bout.close();
                zentry.setContent(bout.toByteArray());
                list.add(zentry);
            }
            if (compressorIn != null) {
                compressorIn.close();
            }
            in.close();
            bin.close();
            return list;
        }
        catch (Exception e) {
            throw new UtilsException("Errore durante la lettura '" + type + "': " + e.getMessage(), e);
        }
    }
}

