/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.io.IDumpByteArrayOutputStream;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class DumpByteArrayOutputStream_DefaultImpl
extends ByteArrayOutputStream
implements IDumpByteArrayOutputStream {
    private int soglia = -1;
    private int attuale = 0;
    private File repositoryFile = null;
    private String idTransazione;
    private String tipoMessaggio;
    private File f = null;
    private boolean fLocked = false;
    private FileOutputStream fout = null;

    DumpByteArrayOutputStream_DefaultImpl() {
    }

    DumpByteArrayOutputStream_DefaultImpl(Integer soglia, File repositoryFile, String idTransazione, String tipoMessaggio) {
        this.soglia = soglia;
        this.repositoryFile = repositoryFile;
        this.idTransazione = idTransazione;
        this.tipoMessaggio = tipoMessaggio;
    }

    private void checkInitFile() throws Exception {
        if (this.f == null) {
            this._checkInitFile();
        }
    }

    private synchronized void _checkInitFile() throws Exception {
        if (this.f == null) {
            this.f = DumpByteArrayOutputStream.newFile(this.repositoryFile, this.tipoMessaggio, this.idTransazione);
            super.flush();
            super.close();
            this.fout = new FileOutputStream(this.f);
            if (super.size() > 0) {
                this.fout.write(super.toByteArray());
            }
        }
    }

    @Override
    public boolean isSerializedOnFileSystem() {
        return this.f != null;
    }

    @Override
    public File getSerializedFile() {
        return this.f;
    }

    @Override
    public void lock() {
        this.fLocked = true;
    }

    @Override
    public void unlock() {
        this.fLocked = false;
    }

    @Override
    public synchronized void writeInBuffer(int b) {
        if (this.soglia > 0 && this.attuale > this.soglia) {
            try {
                ++this.attuale;
                if (this.f == null) {
                    this.checkInitFile();
                }
                if (this.fout == null) {
                    throw new Exception("FileOutputStream '" + this.f.getAbsolutePath() + "' closed");
                }
                this.fout.write(b);
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return;
        }
        ++this.attuale;
        super.write(b);
    }

    @Override
    public synchronized void writeInBuffer(byte[] b, int off, int len) {
        if (this.soglia > 0 && (this.attuale > this.soglia || this.attuale + len > this.soglia)) {
            try {
                this.attuale += len;
                if (this.f == null) {
                    this.checkInitFile();
                }
                if (this.fout == null) {
                    throw new Exception("FileOutputStream '" + this.f.getAbsolutePath() + "' closed");
                }
                this.fout.write(b, off, len);
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return;
        }
        this.attuale += len;
        super.write(b, off, len);
    }

    @Override
    public void writeInBuffer(byte[] b) throws IOException {
        if (this.soglia > 0 && (this.attuale > this.soglia || this.attuale + b.length > this.soglia)) {
            try {
                this.attuale += b.length;
                if (this.f == null) {
                    this.checkInitFile();
                }
                if (this.fout == null) {
                    throw new Exception("FileOutputStream '" + this.f.getAbsolutePath() + "' closed");
                }
                this.fout.write(b);
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return;
        }
        this.attuale += b.length;
        super.write(b);
    }

    @Override
    public synchronized void reset() {
        this.clearResources();
    }

    @Override
    public void clearResources() {
        if (this.f != null) {
            this._clearResources();
        }
    }

    private synchronized void _clearResources() {
        if (this.f != null && !this.fLocked) {
            try {
                if (this.fout != null) {
                    this.fout.flush();
                    this.fout.close();
                    this.fout = null;
                }
                if (!this.f.delete()) {
                    // empty if block
                }
                this.f = null;
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @Override
    public synchronized int size() {
        if (this.f != null) {
            try {
                return (int)this.f.length();
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return super.size();
    }

    @Override
    public synchronized void writeTo(OutputStream out) throws IOException {
        try {
            this.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.f != null) {
            try {
                CopyStream.copy(this.f, out);
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        } else {
            super.writeTo(out);
        }
    }

    @Override
    public synchronized byte[] toByteArray() {
        return this._serializeToByteArray();
    }

    @Override
    public synchronized byte[] serializeToByteArray() {
        return this._serializeToByteArray();
    }

    private synchronized byte[] _serializeToByteArray() {
        try {
            this.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.f != null) {
            try {
                return FileSystemUtilities.readBytesFromFile(this.f);
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return super.toByteArray();
    }

    @Override
    public synchronized String toString() {
        return this._serializeToString();
    }

    @Override
    public synchronized String serializeToString() {
        return this._serializeToString();
    }

    private synchronized String _serializeToString() {
        try {
            this.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.f != null) {
            try {
                return FileSystemUtilities.readFile(this.f);
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return super.toString();
    }

    @Override
    public synchronized String toString(String charsetName) throws UnsupportedEncodingException {
        return this._serializeToString(charsetName);
    }

    @Override
    public synchronized String serializeToString(String charsetName) throws UnsupportedEncodingException {
        return this._serializeToString(charsetName);
    }

    private synchronized String _serializeToString(String charsetName) throws UnsupportedEncodingException {
        try {
            this.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.f != null) {
            try {
                return FileSystemUtilities.readFile(this.f, charsetName);
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return super.toString(charsetName);
    }

    @Override
    public synchronized String toString(Charset charset) {
        return this._serializeToString(charset);
    }

    @Override
    public synchronized String serializeToString(Charset charset) {
        return this._serializeToString(charset);
    }

    private synchronized String _serializeToString(Charset charset) {
        try {
            this.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.f != null) {
            try {
                return FileSystemUtilities.readFile(this.f, charset);
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return super.toString(charset);
    }

    @Override
    public synchronized String toString(int hibyte) {
        throw new RuntimeException("NotImplemented");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        if (this.f != null) {
            try {
                if (this.fout == null) return;
                this.fout.flush();
                this.fout.close();
                this.fout = null;
                return;
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        } else {
            super.flush();
            super.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void flush() throws IOException {
        if (this.f != null) {
            try {
                if (this.fout == null) return;
                this.fout.flush();
                return;
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        } else {
            super.flush();
        }
    }

    @Override
    public InputStream getInputStream() {
        try {
            this.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.f != null) {
            try {
                return new FileInputStream(this.f);
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return new ByteArrayInputStream(super.toByteArray());
    }
}

