/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.io.IDumpByteArrayOutputStream;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.springframework.util.FastByteArrayOutputStream;

public class DumpByteArrayOutputStream_FastImpl
extends FastByteArrayOutputStream
implements IDumpByteArrayOutputStream {
    private int soglia = -1;
    private int attuale = 0;
    private File repositoryFile = null;
    private String idTransazione;
    private String tipoMessaggio;
    private File f = null;
    private boolean fLocked = false;
    private FileOutputStream fout = null;

    DumpByteArrayOutputStream_FastImpl() {
    }

    DumpByteArrayOutputStream_FastImpl(Integer soglia, File repositoryFile, String idTransazione, String tipoMessaggio) {
        this.soglia = soglia;
        this.repositoryFile = repositoryFile;
        this.idTransazione = idTransazione;
        this.tipoMessaggio = tipoMessaggio;
    }

    private void checkInitFile() throws Exception {
        if (this.f == null) {
            this._checkInitFile();
        }
    }

    private synchronized void _checkInitFile() throws Exception {
        if (this.f == null) {
            this.f = DumpByteArrayOutputStream.newFile(this.repositoryFile, this.tipoMessaggio, this.idTransazione);
            super.flush();
            super.close();
            this.fout = new FileOutputStream(this.f);
            if (super.size() > 0) {
                super.writeTo((OutputStream)this.fout);
            }
        }
    }

    @Override
    public boolean isSerializedOnFileSystem() {
        return this.f != null;
    }

    @Override
    public File getSerializedFile() {
        return this.f;
    }

    @Override
    public void lock() {
        this.fLocked = true;
    }

    @Override
    public void unlock() {
        this.fLocked = false;
    }

    @Override
    public void writeInBuffer(int b) throws IOException {
        if (this.soglia > 0 && this.attuale > this.soglia) {
            try {
                ++this.attuale;
                if (this.f == null) {
                    this.checkInitFile();
                }
                if (this.fout == null) {
                    throw new Exception("FileOutputStream '" + this.f.getAbsolutePath() + "' closed");
                }
                this.fout.write(b);
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return;
        }
        ++this.attuale;
        super.write(b);
    }

    @Override
    public void writeInBuffer(byte[] b, int off, int len) throws IOException {
        if (this.soglia > 0 && (this.attuale > this.soglia || this.attuale + len > this.soglia)) {
            try {
                this.attuale += len;
                if (this.f == null) {
                    this.checkInitFile();
                }
                if (this.fout == null) {
                    throw new Exception("FileOutputStream '" + this.f.getAbsolutePath() + "' closed");
                }
                this.fout.write(b, off, len);
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return;
        }
        this.attuale += len;
        super.write(b, off, len);
    }

    @Override
    public void writeInBuffer(byte[] b) throws IOException {
        if (this.soglia > 0 && (this.attuale > this.soglia || this.attuale + b.length > this.soglia)) {
            try {
                this.attuale += b.length;
                if (this.f == null) {
                    this.checkInitFile();
                }
                if (this.fout == null) {
                    throw new Exception("FileOutputStream '" + this.f.getAbsolutePath() + "' closed");
                }
                this.fout.write(b);
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return;
        }
        this.attuale += b.length;
        super.write(b);
    }

    @Override
    public void reset() {
        this.clearResources();
    }

    @Override
    public void clearResources() {
        if (this.f != null) {
            this._clearResources();
        }
    }

    private synchronized void _clearResources() {
        if (this.f != null && !this.fLocked) {
            try {
                if (this.fout != null) {
                    this.fout.flush();
                    this.fout.close();
                    this.fout = null;
                }
                if (!this.f.delete()) {
                    // empty if block
                }
                this.f = null;
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @Override
    public int size() {
        if (this.f != null) {
            try {
                return (int)this.f.length();
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return super.size();
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        try {
            this.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.f != null) {
            try {
                CopyStream.copy(this.f, out);
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        } else {
            super.writeTo(out);
        }
    }

    private byte[] _toByteArrayFromFastStructure() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            super.writeTo((OutputStream)bout);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public byte[] toByteArray() {
        return this.serializeToByteArray();
    }

    @Override
    public byte[] serializeToByteArray() {
        try {
            this.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.f != null) {
            try {
                return FileSystemUtilities.readBytesFromFile(this.f);
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return this._toByteArrayFromFastStructure();
    }

    public String toString() {
        return this.serializeToString();
    }

    @Override
    public String serializeToString() {
        try {
            this.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.f != null) {
            try {
                return FileSystemUtilities.readFile(this.f);
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return new String(this._toByteArrayFromFastStructure());
    }

    @Override
    public String serializeToString(String charsetName) throws UnsupportedEncodingException {
        try {
            this.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.f != null) {
            try {
                return FileSystemUtilities.readFile(this.f, charsetName);
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return new String(this._toByteArrayFromFastStructure(), charsetName);
    }

    @Override
    public String serializeToString(Charset charset) throws UnsupportedEncodingException {
        try {
            this.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.f != null) {
            try {
                return FileSystemUtilities.readFile(this.f, charset);
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return new String(this._toByteArrayFromFastStructure(), charset.name());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() {
        if (this.f != null) {
            try {
                if (this.fout == null) return;
                this.fout.flush();
                this.fout.close();
                this.fout = null;
                return;
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        try {
            super.flush();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        super.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void flush() throws IOException {
        if (this.f != null) {
            try {
                if (this.fout == null) return;
                this.fout.flush();
                return;
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        } else {
            super.flush();
        }
    }

    @Override
    public InputStream getInputStream() {
        try {
            this.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.f != null) {
            try {
                return new FileInputStream(this.f);
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return super.getInputStream();
    }
}

