/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jdbc;

import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.AbstractJDBCAdapter;
import org.openspcoop2.utils.jdbc.BlobJDBCAdapter;
import org.openspcoop2.utils.jdbc.BytesJDBCAdapter;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterException;
import org.openspcoop2.utils.jdbc.StreamJDBCAdapter;

public class JDBCAdapterFactory {
    public static IJDBCAdapter createJDBCAdapter(TipiDatabase tipoDatabase) throws JDBCAdapterException {
        AbstractJDBCAdapter jdbcAdapter = null;
        if (TipiDatabase.POSTGRESQL.equals((Object)tipoDatabase)) {
            jdbcAdapter = new BytesJDBCAdapter(tipoDatabase);
        } else if (TipiDatabase.MYSQL.equals((Object)tipoDatabase)) {
            jdbcAdapter = new BlobJDBCAdapter(tipoDatabase);
        } else if (TipiDatabase.ORACLE.equals((Object)tipoDatabase)) {
            jdbcAdapter = new BlobJDBCAdapter(tipoDatabase);
        } else if (TipiDatabase.HSQL.equals((Object)tipoDatabase)) {
            jdbcAdapter = new BytesJDBCAdapter(tipoDatabase);
        } else if (TipiDatabase.DERBY.equals((Object)tipoDatabase)) {
            jdbcAdapter = new BytesJDBCAdapter(tipoDatabase);
        } else if (TipiDatabase.SQLSERVER.equals((Object)tipoDatabase)) {
            jdbcAdapter = new StreamJDBCAdapter(tipoDatabase);
        } else if (TipiDatabase.DB2.equals((Object)tipoDatabase)) {
            jdbcAdapter = new BlobJDBCAdapter(tipoDatabase);
        } else {
            throw new JDBCAdapterException("Tipo database non gestito [" + tipoDatabase + "]");
        }
        return jdbcAdapter;
    }

    public static IJDBCAdapter createJDBCAdapter(String tipoDatabase) throws JDBCAdapterException {
        return JDBCAdapterFactory.createJDBCAdapter(TipiDatabase.toEnumConstant(tipoDatabase));
    }
}

