/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jdbc;

import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterException;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.jdbc.JDBCDefaultForXSDType;

public class JDBCParameterUtilities {
    private TipiDatabase tipoDatabase = null;
    private IJDBCAdapter jdbcAdapter = null;

    public JDBCParameterUtilities(TipiDatabase tipoDatabaseOpenSPCoop2) throws JDBCAdapterException {
        this.tipoDatabase = tipoDatabaseOpenSPCoop2;
        this.jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter(this.tipoDatabase.getNome());
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value, Class<?> type) throws SQLException, UtilsException {
        if (type.isAssignableFrom(String.class)) {
            Object valueWrapped = null;
            if (value instanceof String) {
                valueWrapped = (String)value;
            } else if (value instanceof Character) {
                valueWrapped = "" + ((Character)value).charValue();
            } else if (value != null) {
                throw new UtilsException("Tipo[" + type.getName() + "] non compatibile con l'oggetto fornito[" + value.getClass().getName() + "]");
            }
            if (value == null) {
                pstmt.setNull(index, 12);
            } else {
                pstmt.setString(index, (String)valueWrapped);
            }
        } else if (type.isAssignableFrom(Character.class) || type.isAssignableFrom(Character.TYPE)) {
            Character valueWrapped = null;
            String charValue = null;
            if (value != null) {
                valueWrapped = (Character)value;
                char charPrimitiveValue = valueWrapped.charValue();
                charValue = "" + valueWrapped.charValue();
                if (charPrimitiveValue == '\u0000') {
                    charValue = null;
                }
            }
            if (charValue != null) {
                pstmt.setString(index, charValue);
            } else {
                pstmt.setNull(index, 12);
            }
        } else if (type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.TYPE)) {
            if (value != null) {
                Boolean valueWrapped = (Boolean)value;
                pstmt.setBoolean(index, valueWrapped);
            } else if (TipiDatabase.ORACLE.equals((Object)this.tipoDatabase) || TipiDatabase.DB2.equals((Object)this.tipoDatabase)) {
                pstmt.setNull(index, 4);
            } else {
                pstmt.setNull(index, 16);
            }
        } else if (type.isAssignableFrom(Byte.class) || type.isAssignableFrom(Byte.TYPE)) {
            if (value != null) {
                Byte valueWrapped = (Byte)value;
                pstmt.setInt(index, valueWrapped.intValue());
            } else {
                pstmt.setNull(index, 4);
            }
        } else if (type.isAssignableFrom(Short.class) || type.isAssignableFrom(Short.TYPE)) {
            if (value != null) {
                Short valueWrapped = (Short)value;
                pstmt.setShort(index, valueWrapped);
            } else {
                pstmt.setNull(index, 4);
            }
        } else if (type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Integer.TYPE)) {
            if (value != null) {
                Integer valueWrapped = (Integer)value;
                pstmt.setInt(index, valueWrapped);
            } else {
                pstmt.setNull(index, 4);
            }
        } else if (type.isAssignableFrom(Long.class) || type.isAssignableFrom(Long.TYPE)) {
            if (value != null) {
                Long valueWrapped = (Long)value;
                pstmt.setLong(index, valueWrapped);
            } else {
                pstmt.setNull(index, -5);
            }
        } else if (type.isAssignableFrom(BigInteger.class)) {
            if (value != null) {
                BigInteger valueWrapped = (BigInteger)value;
                pstmt.setLong(index, valueWrapped.longValue());
            } else {
                pstmt.setNull(index, -5);
            }
        } else if (type.isAssignableFrom(Float.class) || type.isAssignableFrom(Float.TYPE)) {
            if (value != null) {
                Float valueWrapped = (Float)value;
                pstmt.setFloat(index, valueWrapped.floatValue());
            } else {
                pstmt.setNull(index, 6);
            }
        } else if (type.isAssignableFrom(Double.class) || type.isAssignableFrom(Double.TYPE)) {
            if (value != null) {
                Double valueWrapped = (Double)value;
                pstmt.setDouble(index, valueWrapped);
            } else {
                pstmt.setNull(index, 8);
            }
        } else if (type.isAssignableFrom(BigDecimal.class)) {
            if (value != null) {
                BigDecimal valueWrapped = (BigDecimal)value;
                pstmt.setDouble(index, valueWrapped.doubleValue());
            } else {
                pstmt.setNull(index, 6);
            }
        } else if (type.isAssignableFrom(java.util.Date.class)) {
            java.util.Date valueWrapped = null;
            if (value != null) {
                valueWrapped = (java.util.Date)value;
            }
            if (value != null) {
                pstmt.setTimestamp(index, new Timestamp(valueWrapped.getTime()));
            } else {
                pstmt.setNull(index, 93);
            }
        } else if (type.isAssignableFrom(Date.class)) {
            Date valueWrapped = null;
            if (value != null) {
                valueWrapped = (Date)value;
            }
            if (value != null) {
                pstmt.setTimestamp(index, new Timestamp(valueWrapped.getTime()));
            } else {
                pstmt.setNull(index, 93);
            }
        } else if (type.isAssignableFrom(Timestamp.class)) {
            if (value != null) {
                Timestamp valueWrapped = (Timestamp)value;
                pstmt.setTimestamp(index, valueWrapped);
            } else {
                pstmt.setNull(index, 93);
            }
        } else if (type.isAssignableFrom(Calendar.class)) {
            Calendar valueWrapped = null;
            if (value != null) {
                valueWrapped = (Calendar)value;
            }
            if (value != null) {
                pstmt.setTimestamp(index, new Timestamp(valueWrapped.getTime().getTime()));
            } else {
                pstmt.setNull(index, 93);
            }
        } else if (type.isAssignableFrom(byte[].class)) {
            byte[] valueWrapped = null;
            if (value != null) {
                valueWrapped = (byte[])value;
            }
            this.jdbcAdapter.setBinaryData(pstmt, index, valueWrapped);
        } else if (type.isAssignableFrom(URI.class)) {
            if (value != null) {
                URI valueWrapped = (URI)value;
                pstmt.setString(index, valueWrapped.toString());
            } else {
                pstmt.setNull(index, 93);
            }
        } else {
            throw new SQLException("Tipo di oggetto (posizione " + index + ") non gestito: " + type.getClass().getName() + " - " + type);
        }
    }

    public String readStringParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (String)this.readParameter(rs, index, String.class);
    }

    public String readStringParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (String)this.readParameter(rs, name, String.class);
    }

    public Character readCharParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Character)this.readParameter(rs, index, Character.class);
    }

    public Character readCharParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Character)this.readParameter(rs, name, Character.class);
    }

    public Boolean readBooleanParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Boolean)this.readParameter(rs, index, Boolean.class);
    }

    public Boolean readBooleanParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Boolean)this.readParameter(rs, name, Boolean.class);
    }

    public Byte readByteParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Byte)this.readParameter(rs, index, Byte.class);
    }

    public Byte readByteParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Byte)this.readParameter(rs, name, Byte.class);
    }

    public Short readShortParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Short)this.readParameter(rs, index, Short.class);
    }

    public Short readShortParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Short)this.readParameter(rs, name, Short.class);
    }

    public Integer readIntegerParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Integer)this.readParameter(rs, index, Integer.class);
    }

    public Integer readIntegerParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Integer)this.readParameter(rs, name, Integer.class);
    }

    public Long readLongParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Long)this.readParameter(rs, index, Long.class);
    }

    public Long readLongParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Long)this.readParameter(rs, name, Long.class);
    }

    public BigInteger readBigIntegerParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (BigInteger)this.readParameter(rs, index, BigInteger.class);
    }

    public BigInteger readBigIntegerParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (BigInteger)this.readParameter(rs, name, BigInteger.class);
    }

    public Float readFloatParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Float)this.readParameter(rs, index, Float.class);
    }

    public Float readFloatParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Float)this.readParameter(rs, name, Float.class);
    }

    public Double readDoubleParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Double)this.readParameter(rs, index, Double.class);
    }

    public Double readDoubleParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Double)this.readParameter(rs, name, Double.class);
    }

    public BigDecimal readBigDecimalParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (BigDecimal)this.readParameter(rs, index, BigDecimal.class);
    }

    public BigDecimal readBigDecimalParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (BigDecimal)this.readParameter(rs, name, BigDecimal.class);
    }

    public java.util.Date readDateParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (java.util.Date)this.readParameter(rs, index, java.util.Date.class);
    }

    public java.util.Date readDateParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (java.util.Date)this.readParameter(rs, name, java.util.Date.class);
    }

    public Date readSqlDateParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Date)this.readParameter(rs, index, Date.class);
    }

    public Date readSqlDateParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Date)this.readParameter(rs, name, Date.class);
    }

    public Timestamp readTimestampParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Timestamp)this.readParameter(rs, index, Timestamp.class);
    }

    public Timestamp readTimestampParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Timestamp)this.readParameter(rs, name, Timestamp.class);
    }

    public Calendar readCalendarParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (Calendar)this.readParameter(rs, index, Calendar.class);
    }

    public Calendar readCalendarParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (Calendar)this.readParameter(rs, name, Calendar.class);
    }

    public URI readURIParameter(ResultSet rs, int index) throws SQLException, UtilsException {
        return (URI)this.readParameter(rs, index, URI.class);
    }

    public URI readURIParameter(ResultSet rs, String name) throws SQLException, UtilsException {
        return (URI)this.readParameter(rs, name, URI.class);
    }

    public Object readParameter(ResultSet rs, int index, Class<?> type) throws SQLException, UtilsException {
        return this.readParameter(rs, index, null, type, JDBCDefaultForXSDType.NONE);
    }

    public Object readParameter(ResultSet rs, String name, Class<?> type) throws SQLException, UtilsException {
        return this.readParameter(rs, -1, name, type, JDBCDefaultForXSDType.NONE);
    }

    public Object readParameter(ResultSet rs, String name, Class<?> type, JDBCDefaultForXSDType jdbcDefaultForXSDType) throws SQLException, UtilsException {
        return this.readParameter(rs, -1, name, type, jdbcDefaultForXSDType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readParameter(ResultSet rs, int index, String name, Class<?> type, JDBCDefaultForXSDType jdbcDefaultForXSDType) throws SQLException, UtilsException {
        if (type.toString().equals(String.class.toString())) {
            if (name != null) {
                return rs.getString(name);
            }
            return rs.getString(index);
        }
        if (type.toString().equals(Character.class.toString()) || type.toString().equals(Character.TYPE.toString())) {
            String s = null;
            s = name != null ? rs.getString(name) : rs.getString(index);
            if (s != null) {
                return Character.valueOf(s.charAt(0));
            }
            if (type.toString().equals(Character.TYPE.toString())) {
                return Character.valueOf('\u0000');
            }
            return null;
        }
        if (type.toString().equals(Boolean.class.toString()) || type.toString().equals(Boolean.TYPE.toString())) {
            boolean booleanValue = name != null ? rs.getBoolean(name) : rs.getBoolean(index);
            if (type.toString().equals(Boolean.class.toString()) && rs.wasNull()) {
                return null;
            }
            return booleanValue;
        }
        if (type.toString().equals(Byte.class.toString()) || type.toString().equals(Byte.TYPE.toString())) {
            byte byteValue = name != null ? (byte)rs.getInt(name) : (byte)rs.getInt(index);
            if (byteValue == 0 && jdbcDefaultForXSDType != null && JDBCDefaultForXSDType.FORCE_ZERO_AS_NULL.equals((Object)jdbcDefaultForXSDType)) {
                return null;
            }
            if (type.toString().equals(Byte.class.toString()) && rs.wasNull()) {
                return null;
            }
            return byteValue;
        }
        if (type.toString().equals(Short.class.toString()) || type.toString().equals(Short.TYPE.toString())) {
            short shortValue = name != null ? rs.getShort(name) : rs.getShort(index);
            if (shortValue == 0 && jdbcDefaultForXSDType != null && JDBCDefaultForXSDType.FORCE_ZERO_AS_NULL.equals((Object)jdbcDefaultForXSDType)) {
                return null;
            }
            if (type.toString().equals(Short.class.toString()) && rs.wasNull()) {
                return null;
            }
            return shortValue;
        }
        if (type.toString().equals(Integer.class.toString()) || type.toString().equals(Integer.TYPE.toString())) {
            int intValue = name != null ? rs.getInt(name) : rs.getInt(index);
            if (intValue == 0 && jdbcDefaultForXSDType != null && JDBCDefaultForXSDType.FORCE_ZERO_AS_NULL.equals((Object)jdbcDefaultForXSDType)) {
                return null;
            }
            if (type.toString().equals(Integer.class.toString()) && rs.wasNull()) {
                return null;
            }
            return intValue;
        }
        if (type.toString().equals(Long.class.toString()) || type.toString().equals(Long.TYPE.toString())) {
            long longValue = name != null ? rs.getLong(name) : rs.getLong(index);
            if (longValue == 0L && jdbcDefaultForXSDType != null && JDBCDefaultForXSDType.FORCE_ZERO_AS_NULL.equals((Object)jdbcDefaultForXSDType)) {
                return null;
            }
            if (type.toString().equals(Long.class.toString()) && rs.wasNull()) {
                return null;
            }
            return longValue;
        }
        if (type.toString().equals(BigInteger.class.toString())) {
            long longValue = name != null ? rs.getLong(name) : rs.getLong(index);
            if (longValue == 0L && jdbcDefaultForXSDType != null && JDBCDefaultForXSDType.FORCE_ZERO_AS_NULL.equals((Object)jdbcDefaultForXSDType)) {
                return null;
            }
            if (rs.wasNull()) {
                return null;
            }
            return BigInteger.valueOf(longValue);
        }
        if (type.toString().equals(Float.class.toString()) || type.toString().equals(Float.TYPE.toString())) {
            float floatValue = name != null ? rs.getFloat(name) : rs.getFloat(index);
            if (floatValue == 0.0f && jdbcDefaultForXSDType != null && JDBCDefaultForXSDType.FORCE_ZERO_AS_NULL.equals((Object)jdbcDefaultForXSDType)) {
                return null;
            }
            if (type.toString().equals(Float.class.toString()) && rs.wasNull()) {
                return null;
            }
            return Float.valueOf(floatValue);
        }
        if (type.toString().equals(Double.class.toString()) || type.toString().equals(Double.TYPE.toString())) {
            double doubleValue = name != null ? rs.getDouble(name) : rs.getDouble(index);
            if (doubleValue == 0.0 && jdbcDefaultForXSDType != null && JDBCDefaultForXSDType.FORCE_ZERO_AS_NULL.equals((Object)jdbcDefaultForXSDType)) {
                return null;
            }
            if (type.toString().equals(Double.class.toString()) && rs.wasNull()) {
                return null;
            }
            return doubleValue;
        }
        if (type.toString().equals(BigDecimal.class.toString())) {
            double doubleValue = name != null ? rs.getDouble(name) : rs.getDouble(index);
            if (doubleValue == 0.0 && jdbcDefaultForXSDType != null && JDBCDefaultForXSDType.FORCE_ZERO_AS_NULL.equals((Object)jdbcDefaultForXSDType)) {
                return null;
            }
            if (rs.wasNull()) {
                return null;
            }
            return BigDecimal.valueOf(doubleValue);
        }
        if (type.toString().equals(java.util.Date.class.toString())) {
            Timestamp ts = null;
            ts = name != null ? rs.getTimestamp(name) : rs.getTimestamp(index);
            if (ts != null) {
                return new java.util.Date(ts.getTime());
            }
            return null;
        }
        if (type.toString().equals(Date.class.toString())) {
            Timestamp ts = null;
            ts = name != null ? rs.getTimestamp(name) : rs.getTimestamp(index);
            if (ts != null) {
                return new Date(ts.getTime());
            }
            return null;
        }
        if (type.toString().equals(Timestamp.class.toString())) {
            if (name != null) {
                return rs.getTimestamp(name);
            }
            return rs.getTimestamp(index);
        }
        if (type.toString().equals(Calendar.class.toString())) {
            Timestamp ts = null;
            ts = name != null ? rs.getTimestamp(name) : rs.getTimestamp(index);
            if (ts != null) {
                Calendar c = Calendar.getInstance();
                c.setTime(new java.util.Date(ts.getTime()));
                return c;
            }
            return null;
        }
        if (type.isAssignableFrom(byte[].class)) {
            InputStream binaryStream = null;
            binaryStream = name != null ? this.jdbcAdapter.getBinaryStream(rs, name) : this.jdbcAdapter.getBinaryStream(rs, index);
            if (binaryStream == null) {
                return null;
            }
            try {
                byte[] c = Utilities.getAsByteArray(binaryStream, false);
                return c;
            }
            finally {
                try {
                    binaryStream.close();
                }
                catch (Exception exception) {}
            }
        }
        if (type.isAssignableFrom(URI.class)) {
            String uri = null;
            uri = name != null ? rs.getString(name) : rs.getString(index);
            if (uri != null) {
                try {
                    return new URI(uri);
                }
                catch (Exception e) {
                    throw new UtilsException(e.getMessage(), e);
                }
            }
            return null;
        }
        if (name != null) {
            throw new SQLException("Tipo di oggetto (nome " + name + ") non gestito: " + type.getClass().getName() + " - " + type);
        }
        throw new SQLException("Tipo di oggetto (posizione " + index + ") non gestito: " + type.getClass().getName() + " - " + type);
    }
}

