/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.AbstractJDBCAdapter;

public class StreamJDBCAdapter
extends AbstractJDBCAdapter {
    public StreamJDBCAdapter(TipiDatabase tipoDatabase) {
        super(tipoDatabase);
    }

    @Override
    public byte[] getBinaryData(ResultSet rs, int index) throws UtilsException, SQLException {
        return this.readIs(rs.getBinaryStream(index), "" + index);
    }

    @Override
    public byte[] getBinaryData(ResultSet rs, String rsName) throws UtilsException, SQLException {
        return this.readIs(rs.getBinaryStream(rsName), rsName);
    }

    @Override
    public void setBinaryData(PreparedStatement s, int index, byte[] data) throws UtilsException, SQLException {
        if (data != null && data.length > 0) {
            ByteArrayInputStream bin = null;
            try {
                bin = new ByteArrayInputStream(data);
            }
            catch (Exception e) {
                throw new UtilsException("StreamJDBCAppender error, set binary parameter [indice:" + index + "]" + e.getMessage());
            }
            s.setBinaryStream(index, (InputStream)bin, data.length);
        } else {
            s.setBinaryStream(index, (InputStream)null, 0);
        }
    }

    private byte[] readIs(InputStream is, String indice) throws UtilsException {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            CopyStream.copy(is, (OutputStream)os);
            is.close();
            byte[] dati = os.toByteArray();
            os.close();
            return dati;
        }
        catch (Exception e) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException("StreamJDBCAppender error, reading binary parameter [indice:" + indice + "]" + e.getMessage(), e);
        }
    }
}

