/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.json.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.SpecVersionDetector;
import com.networknt.schema.ValidationMessage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Set;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.json.IJsonSchemaValidator;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.json.JsonSchemaValidatorConfig;
import org.openspcoop2.utils.json.ValidationException;
import org.openspcoop2.utils.json.ValidationResponse;
import org.openspcoop2.utils.json.validation.ValidationUtils;
import org.slf4j.Logger;

public class NetworkNTJsonschemaValidator
implements IJsonSchemaValidator {
    private JsonSchema schema;
    private byte[] schemaBytes;
    private JsonNode jsonSchema;
    private ObjectMapper mapper = new ObjectMapper();
    private Logger log;
    private boolean logError;
    private SchemaValidatorsConfig schemaValidatorConfig = null;

    public SchemaValidatorsConfig getSchemaValidatorConfig() {
        return this.schemaValidatorConfig;
    }

    public void setSchemaValidatorConfig(SchemaValidatorsConfig schemaValidatorConfig) {
        this.schemaValidatorConfig = schemaValidatorConfig;
    }

    @Override
    public void setSchema(byte[] schema, JsonSchemaValidatorConfig config, Logger log) throws ValidationException {
        this.log = log;
        if (this.log == null) {
            this.log = LoggerWrapperFactory.getLogger(NetworkNTJsonschemaValidator.class);
        }
        this.logError = config != null ? config.isEmitLogError() : true;
        this.schemaBytes = schema;
        try {
            JsonNode jsonSchema = this.mapper.readTree(schema);
            SpecVersion.VersionFlag version = null;
            version = config != null && config.getJsonSchemaVersion() != null ? config.getJsonSchemaVersion() : SpecVersionDetector.detect((JsonNode)jsonSchema);
            JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)version);
            if (config != null) {
                switch (config.getAdditionalProperties()) {
                    case DEFAULT: {
                        break;
                    }
                    case FORCE_DISABLE: {
                        ValidationUtils.disableAdditionalProperties(this.mapper, jsonSchema, true, true);
                        break;
                    }
                    case FORCE_STRING: {
                        ValidationUtils.disableAdditionalProperties(this.mapper, jsonSchema, false, true);
                        break;
                    }
                    case IF_NULL_DISABLE: {
                        ValidationUtils.disableAdditionalProperties(this.mapper, jsonSchema, true, false);
                        break;
                    }
                    case IF_NULL_STRING: {
                        ValidationUtils.disableAdditionalProperties(this.mapper, jsonSchema, false, false);
                        break;
                    }
                }
            }
            if (config != null) {
                switch (config.getPoliticaInclusioneTipi()) {
                    case DEFAULT: {
                        break;
                    }
                    case ALL: {
                        ValidationUtils.addTypes(this.mapper, jsonSchema, config.getTipi(), true);
                        break;
                    }
                    case ANY: {
                        ValidationUtils.addTypes(this.mapper, jsonSchema, config.getTipi(), false);
                        break;
                    }
                }
            }
            if (config != null && config.isVerbose()) {
                try {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    JSONUtils.getInstance(true).writeTo(jsonSchema, (OutputStream)bout);
                    bout.flush();
                    bout.close();
                    this.log.debug("JSON Schema: " + bout.toString());
                }
                catch (Exception e) {
                    this.log.debug("JSON Schema build error: " + e.getMessage(), (Throwable)e);
                }
            }
            this.jsonSchema = jsonSchema;
            this.schema = this.schemaValidatorConfig != null ? factory.getSchema(jsonSchema, this.schemaValidatorConfig) : factory.getSchema(jsonSchema);
        }
        catch (Throwable e) {
            throw new ValidationException(e);
        }
    }

    @Override
    public ValidationResponse validate(byte[] rawObject) throws ValidationException {
        ValidationResponse response = new ValidationResponse();
        try {
            Object messageString;
            boolean expectedString = false;
            if (this.jsonSchema.has("type")) {
                try {
                    JsonNode type = this.jsonSchema.get("type");
                    String vType = type.asText();
                    expectedString = "string".equals(vType);
                }
                catch (Exception type) {
                    // empty catch block
                }
            }
            Object node = null;
            try {
                node = expectedString ? this.mapper.getNodeFactory().textNode(new String(rawObject)) : this.mapper.readTree(rawObject);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                messageString = "Read rawObject as jsonNode failed: " + e.getMessage();
                response.setEsito(ValidationResponse.ESITO.KO);
                if (this.logError) {
                    ValidationUtils.logError(this.log, ((String)messageString).toString(), rawObject, this.schemaBytes, this.jsonSchema);
                }
                response.setException(new Exception(((String)messageString).toString()));
            }
            if (node != null) {
                Set validate = this.schema.validate(node);
                if (validate.isEmpty()) {
                    response.setEsito(ValidationResponse.ESITO.OK);
                } else {
                    response.setEsito(ValidationResponse.ESITO.KO);
                    messageString = new StringBuilder();
                    for (ValidationMessage msg : validate) {
                        String errorMsg = msg.getCode() + " " + msg.getMessage();
                        response.getErrors().add(errorMsg);
                        ((StringBuilder)messageString).append(errorMsg).append("\n");
                    }
                    if (this.logError) {
                        ValidationUtils.logError(this.log, ((StringBuilder)messageString).toString(), rawObject, this.schemaBytes, this.jsonSchema);
                    }
                    response.setException(new Exception(((StringBuilder)messageString).toString()));
                }
            }
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
        return response;
    }
}

