/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.openapi.validator.swagger;

import com.atlassian.oai.validator.interaction.request.CustomRequestValidator;
import com.atlassian.oai.validator.interaction.request.RequestValidator;
import com.atlassian.oai.validator.model.ApiOperation;
import com.atlassian.oai.validator.model.Body;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.report.LevelResolver;
import com.atlassian.oai.validator.report.MessageResolver;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.schema.SchemaValidator;
import com.atlassian.oai.validator.schema.transform.AdditionalPropertiesInjectionTransformer;
import com.atlassian.oai.validator.util.ContentTypeUtils;
import com.google.common.net.MediaType;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.openspcoop2.utils.openapi.validator.OpenapiLibraryValidatorConfig;
import org.openspcoop2.utils.openapi.validator.swagger.SwaggerValidatorUtils;

public class SwaggerRequestValidator {
    private final MessageResolver normalValidatorMessages;
    private final SchemaValidator normalSchemaValidator;
    private final RequestValidator normalValidator;
    private final MessageResolver fileValidatorMessages;
    private final SchemaValidator fileSchemaValidator;
    private final RequestValidator fileValidator;
    private final boolean validateWildcardSubtypeAsJson;

    public SwaggerRequestValidator(OpenAPI openApi, OpenapiLibraryValidatorConfig config) {
        List transformers;
        this.validateWildcardSubtypeAsJson = config.isValidateWildcardSubtypeAsJson();
        LevelResolver.Builder errorLevelResolverBuilder = SwaggerRequestValidator.getLevelResolverBuilder(config);
        this.normalValidatorMessages = new MessageResolver(errorLevelResolverBuilder.build());
        this.normalSchemaValidator = new SchemaValidator(openApi, this.normalValidatorMessages);
        if (!config.isSwaggerRequestValidator_InjectingAdditionalPropertiesFalse()) {
            transformers = this.normalSchemaValidator.transformers;
            this.normalSchemaValidator.transformers = transformers.stream().filter(t -> t != AdditionalPropertiesInjectionTransformer.getInstance()).collect(Collectors.toList());
        }
        this.normalValidator = new RequestValidator(this.normalSchemaValidator, this.normalValidatorMessages, openApi, Arrays.asList(new CustomRequestValidator[0]));
        errorLevelResolverBuilder.withLevel("validation.request.body", ValidationReport.Level.IGNORE);
        errorLevelResolverBuilder.withLevel("validation.request.body.missing", ValidationReport.Level.ERROR);
        this.fileValidatorMessages = new MessageResolver(errorLevelResolverBuilder.build());
        this.fileSchemaValidator = new SchemaValidator(openApi, this.fileValidatorMessages);
        if (!config.isSwaggerRequestValidator_InjectingAdditionalPropertiesFalse()) {
            transformers = this.fileSchemaValidator.transformers;
            this.fileSchemaValidator.transformers = transformers.stream().filter(t -> t != AdditionalPropertiesInjectionTransformer.getInstance()).collect(Collectors.toList());
        }
        this.fileValidator = new RequestValidator(this.fileSchemaValidator, this.fileValidatorMessages, openApi, Arrays.asList(new CustomRequestValidator[0]));
    }

    public ValidationReport validateRequest(Request request, ApiOperation apiOperation) {
        boolean isContentRequired;
        RequestBody requestBodySchema = apiOperation.getOperation().getRequestBody();
        if (requestBodySchema == null) {
            return this.normalValidator.validateRequest(request, apiOperation);
        }
        Content contentSchema = requestBodySchema.getContent();
        boolean bl = isContentRequired = requestBodySchema.getRequired() == null ? false : requestBodySchema.getRequired();
        if (isContentRequired && contentSchema != null && !contentSchema.isEmpty() && request.getContentType().isEmpty()) {
            return ValidationReport.singleton((ValidationReport.Message)this.normalValidatorMessages.create("validation.request.contentType.notAllowed", "[REQUEST] Required Content-Type is missing", new String[0]));
        }
        if (request.getRequestBody().isPresent() && request.getContentType().isEmpty()) {
            return ValidationReport.singleton((ValidationReport.Message)this.normalValidatorMessages.create("validation.request.contentType.notAllowed", "[REQUEST] Empty Content-Type not allowed if body is present", new String[0]));
        }
        Optional<Pair<String, io.swagger.v3.oas.models.media.MediaType>> maybeMediaType = this.findApiMediaTypeForRequest(request, requestBodySchema);
        if (maybeMediaType.isEmpty()) {
            return this.normalValidator.validateRequest(request, apiOperation);
        }
        io.swagger.v3.oas.models.media.MediaType type = (io.swagger.v3.oas.models.media.MediaType)maybeMediaType.get().getRight();
        MediaType requestMediaType = MediaType.parse((String)((String)maybeMediaType.get().getLeft()));
        ValidationReport report = ValidationReport.empty();
        Body requestBody = request.getRequestBody().orElse(null);
        if (SwaggerValidatorUtils.isBinarySchemaFile(type.getSchema()) && requestBody != null) {
            if (ContentTypeUtils.isJsonContentType((Request)request)) {
                report = report.merge(SwaggerValidatorUtils.validateJsonFormat(requestBody, this.normalValidatorMessages, true)).merge(this.fileValidator.validateRequest(request, apiOperation));
            }
        } else {
            report = SwaggerValidatorUtils.isBase64SchemaFile(type.getSchema()) && requestBody != null ? report.merge(SwaggerValidatorUtils.validateBase64Body(requestBody, this.normalValidatorMessages, true)).merge(this.fileValidator.validateRequest(request, apiOperation)) : (this.validateWildcardSubtypeAsJson && requestMediaType.subtype().equals("*") ? this.normalSchemaValidator.validate(() -> ((Body)request.getRequestBody().get()).toJsonNode(), type.getSchema(), "request.body").merge(this.normalValidator.validateRequest(request, apiOperation)) : this.normalValidator.validateRequest(request, apiOperation));
        }
        return report;
    }

    private static LevelResolver.Builder getLevelResolverBuilder(OpenapiLibraryValidatorConfig config) {
        LevelResolver.Builder errorLevelResolver = LevelResolver.create();
        if (!config.isValidateRequestPath()) {
            errorLevelResolver.withLevel("validation.request.path.missing", ValidationReport.Level.IGNORE);
        }
        if (!config.isValidateRequestQuery()) {
            errorLevelResolver.withLevel("validation.request.parameter.query", ValidationReport.Level.IGNORE);
        }
        if (!config.isValidateRequestUnexpectedQueryParam()) {
            errorLevelResolver.withLevel("validation.request.parameter.query.unexpected", ValidationReport.Level.IGNORE);
        }
        if (!config.isValidateRequestHeaders()) {
            errorLevelResolver.withLevel("validation.request.parameter.header", ValidationReport.Level.IGNORE);
        }
        if (!config.isValidateRequestCookie()) {
            errorLevelResolver.withLevel("validation.request.parameter.cookie", ValidationReport.Level.IGNORE);
        }
        if (!config.isValidateRequestBody()) {
            errorLevelResolver.withLevel("validation.request.body", ValidationReport.Level.IGNORE);
        }
        return errorLevelResolver;
    }

    private Optional<Pair<String, io.swagger.v3.oas.models.media.MediaType>> findApiMediaTypeForRequest(Request request, RequestBody apiRequestBodyDefinition) {
        return Optional.ofNullable(apiRequestBodyDefinition).map(RequestBody::getContent).flatMap(content -> ContentTypeUtils.findMostSpecificMatch((Request)request, (Set)content.keySet()).map(mostSpecificMatch -> Pair.of((Object)mostSpecificMatch, (Object)((io.swagger.v3.oas.models.media.MediaType)content.get(mostSpecificMatch)))));
    }
}

