/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.pdf;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.apache.pdfbox.pdmodel.interactive.form.PDXFAResource;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.pdf.AbstractPDFCore;
import org.openspcoop2.utils.pdf.EmbeddedFile;
import org.openspcoop2.utils.pdf.PDFSignature;
import org.openspcoop2.utils.pdf.XFADocument;

public class PDFReader
extends AbstractPDFCore {
    private List<PDFSignature> pdfSignatures = null;

    public PDFReader(PDDocument doc) throws UtilsException {
        super(doc);
    }

    public PDFReader(byte[] content) throws UtilsException {
        super(content, false);
    }

    public PDFReader(File doc) throws UtilsException {
        super(doc, false);
    }

    public PDFReader(InputStream is) throws UtilsException {
        super(is, false);
    }

    public PDFReader(byte[] content, boolean analyzeSignature) throws UtilsException {
        super(content, analyzeSignature);
        if (analyzeSignature) {
            this.initSignature();
        }
    }

    public PDFReader(File doc, boolean analyzeSignature) throws UtilsException {
        super(doc, analyzeSignature);
        if (analyzeSignature) {
            this.initSignature();
        }
    }

    public PDFReader(InputStream is, boolean analyzeSignature) throws UtilsException {
        super(is, analyzeSignature);
        if (analyzeSignature) {
            this.initSignature();
        }
    }

    public Map<String, EmbeddedFile> getEmbeddedFiles(boolean analyzeKids) throws UtilsException {
        HashMap<String, EmbeddedFile> map = new HashMap<String, EmbeddedFile>();
        this.checkDocumentCatalog();
        try {
            PDDocumentNameDictionary namesDictionary = new PDDocumentNameDictionary(this.document.getDocumentCatalog());
            PDEmbeddedFilesNameTreeNode efTree = namesDictionary.getEmbeddedFiles();
            if (efTree != null) {
                Map names = efTree.getNames();
                if (names != null && !names.isEmpty()) {
                    this.readEmbeddedFiles(names, map);
                }
                if (analyzeKids) {
                    this.readEmbeddedFilesFromKids(efTree, map);
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        return map;
    }

    private void readEmbeddedFilesFromKids(PDEmbeddedFilesNameTreeNode efTree, Map<String, EmbeddedFile> map) throws UtilsException {
        try {
            List kids = efTree.getKids();
            if (kids != null && !kids.isEmpty()) {
                for (PDNameTreeNode node : kids) {
                    Map names = node.getNames();
                    this.readEmbeddedFiles(names, map);
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private void readEmbeddedFiles(Map<String, PDComplexFileSpecification> names, Map<String, EmbeddedFile> map) throws UtilsException {
        for (Map.Entry<String, PDComplexFileSpecification> entry : names.entrySet()) {
            PDComplexFileSpecification fileSpec = entry.getValue();
            EmbeddedFile internalDoc = this.createPDFInternalDocument(fileSpec);
            if (internalDoc == null) continue;
            Object fileName = internalDoc.getFilename() != null ? internalDoc.getFilename() : "file-" + map.size() + "1";
            map.put((String)fileName, internalDoc);
        }
    }

    private EmbeddedFile createPDFInternalDocument(PDComplexFileSpecification fileSpec) throws UtilsException {
        try {
            EmbeddedFile internalDoc = null;
            String filename = this.getFileName(fileSpec);
            PDEmbeddedFile embeddedFile = this.getEmbeddedFile(fileSpec);
            if (embeddedFile != null) {
                internalDoc = new EmbeddedFile();
                internalDoc.setFileSpec(fileSpec);
                internalDoc.setEmbeddedFile(embeddedFile);
                internalDoc.setFilename(filename);
                internalDoc.setContent(embeddedFile.toByteArray());
                internalDoc.setMediaType(embeddedFile.getSubtype());
            }
            return internalDoc;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private String getFileName(PDComplexFileSpecification fileSpec) {
        String filename = null;
        if (fileSpec != null) {
            filename = fileSpec.getFileUnicode();
            if (filename == null) {
                filename = fileSpec.getFileDos();
            }
            if (filename == null) {
                filename = fileSpec.getFileMac();
            }
            if (filename == null) {
                filename = fileSpec.getFileUnix();
            }
            if (filename == null) {
                filename = fileSpec.getFile();
            }
        }
        return filename;
    }

    private PDEmbeddedFile getEmbeddedFile(PDComplexFileSpecification fileSpec) {
        PDEmbeddedFile embeddedFile = null;
        if (fileSpec != null) {
            embeddedFile = fileSpec.getEmbeddedFileUnicode();
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileDos();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileMac();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileUnix();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFile();
            }
        }
        return embeddedFile;
    }

    public Map<String, EmbeddedFile> getAnnotationFiles() throws UtilsException {
        HashMap<String, EmbeddedFile> map = new HashMap<String, EmbeddedFile>();
        try {
            if (this.document.getPages() != null) {
                for (PDPage page : this.document.getPages()) {
                    this.readAnnotationFiles(page, map);
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        return map;
    }

    private void readAnnotationFiles(PDPage page, Map<String, EmbeddedFile> map) throws UtilsException {
        try {
            if (page != null && page.getAnnotations() != null) {
                for (PDAnnotation annotation : page.getAnnotations()) {
                    if (!(annotation instanceof PDAnnotationFileAttachment)) continue;
                    PDAnnotationFileAttachment annotationFileAttachment = (PDAnnotationFileAttachment)annotation;
                    this.readAnnotationFile(annotationFileAttachment, map);
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private void readAnnotationFile(PDAnnotationFileAttachment annotationFileAttachment, Map<String, EmbeddedFile> map) throws UtilsException {
        try {
            PDComplexFileSpecification fileSpec = (PDComplexFileSpecification)annotationFileAttachment.getFile();
            EmbeddedFile internalDoc = this.createPDFInternalDocument(fileSpec);
            if (internalDoc != null) {
                Object fileName = internalDoc.getFilename() != null ? internalDoc.getFilename() : "file-" + map.size() + "1";
                map.put((String)fileName, internalDoc);
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public XFADocument getXFAFile() throws UtilsException {
        this.checkDocumentCatalog();
        try {
            XFADocument doc = null;
            PDAcroForm pdAcroForm = this.document.getDocumentCatalog().getAcroForm();
            if (pdAcroForm != null && pdAcroForm.getXFA() != null) {
                PDXFAResource xfa = pdAcroForm.getXFA();
                doc = new XFADocument();
                doc.setXfa(xfa);
                doc.setDocument(xfa.getDocument());
                doc.setContent(xfa.getBytes());
            }
            return doc;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public boolean isSignaturesExist() {
        return this.document.getDocumentCatalog() != null && this.document.getDocumentCatalog().getAcroForm() != null && this.document.getDocumentCatalog().getAcroForm().isSignaturesExist();
    }

    private synchronized void initSignature() throws UtilsException {
        if (this.pdfSignatures == null) {
            this.checkDocumentCatalog();
            if (this.rawDocument == null) {
                throw new UtilsException("Initialize PDFReader with boolean parameter 'analyzeSignature' enabled");
            }
            try {
                PDAcroForm pdAcroForm = this.document.getDocumentCatalog().getAcroForm();
                if (pdAcroForm != null) {
                    Map<String, PDSignatureField> mapPDSignatureField = this.readMapSignatureField(pdAcroForm);
                    List signatures = this.document.getSignatureDictionaries();
                    this.pdfSignatures = this.readSignatures(signatures, mapPDSignatureField);
                } else {
                    this.pdfSignatures = new ArrayList<PDFSignature>();
                }
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
    }

    private Map<String, PDSignatureField> readMapSignatureField(PDAcroForm pdAcroForm) throws UtilsException {
        try {
            HashMap<String, PDSignatureField> mapPDSignatureField = new HashMap<String, PDSignatureField>();
            for (PDField f : pdAcroForm.getFields()) {
                PDSignatureField signatureField;
                if (!(f instanceof PDSignatureField) || (signatureField = (PDSignatureField)f).getSignature() == null) continue;
                mapPDSignatureField.put(signatureField.getSignature().getName(), signatureField);
            }
            return mapPDSignatureField;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private List<PDFSignature> readSignatures(List<PDSignature> signatures, Map<String, PDSignatureField> mapPDSignatureField) throws UtilsException {
        try {
            ArrayList<PDFSignature> pdfSignaturesList = new ArrayList<PDFSignature>();
            if (signatures != null) {
                for (PDSignature signature : signatures) {
                    PDSignatureField signatureField = mapPDSignatureField.get(signature.getName());
                    if (signatureField == null) {
                        throw new UtilsException("SignatureField '" + signature.getName() + "' not found");
                    }
                    PDFSignature pdfSignature = new PDFSignature(this.rawDocument, signatureField, signature);
                    pdfSignaturesList.add(pdfSignature);
                }
            }
            return pdfSignaturesList;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public List<PDFSignature> getSignature() throws UtilsException {
        if (this.pdfSignatures == null) {
            this.initSignature();
        }
        return this.pdfSignatures;
    }
}

