/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.pdf;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.ExternalSigningSupport;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.pdf.AbstractPDFCore;
import org.openspcoop2.utils.pdf.PDFSignatureCMSTypedData;

public class PDFSigner
extends AbstractPDFCore {
    private PDSignature signature;

    public PDFSigner(PDDocument doc, PDSignature signature) throws UtilsException {
        super(doc);
        this.signature = signature;
    }

    public PDFSigner(byte[] content, PDSignature signature) throws UtilsException {
        super(content, false);
        this.signature = signature;
    }

    public PDFSigner(File doc, PDSignature signature) throws UtilsException {
        super(doc, false);
        this.signature = signature;
    }

    public PDFSigner(InputStream is, PDSignature signature) throws UtilsException {
        super(is, false);
        this.signature = signature;
    }

    public PDFSigner(PDDocument doc, String name, COSName filter, COSName subfilter, String location, String reason, String contactInfo) throws UtilsException {
        super(doc);
        this.init(name, filter, subfilter, location, reason, contactInfo);
    }

    public PDFSigner(byte[] content, String name, COSName filter, COSName subfilter, String location, String reason, String contactInfo) throws UtilsException {
        super(content, false);
        this.init(name, filter, subfilter, location, reason, contactInfo);
    }

    public PDFSigner(File doc, String name, COSName filter, COSName subfilter, String location, String reason, String contactInfo) throws UtilsException {
        super(doc, false);
        this.init(name, filter, subfilter, location, reason, contactInfo);
    }

    public PDFSigner(InputStream is, String name, COSName filter, COSName subfilter, String location, String reason, String contactInfo) throws UtilsException {
        super(is, false);
        this.init(name, filter, subfilter, location, reason, contactInfo);
    }

    private void init(String name, COSName filter, COSName subfilter, String location, String reason, String contactInfo) throws UtilsException {
        try {
            if (name == null) {
                throw new UtilsException("Name undefined");
            }
            this.signature = new PDSignature();
            this.signature.setName(name);
            this.signature.setFilter(filter);
            this.signature.setSubFilter(subfilter);
            this.signature.setLocation(location);
            this.signature.setReason(reason);
            this.signature.setContactInfo(contactInfo);
            this.signature.setSignDate(DateManager.getCalendar());
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void sign(KeyStore keystore, String privateKeyAlias, String privateKeyPassword, File fileOutput) throws UtilsException {
        this.sign(keystore, privateKeyAlias, privateKeyPassword, null, fileOutput);
    }

    public void sign(KeyStore keystore, String privateKeyAlias, String privateKeyPassword, String algorithm, File fileOutput) throws UtilsException {
        if (fileOutput == null) {
            throw new UtilsException("Output file undefined");
        }
        try (FileOutputStream fout = new FileOutputStream(fileOutput);){
            this.sign(keystore, privateKeyAlias, privateKeyPassword, algorithm, fout);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public byte[] sign(KeyStore keystore, String privateKeyAlias, String privateKeyPassword) throws UtilsException {
        String algorithm = null;
        return this.sign(keystore, privateKeyAlias, privateKeyPassword, algorithm);
    }

    public byte[] sign(KeyStore keystore, String privateKeyAlias, String privateKeyPassword, String algorithm) throws UtilsException {
        byte[] byArray;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            this.sign(keystore, privateKeyAlias, privateKeyPassword, algorithm, bout);
            bout.flush();
            byArray = bout.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bout.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        bout.close();
        return byArray;
    }

    public void sign(KeyStore keystore, String privateKeyAlias, String privateKeyPassword, OutputStream output) throws UtilsException {
        this.sign(keystore, privateKeyAlias, privateKeyPassword, null, output);
    }

    public void sign(KeyStore keystore, String privateKeyAlias, String privateKeyPassword, String algorithm, OutputStream output) throws UtilsException {
        try {
            this.document.addSignature(this.signature);
            ExternalSigningSupport externalSigning = this.document.saveIncrementalForExternalSigning(output);
            byte[] cmsSignature = this.sign(keystore, privateKeyAlias, privateKeyPassword, algorithm, externalSigning.getContent());
            externalSigning.setSignature(cmsSignature);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private byte[] sign(KeyStore keystore, String privateKeyAlias, String privateKeyPassword, String algorithm, InputStream content) throws UtilsException {
        if (keystore == null) {
            throw new UtilsException("KeyStore undefined");
        }
        if (privateKeyAlias == null) {
            throw new UtilsException("privateKeyAlias undefined");
        }
        if (privateKeyPassword == null) {
            throw new UtilsException("privateKeyPassword undefined");
        }
        try {
            Certificate[] certificateChain = keystore.getCertificateChain(privateKeyAlias);
            CMSSignedDataGenerator cmsSignedDataGenerator = new CMSSignedDataGenerator();
            X509Certificate cert = (X509Certificate)certificateChain[0];
            if (algorithm == null) {
                algorithm = "SHA256WithRSA";
            }
            ContentSigner signer = new JcaContentSignerBuilder(algorithm).build(keystore.getPrivateKey(privateKeyAlias, privateKeyPassword));
            cmsSignedDataGenerator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).build(signer, cert));
            cmsSignedDataGenerator.addCertificates((Store)new JcaCertStore(Arrays.asList(certificateChain)));
            PDFSignatureCMSTypedData signatureCMSTypedData = new PDFSignatureCMSTypedData(content, null);
            CMSSignedData signedData = cmsSignedDataGenerator.generate((CMSTypedData)signatureCMSTypedData, false);
            return signedData.getEncoded();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

