/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.rest;

import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.rest.ApiFormats;
import org.openspcoop2.utils.rest.IApiReader;
import org.openspcoop2.utils.rest.IApiValidator;
import org.openspcoop2.utils.rest.ProcessingException;

public class ApiFactory {
    public static IApiReader newApiReader(ApiFormats format) throws ProcessingException {
        if (format == null) {
            throw new ProcessingException("ApiFormat undefined");
        }
        Loader loader = new Loader();
        try {
            switch (format) {
                case WADL: {
                    return (IApiReader)loader.newInstance("org.openspcoop2.utils.wadl.WADLApiReader");
                }
                case SWAGGER_2: {
                    return (IApiReader)loader.newInstance("org.openspcoop2.utils.openapi.SwaggerApiReader");
                }
                case OPEN_API_3: {
                    return (IApiReader)loader.newInstance("org.openspcoop2.utils.openapi.OpenapiApiReader");
                }
            }
        }
        catch (Throwable t) {
            throw new ProcessingException(t.getMessage(), t);
        }
        throw new ProcessingException("ApiFormat [" + format + "] unsupported");
    }

    public static IApiValidator newApiValidator(ApiFormats format) throws ProcessingException {
        if (format == null) {
            throw new ProcessingException("ApiFormat undefined");
        }
        Loader loader = new Loader();
        try {
            switch (format) {
                case WADL: {
                    return (IApiValidator)loader.newInstance("org.openspcoop2.utils.wadl.validator.Validator");
                }
                case SWAGGER_2: {
                    return (IApiValidator)loader.newInstance("org.openspcoop2.utils.openapi.validator.Validator");
                }
                case OPEN_API_3: {
                    return (IApiValidator)loader.newInstance("org.openspcoop2.utils.openapi.validator.Validator");
                }
            }
        }
        catch (Throwable t) {
            throw new ProcessingException(t.getMessage(), t);
        }
        throw new ProcessingException("ApiFormat [" + format + "] unsupported");
    }
}

