/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.rest.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.utils.beans.BaseBean;
import org.openspcoop2.utils.rest.ProcessingException;
import org.openspcoop2.utils.rest.api.ApiRequest;
import org.openspcoop2.utils.rest.api.ApiResponse;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;

public class ApiOperation
extends BaseBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HttpRequestMethod httpMethod;
    private String path;
    private String description;
    private ApiRequest request;
    private List<ApiResponse> responses = new ArrayList<ApiResponse>();

    public ApiOperation(HttpRequestMethod httpMethod, String path) {
        this.httpMethod = httpMethod;
        this.path = path;
        this.normalizePath();
    }

    private void normalizePath() {
        if (this.path != null) {
            this.path = ApiOperation.normalizePath(this.path);
        }
    }

    public static String normalizePath(String pathParam) {
        Object path = pathParam;
        if (path != null) {
            if (!((String)(path = ((String)path).trim())).startsWith("/")) {
                path = "/" + (String)path;
            }
            while (((String)path).contains("${")) {
                path = ((String)path).replace("${", "{");
            }
            if (((String)path).length() > 1 && ((String)path).endsWith("/")) {
                path = ((String)path).substring(0, ((String)path).length() - 1);
            }
        }
        return path;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public HttpRequestMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(HttpRequestMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int sizePath() {
        return this._split(this.path).size();
    }

    public String getPath(int position) throws ProcessingException {
        List<String> tmp = this._split(this.path);
        if (position >= tmp.size()) {
            throw new ProcessingException("Path [" + this.path + "] (split:" + tmp.size() + ") non contiene posizione indicata (" + position + ")");
        }
        return tmp.get(position);
    }

    public String getDynamicPathId(int position) throws ProcessingException {
        List<String> tmp = this._split(this.path);
        if (position >= tmp.size()) {
            throw new ProcessingException("Path [" + this.path + "] (split:" + tmp.size() + ") non contiene posizione indicata (" + position + ")");
        }
        String p = tmp.get(position);
        return p.substring(0, p.length() - 1).substring(1);
    }

    public boolean isDynamicPath() {
        return this.path.contains("{");
    }

    public boolean isDynamicPath(int position) throws ProcessingException {
        List<String> tmp = this._split(this.path);
        if (position >= tmp.size()) {
            throw new ProcessingException("Path [" + this.path + "] (split:" + tmp.size() + ") non contiene posizione indicata (" + position + ")");
        }
        return tmp.get(position).startsWith("{") && tmp.get(position).endsWith("}");
    }

    private List<String> _split(String url) {
        ArrayList<String> l = new ArrayList<String>();
        for (String s : url.split("/")) {
            if (s == null || s.equals("")) continue;
            l.add(s);
        }
        return l;
    }

    public ApiRequest getRequest() {
        return this.request;
    }

    public void setRequest(ApiRequest request) {
        this.request = request;
    }

    public void addResponse(ApiResponse response) {
        this.responses.add(response);
    }

    public ApiResponse getResponse(int index) {
        return this.responses.get(index);
    }

    public ApiResponse removeResponse(int index) {
        return this.responses.remove(index);
    }

    public List<ApiResponse> getResponses() {
        return this.responses;
    }

    public void setResponses(List<ApiResponse> responses) {
        this.responses = responses;
    }

    public int sizeResponses() {
        return this.responses.size();
    }
}

