/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;
import org.openspcoop2.utils.security.AbstractCipher;
import org.openspcoop2.utils.security.CipherInfo;
import org.openspcoop2.utils.security.EncryptOpenSSLPass;
import org.openspcoop2.utils.security.OpenSSLEncryptionMode;

public class EncryptOpenSSLPassPBKDF2
extends AbstractCipher {
    private CipherInfo cipherInfo;
    private OpenSSLEncryptionMode mode;

    public static CipherInfo buildCipherInfo(String password, Integer iterationCount, OpenSSLEncryptionMode mode) throws UtilsException {
        CipherInfo cipherInfo = new CipherInfo();
        cipherInfo.setSalt(EncryptOpenSSLPass.buildSalt());
        EncryptOpenSSLPassPBKDF2.buildSecretKeyAndIV(password, cipherInfo.getSalt(), iterationCount, mode, cipherInfo);
        return cipherInfo;
    }

    static void buildSecretKeyAndIV(String password, byte[] salt, Integer iterationCountParam, OpenSSLEncryptionMode modeParam, CipherInfo cipherInfo) throws UtilsException {
        try {
            int keylen = -1;
            int ivlen = 16;
            OpenSSLEncryptionMode mode = modeParam != null ? modeParam : OpenSSLEncryptionMode.AES_256_CBC;
            switch (mode) {
                case AES_128_CBC: {
                    keylen = 16;
                    break;
                }
                case AES_192_CBC: {
                    keylen = 24;
                    break;
                }
                case AES_256_CBC: {
                    keylen = 32;
                }
            }
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            int iterationCount = iterationCountParam == null || iterationCountParam <= 0 ? 10000 : iterationCountParam;
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, iterationCount, (keylen + ivlen) * 8);
            SecretKey tmp = factory.generateSecret(spec);
            byte[] keyandIV = tmp.getEncoded();
            SecretKeySpec secretKey = new SecretKeySpec(keyandIV, 0, keylen, "AES");
            cipherInfo.setKey(secretKey);
            cipherInfo.setEncodedKey(secretKey.getEncoded());
            IvParameterSpec iv = EncryptOpenSSLPassPBKDF2.convertTo(keyandIV, keylen, ivlen);
            cipherInfo.setIv(iv.getIV());
            cipherInfo.setIvParameterSpec(iv);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    static IvParameterSpec convertTo(byte[] keyandIV, int keylen, int ivlen) {
        return new IvParameterSpec(keyandIV, keylen, ivlen);
    }

    public EncryptOpenSSLPassPBKDF2(String password) throws UtilsException {
        this(password, null, null);
    }

    public EncryptOpenSSLPassPBKDF2(String password, Integer iterationCount) throws UtilsException {
        this(password, iterationCount, null);
    }

    public EncryptOpenSSLPassPBKDF2(String password, OpenSSLEncryptionMode modeParam) throws UtilsException {
        this(password, null, modeParam);
    }

    public EncryptOpenSSLPassPBKDF2(String password, Integer iterationCount, OpenSSLEncryptionMode modeParam) throws UtilsException {
        super(1);
        this.mode = modeParam != null ? modeParam : OpenSSLEncryptionMode.AES_256_CBC;
        this.cipherInfo = EncryptOpenSSLPassPBKDF2.buildCipherInfo(password, iterationCount, this.mode);
        this.key = this.cipherInfo.getKey();
        this.ivParameterSpec = this.cipherInfo.getIvParameterSpec();
    }

    public byte[] encrypt(String data, String charsetName) throws UtilsException {
        return EncryptOpenSSLPass.formatOutput(this.cipherInfo.getSalt(), super.process(data, charsetName, EncryptOpenSSLPass.getAlgorithm(this.mode)));
    }

    public byte[] encrypt(byte[] data) throws UtilsException {
        return EncryptOpenSSLPass.formatOutput(this.cipherInfo.getSalt(), super.process(data, EncryptOpenSSLPass.getAlgorithm(this.mode)));
    }

    public byte[] encryptBase64(String data, String charsetName) throws UtilsException {
        return Base64Utilities.encode(this.encrypt(data, charsetName));
    }

    public byte[] encryptBase64(byte[] data) throws UtilsException {
        return Base64Utilities.encode(this.encrypt(data));
    }

    public String encryptBase64AsString(String data, String charsetName) throws UtilsException {
        return Base64Utilities.encodeAsString(this.encrypt(data, charsetName));
    }

    public String encryptBase64AsString(byte[] data) throws UtilsException {
        return Base64Utilities.encodeAsString(this.encrypt(data));
    }

    public char[] encryptHexBinary(String data, String charsetName) throws UtilsException {
        return HexBinaryUtilities.encode(this.encrypt(data, charsetName));
    }

    public char[] encryptHexBinary(byte[] data) throws UtilsException {
        return HexBinaryUtilities.encode(this.encrypt(data));
    }

    public String encryptHexBinaryAsString(String data, String charsetName) throws UtilsException {
        return HexBinaryUtilities.encodeAsString(this.encrypt(data, charsetName));
    }

    public String encryptHexBinaryAsString(byte[] data) throws UtilsException {
        return HexBinaryUtilities.encodeAsString(this.encrypt(data));
    }

    @Override
    public void initIV(String algorithm) throws UtilsException {
    }
}

