/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.HmacJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;
import org.apache.cxf.rt.security.crypto.HmacUtils;
import org.openspcoop2.utils.security.SecretKeyPkcs11;

public class HmacJwsSignatureProviderExtended
extends HmacJwsSignatureProvider {
    private SecretKeyPkcs11 secretKey;
    private AlgorithmParameterSpec hmacSpec;

    public HmacJwsSignatureProviderExtended(byte[] key, AlgorithmParameterSpec spec, SignatureAlgorithm algo) {
        super(key, spec, algo);
    }

    public HmacJwsSignatureProviderExtended(byte[] key, SignatureAlgorithm algo) {
        super(key, algo);
    }

    public HmacJwsSignatureProviderExtended(String arg0, SignatureAlgorithm arg1) {
        super(arg0, arg1);
    }

    public HmacJwsSignatureProviderExtended(SecretKeyPkcs11 secretKey, AlgorithmParameterSpec spec, SignatureAlgorithm algo) {
        super(secretKey.getSecretKey().getEncoded(), spec, algo);
        this.secretKey = secretKey;
        this.hmacSpec = spec;
    }

    public HmacJwsSignatureProviderExtended(SecretKeyPkcs11 secretKey, SignatureAlgorithm algo) {
        super(secretKey.getSecretKey().getEncoded(), algo);
        this.secretKey = secretKey;
    }

    protected JwsSignature doCreateJwsSignature(JwsHeaders headers) {
        if (this.secretKey == null) {
            return super.doCreateJwsSignature(headers);
        }
        String sigAlgo = headers.getSignatureAlgorithm().getJwaName();
        final Mac mac = HmacUtils.getMac((String)AlgorithmUtils.toJavaName((String)sigAlgo), (Provider)this.secretKey.getProvider());
        try {
            if (this.hmacSpec == null) {
                mac.init(this.secretKey.getSecretKey());
            } else {
                mac.init(this.secretKey.getSecretKey(), this.hmacSpec);
            }
        }
        catch (InvalidKeyException e) {
            throw new SecurityException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SecurityException(e);
        }
        return new JwsSignature(){

            public void update(byte[] src, int off, int len) {
                mac.update(src, off, len);
            }

            public byte[] sign() {
                return mac.doFinal();
            }
        };
    }
}

