/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.io.File;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rs.security.jose.jws.JwsCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsJsonConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsJsonProducer;
import org.apache.cxf.rs.security.jose.jws.JwsJsonSignatureEntry;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jws.PublicKeyJwsSignatureVerifier;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.JWK;
import org.openspcoop2.utils.certificate.JWKSet;
import org.openspcoop2.utils.certificate.remote.IRemoteStoreProvider;
import org.openspcoop2.utils.certificate.remote.RemoteKeyType;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.security.CertificateValidityCheck;
import org.openspcoop2.utils.security.JWTOptions;
import org.openspcoop2.utils.security.JsonUtils;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.utils.transport.http.IOCSPValidator;

public class JsonVerifySignature {
    private JwsSignatureVerifier provider;
    private Properties propsConfig;
    private JWTOptions options;
    private Properties properties;
    private boolean dynamicProvider;
    private JwsHeaders jwsDecodedHeaders;
    private String decodedHeader;
    private String decodedPayload;
    private byte[] decodedPayloadAsByte;
    private org.openspcoop2.utils.certificate.KeyStore trustStoreCertificatiX509;
    private JsonWebKeys jsonWebKeys;
    private IRemoteStoreProvider remoteStoreProvider;
    private RemoteKeyType remoteStoreKeyType;
    private RemoteStoreConfig remoteStoreConfig;
    private org.openspcoop2.utils.certificate.KeyStore trustStoreHttps;
    private CertStore crlHttps;
    private IOCSPValidator ocspValidatorHttps;
    private CertStore crlX509;
    private IOCSPValidator ocspValidatorX509;
    private CertificateValidityCheck validityCheck = CertificateValidityCheck.ENABLED;
    private boolean jksPasswordRequired = true;
    private boolean pkcs12PasswordRequired = true;
    private X509Certificate x509Certificate;
    private PublicKey publicKey;
    private String kid;

    public org.openspcoop2.utils.certificate.KeyStore getTrustStoreCertificatiX509() {
        return this.trustStoreCertificatiX509;
    }

    public org.openspcoop2.utils.certificate.KeyStore getTrustStoreHttps() {
        return this.trustStoreHttps;
    }

    public void setCrlHttps(CertStore crlHttps) {
        this.crlHttps = crlHttps;
    }

    public void setOcspValidatorHttps(IOCSPValidator ocspValidator) {
        this.ocspValidatorHttps = ocspValidator;
    }

    public void setCrlX509(CertStore crlX509) {
        this.crlX509 = crlX509;
    }

    public void setOcspValidatorX509(IOCSPValidator ocspValidator) {
        this.ocspValidatorX509 = ocspValidator;
    }

    public void setValidityCheck(CertificateValidityCheck validityCheck) {
        this.validityCheck = validityCheck;
    }

    public void setJksPasswordRequired(boolean jksPasswordRequired) {
        this.jksPasswordRequired = jksPasswordRequired;
    }

    public void setPkcs12PasswordRequired(boolean pkcs12PasswordRequired) {
        this.pkcs12PasswordRequired = pkcs12PasswordRequired;
    }

    public JsonVerifySignature(Properties props, JWTOptions options) throws UtilsException {
        try {
            this.propsConfig = props;
            this.dynamicProvider = JsonUtils.isDynamicProvider(props);
            if (this.dynamicProvider) {
                this.properties = props;
            } else {
                this.provider = this.loadProviderFromProperties(props, null);
            }
            this.options = options;
        }
        catch (Exception t) {
            throw JsonUtils.convert(options.getSerialization(), true, false, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JwsSignatureVerifier loadProviderFromProperties(Properties props, SignatureAlgorithm signatureAlgorithm) throws UtilsException {
        File fTmp = null;
        try {
            fTmp = JsonUtils.normalizeProperties(props);
            JwsSignatureVerifier providerReturn = null;
            providerReturn = signatureAlgorithm != null ? JsonUtils.getJwsSignatureVerifier(props, signatureAlgorithm) : JsonUtils.getJwsSignatureVerifier(props);
            if (providerReturn == null) {
                providerReturn = JwsUtils.loadSignatureVerifier((Message)JsonUtils.newMessage(), (Properties)props, (JwsHeaders)new JwsHeaders());
            }
            if (providerReturn == null) {
                throw new UtilsException("JwsSignatureVerifier provider not found");
            }
            JwsSignatureVerifier jwsSignatureVerifier = providerReturn;
            return jwsSignatureVerifier;
        }
        finally {
            try {
                if (fTmp != null) {
                    Files.delete(fTmp.toPath());
                }
            }
            catch (Exception exception) {}
        }
    }

    public JsonVerifySignature(KeyStore keystore, String alias, String signatureAlgorithm, JWTOptions options) throws UtilsException {
        this(new org.openspcoop2.utils.certificate.KeyStore(keystore), alias, signatureAlgorithm, options);
    }

    public JsonVerifySignature(org.openspcoop2.utils.certificate.KeyStore keystore, String alias, String signatureAlgorithm, JWTOptions options) throws UtilsException {
        try {
            SignatureAlgorithm algo = SignatureAlgorithm.getAlgorithm((String)signatureAlgorithm);
            this.provider = JwsUtils.getPublicKeySignatureVerifier((X509Certificate)((X509Certificate)keystore.getCertificate(alias)), (SignatureAlgorithm)algo);
            this.options = options;
            this.trustStoreCertificatiX509 = keystore;
        }
        catch (Exception t) {
            throw JsonUtils.convert(options.getSerialization(), true, false, t);
        }
    }

    public JsonVerifySignature(KeyStore keystore, String alias, String passwordPrivateKey, String signatureAlgorithm, JWTOptions options) throws UtilsException {
        this(new org.openspcoop2.utils.certificate.KeyStore(keystore), alias, passwordPrivateKey, signatureAlgorithm, options);
    }

    public JsonVerifySignature(org.openspcoop2.utils.certificate.KeyStore keystore, String alias, String passwordPrivateKey, String signatureAlgorithm, JWTOptions options) throws UtilsException {
        try {
            SignatureAlgorithm algo = SignatureAlgorithm.getAlgorithm((String)signatureAlgorithm);
            this.provider = JwsUtils.getHmacSignatureVerifier((byte[])keystore.getSecretKey(alias, passwordPrivateKey).getEncoded(), (SignatureAlgorithm)algo);
            if (this.provider == null) {
                throw new UtilsException("(JCEKS) JwsSignatureVerifier init failed; check signature algorithm (" + signatureAlgorithm + ")");
            }
            this.options = options;
            this.trustStoreCertificatiX509 = keystore;
        }
        catch (Exception t) {
            throw JsonUtils.convert(options.getSerialization(), true, false, t);
        }
    }

    public JsonVerifySignature(JsonWebKeys jsonWebKeys, boolean secretKey, String alias, String signatureAlgorithm, JWTOptions options) throws UtilsException {
        this(JsonUtils.readKey(jsonWebKeys, alias), secretKey, signatureAlgorithm, options);
    }

    public JsonVerifySignature(JsonWebKey jsonWebKey, boolean secretKey, String signatureAlgorithm, JWTOptions options) throws UtilsException {
        try {
            SignatureAlgorithm algo = SignatureAlgorithm.getAlgorithm((String)signatureAlgorithm);
            if (secretKey) {
                this.provider = JwsUtils.getSignatureVerifier((JsonWebKey)jsonWebKey, (SignatureAlgorithm)algo);
                if (this.provider == null) {
                    throw new UtilsException("(JsonWebKey) JwsSignatureVerifier init failed; check signature algorithm (" + signatureAlgorithm + ")");
                }
            } else {
                this.provider = JwsUtils.getPublicKeySignatureVerifier((PublicKey)JwkUtils.toRSAPublicKey((JsonWebKey)jsonWebKey), (SignatureAlgorithm)algo);
            }
            this.options = options;
        }
        catch (Exception t) {
            throw JsonUtils.convert(options.getSerialization(), true, false, t);
        }
    }

    public JsonVerifySignature(String secret, String signatureAlgorithm, JWTOptions options) throws UtilsException {
        try {
            SignatureAlgorithm algo = SignatureAlgorithm.getAlgorithm((String)signatureAlgorithm);
            this.provider = JwsUtils.getHmacSignatureVerifier((byte[])secret.getBytes(), (SignatureAlgorithm)algo);
            if (this.provider == null) {
                throw new UtilsException("(Secret) JwsSignatureVerifier init failed; check signature algorithm (" + signatureAlgorithm + ")");
            }
            this.options = options;
        }
        catch (Exception t) {
            throw JsonUtils.convert(options.getSerialization(), true, false, t);
        }
    }

    public JsonVerifySignature(JWTOptions options) {
        this.initVerifyCertificatiHeaderJWTEngine(null, null, null, options);
    }

    public JsonVerifySignature(Properties propsTrustStoreHttps, KeyStore trustStoreVerificaCertificato, JWTOptions options) {
        this.initVerifyCertificatiHeaderJWTEngine(propsTrustStoreHttps, null, new org.openspcoop2.utils.certificate.KeyStore(trustStoreVerificaCertificato), options);
    }

    public JsonVerifySignature(Properties propsTrustStoreHttps, org.openspcoop2.utils.certificate.KeyStore trustStore, JWTOptions options) {
        this.initVerifyCertificatiHeaderJWTEngine(propsTrustStoreHttps, null, trustStore, options);
    }

    public JsonVerifySignature(KeyStore trustStoreHttps, KeyStore trustStoreVerificaCertificato, JWTOptions options) {
        this.initVerifyCertificatiHeaderJWTEngine(null, new org.openspcoop2.utils.certificate.KeyStore(trustStoreHttps), new org.openspcoop2.utils.certificate.KeyStore(trustStoreVerificaCertificato), options);
    }

    public JsonVerifySignature(org.openspcoop2.utils.certificate.KeyStore trustStoreHttps, org.openspcoop2.utils.certificate.KeyStore trustStore, JWTOptions options) {
        this.initVerifyCertificatiHeaderJWTEngine(null, trustStoreHttps, trustStore, options);
    }

    public JsonVerifySignature(KeyStore trustStoreVerificaCertificato, JWTOptions options) {
        this.initVerifyCertificatiHeaderJWTEngine(null, null, new org.openspcoop2.utils.certificate.KeyStore(trustStoreVerificaCertificato), options);
    }

    public JsonVerifySignature(org.openspcoop2.utils.certificate.KeyStore trustStore, JWTOptions options) {
        this.initVerifyCertificatiHeaderJWTEngine(null, null, trustStore, options);
    }

    private void initVerifyCertificatiHeaderJWTEngine(Properties propsTrustStoreHttps, org.openspcoop2.utils.certificate.KeyStore trustStoreHttps, org.openspcoop2.utils.certificate.KeyStore trustStoreVerificaCertificato, JWTOptions options) {
        this.options = options;
        this.properties = propsTrustStoreHttps;
        this.trustStoreHttps = trustStoreHttps;
        this.trustStoreCertificatiX509 = trustStoreVerificaCertificato;
    }

    public JsonVerifySignature(JsonWebKeys jsonWebKeys, JWTOptions options) {
        this.initVerifyCertificatiHeaderJWTEngine(jsonWebKeys, options);
    }

    private void initVerifyCertificatiHeaderJWTEngine(JsonWebKeys jsonWebKeys, JWTOptions options) {
        this.options = options;
        this.jsonWebKeys = jsonWebKeys;
    }

    public JsonVerifySignature(IRemoteStoreProvider remoteStoreProvider, RemoteKeyType remoteStoreKeyType, RemoteStoreConfig remoteStoreConfig, JWTOptions options) {
        this.initVerifyCertificatiHeaderRemoteStoreEngine(remoteStoreProvider, remoteStoreKeyType, remoteStoreConfig, options);
    }

    private void initVerifyCertificatiHeaderRemoteStoreEngine(IRemoteStoreProvider remoteStoreProvider, RemoteKeyType remoteStoreKeyType, RemoteStoreConfig remoteStoreConfig, JWTOptions options) {
        this.options = options;
        this.remoteStoreProvider = remoteStoreProvider;
        this.remoteStoreKeyType = remoteStoreKeyType;
        this.remoteStoreConfig = remoteStoreConfig;
    }

    public boolean verify(String jsonString) throws UtilsException {
        try {
            switch (this.options.getSerialization()) {
                case JSON: {
                    return this.verifyJson(jsonString);
                }
                case COMPACT: {
                    return this.verifyCompact(jsonString);
                }
            }
            throw new UtilsException("Unsupported serialization '" + this.options.getSerialization() + "'");
        }
        catch (Exception t) {
            throw JsonUtils.convert(this.options.getSerialization(), true, false, t);
        }
    }

    public boolean verifyDetached(String jsonDetachedSignature, String jsonDetachedPayload) throws UtilsException {
        try {
            switch (this.options.getSerialization()) {
                case JSON: {
                    return this.verifyDetachedJson(jsonDetachedSignature, jsonDetachedPayload);
                }
                case COMPACT: {
                    return this.verifyDetachedCompact(jsonDetachedSignature, jsonDetachedPayload);
                }
            }
            throw new UtilsException("Unsupported serialization '" + this.options.getSerialization() + "'");
        }
        catch (Exception t) {
            throw JsonUtils.convert(this.options.getSerialization(), true, false, t);
        }
    }

    private boolean verifyDetachedJson(String jsonDetachedSignature, String jsonDetachedPayload) throws UtilsException {
        JwsJsonProducer producer = new JwsJsonProducer(jsonDetachedPayload);
        JwsJsonConsumer consumer = new JwsJsonConsumer(jsonDetachedSignature, producer.getUnsignedEncodedPayload());
        return this.verifyJsonEngine(consumer);
    }

    private boolean verifyJson(String jsonString) throws UtilsException {
        JwsJsonConsumer consumer = new JwsJsonConsumer(jsonString);
        return this.verifyJsonEngine(consumer);
    }

    private boolean verifyJsonEngine(JwsJsonConsumer consumer) throws UtilsException {
        JwsHeaders jwsHeaders = null;
        if (consumer.getSignatureEntries() != null && !consumer.getSignatureEntries().isEmpty() && consumer.getSignatureEntries().get(0) != null) {
            jwsHeaders = ((JwsJsonSignatureEntry)consumer.getSignatureEntries().get(0)).getProtectedHeader();
        }
        JwsSignatureVerifier providerInternal = this.getProvider(jwsHeaders);
        boolean result = consumer.verifySignatureWith(providerInternal);
        this.decodedPayload = consumer.getDecodedJwsPayload();
        this.decodedPayloadAsByte = consumer.getDecodedJwsPayloadBytes();
        return result;
    }

    private boolean verifyDetachedCompact(String jsonDetachedSignature, String jsonDetachedPayload) throws UtilsException {
        return this.verifyCompactEngine(jsonDetachedSignature, jsonDetachedPayload);
    }

    private boolean verifyCompact(String jsonSignature) throws UtilsException {
        return this.verifyCompactEngine(jsonSignature, null);
    }

    private boolean verifyCompactEngine(String jsonSignature, String jsonDetachedPayload) throws UtilsException {
        JwsCompactConsumer consumer = null;
        consumer = jsonDetachedPayload == null ? new JwsCompactConsumer(jsonSignature) : new JwsCompactConsumer(jsonSignature, Base64UrlUtility.encode((String)jsonDetachedPayload));
        this.jwsDecodedHeaders = consumer.getJwsHeaders();
        try {
            this.decodedHeader = consumer.getDecodedJsonHeaders();
        }
        catch (Exception exception) {
            // empty catch block
        }
        JwsSignatureVerifier providerInternal = this.getProvider(this.jwsDecodedHeaders);
        boolean result = consumer.verifySignatureWith(providerInternal);
        if (jsonDetachedPayload != null) {
            this.decodedPayload = jsonDetachedPayload;
            this.decodedPayloadAsByte = jsonDetachedPayload.getBytes();
        } else {
            this.decodedPayload = consumer.getDecodedJwsPayload();
            this.decodedPayloadAsByte = consumer.getDecodedJwsPayloadBytes();
        }
        return result;
    }

    public String getDecodedPayload() {
        return this.decodedPayload;
    }

    public byte[] getDecodedPayloadAsByte() {
        return this.decodedPayloadAsByte;
    }

    public JwsHeaders getJwsDecodedHeaders() {
        return this.jwsDecodedHeaders;
    }

    public String getDecodedHeader() {
        return this.decodedHeader;
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    public PublicKey getRsaPublicKey() {
        return this.publicKey;
    }

    public String getKid() {
        return this.kid;
    }

    private String getProcessErrorMsg(String mode, Exception e) {
        return "Process '" + mode + "' error: " + e.getMessage();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JwsSignatureVerifier getProvider(JwsHeaders jwsHeaders) throws UtilsException {
        void var4_20;
        JwsSignatureVerifier providerReturn = this.provider;
        if (jwsHeaders == null) {
            return providerReturn;
        }
        if (this.dynamicProvider) {
            String alias = jwsHeaders.getKeyId();
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.properties);
            properties.put("rs.security.keystore.alias", alias);
            providerReturn = this.loadProviderFromProperties(properties, jwsHeaders.getSignatureAlgorithm());
        }
        if (providerReturn == null) {
            SignatureAlgorithm algo = jwsHeaders.getSignatureAlgorithm();
            if (algo == null) {
                throw new UtilsException("SignatureAlgorithm not found");
            }
            if (jwsHeaders.getX509Chain() != null && !jwsHeaders.getX509Chain().isEmpty() && this.options.isPermitUseHeaderX5C()) {
                try {
                    byte[] byArray = Base64Utilities.decode((String)jwsHeaders.getX509Chain().get(0));
                    CertificateInfo certificatoInfo = ArchiveLoader.load(byArray).getCertificate();
                    if (this.trustStoreCertificatiX509 != null) {
                        JsonUtils.validate(certificatoInfo, this.trustStoreCertificatiX509, this.crlX509, this.ocspValidatorX509, "x5c", true, this.validityCheck);
                    }
                    this.x509Certificate = certificatoInfo.getCertificate();
                    return JwsUtils.getPublicKeySignatureVerifier((X509Certificate)this.x509Certificate, (SignatureAlgorithm)algo);
                }
                catch (Exception exception) {
                    throw new UtilsException(this.getProcessErrorMsg("x5c", exception), exception);
                }
            }
            if (jwsHeaders.getJsonWebKey() != null && this.options.isPermitUseHeaderJWK()) {
                try {
                    this.publicKey = JwkUtils.toRSAPublicKey((JsonWebKey)jwsHeaders.getJsonWebKey());
                    return JwsUtils.getPublicKeySignatureVerifier((PublicKey)this.publicKey, (SignatureAlgorithm)algo);
                }
                catch (Exception exception) {
                    throw new UtilsException(this.getProcessErrorMsg("jwk", exception), exception);
                }
            }
            if (jwsHeaders.getX509Url() != null && this.options.isPermitUseHeaderX5U() || jwsHeaders.getJsonWebKeysUrl() != null && this.options.isPermitUseHeaderJKU()) {
                boolean bl;
                boolean bl2 = true;
                String path = jwsHeaders.getX509Url();
                String hdr = "x5u";
                if (path == null) {
                    path = jwsHeaders.getJsonWebKeysUrl();
                    bl = false;
                    hdr = "jku";
                }
                try {
                    String prefixPath = "Resource '" + path + "'";
                    byte[] cer = null;
                    if (this.properties != null) {
                        this.properties.put("rs.security.keystore.file", path);
                        cer = JsonUtils.readKeystoreFromURI(this.properties);
                    } else {
                        HttpResponse httpResponse = this.getHttpResponse(path, prefixPath);
                        if (httpResponse == null) throw new UtilsException(prefixPath + " unavailable");
                        if (httpResponse.getContent() == null) {
                            throw new UtilsException(prefixPath + " unavailable");
                        }
                        if (httpResponse.getResultHTTPOperation() != 200) {
                            throw new UtilsException("Retrieve '" + path + "' failed (returnCode:" + httpResponse.getResultHTTPOperation() + ")");
                        }
                        cer = httpResponse.getContent();
                    }
                    if (cer == null) {
                        throw new UtilsException(prefixPath + " unavailable");
                    }
                    if (bl) {
                        CertificateInfo certificatoInfo = ArchiveLoader.load(cer).getCertificate();
                        if (this.trustStoreCertificatiX509 != null) {
                            JsonUtils.validate(certificatoInfo, this.trustStoreCertificatiX509, this.crlX509, this.ocspValidatorX509, hdr, true, this.validityCheck);
                        }
                        this.x509Certificate = certificatoInfo.getCertificate();
                        return JwsUtils.getPublicKeySignatureVerifier((X509Certificate)this.x509Certificate, (SignatureAlgorithm)algo);
                    }
                    JWKSet set = new JWKSet(new String(cer));
                    JsonWebKeys jsonWebKeysInternal = set.getJsonWebKeys();
                    JsonWebKey jsonWebKey = null;
                    if (jsonWebKeysInternal.size() == 1) {
                        jsonWebKey = (JsonWebKey)jsonWebKeysInternal.getKeys().get(0);
                    } else {
                        if (jwsHeaders.getKeyId() == null) {
                            throw new UtilsException("Kid non definito e JwkSet contiene pi\u00f9 di un certificato");
                        }
                        jsonWebKey = jsonWebKeysInternal.getKey(jwsHeaders.getKeyId());
                    }
                    if (jsonWebKey == null) {
                        throw new UtilsException("JsonWebKey non trovata");
                    }
                    this.publicKey = JwkUtils.toRSAPublicKey((JsonWebKey)jsonWebKey);
                    return JwsUtils.getPublicKeySignatureVerifier((PublicKey)this.publicKey, (SignatureAlgorithm)algo);
                }
                catch (Exception e) {
                    throw new UtilsException(this.getProcessErrorMsg(hdr, e), e);
                }
            }
            if (jwsHeaders.getKeyId() != null && this.options.isPermitUseHeaderKID()) {
                try {
                    Certificate certificate;
                    JsonWebKey jsonWebKey;
                    this.kid = jwsHeaders.getKeyId();
                    if (this.jsonWebKeys != null && (jsonWebKey = this.getJsonWebKeyByKidIgnoreException()) != null) {
                        this.publicKey = JwkUtils.toRSAPublicKey((JsonWebKey)jsonWebKey);
                        providerReturn = JwsUtils.getPublicKeySignatureVerifier((PublicKey)this.publicKey, (SignatureAlgorithm)algo);
                    }
                    if (providerReturn == null && this.trustStoreCertificatiX509 != null && this.trustStoreCertificatiX509.existsAlias(this.kid) && (certificate = this.trustStoreCertificatiX509.getCertificate(this.kid)) instanceof X509Certificate) {
                        this.x509Certificate = (X509Certificate)certificate;
                        JsonUtils.validate(new CertificateInfo(this.x509Certificate, this.kid), this.trustStoreCertificatiX509, this.crlX509, this.ocspValidatorX509, "kid", false, this.validityCheck);
                        providerReturn = JwsUtils.getPublicKeySignatureVerifier((X509Certificate)this.x509Certificate, (SignatureAlgorithm)algo);
                    }
                    if (providerReturn == null && this.remoteStoreProvider != null && this.remoteStoreConfig != null && this.remoteStoreKeyType != null) {
                        providerReturn = this.getProviderByRemoteStore(algo);
                    }
                    if (providerReturn != null) return providerReturn;
                    throw new UtilsException("Certificato, corrispondente al kid '" + this.kid + "', non trovato nel TrustStore dei certificati");
                }
                catch (Exception exception) {
                    throw new UtilsException(this.getProcessErrorMsg("kid", exception), exception);
                }
            }
            if (jwsHeaders.getX509ThumbprintSHA256() != null && this.options.isPermitUseHeaderX5T_256() || jwsHeaders.getX509Thumbprint() != null && this.options.isPermitUseHeaderX5T()) {
                void var4_16;
                String string = "x5t";
                if (jwsHeaders.getX509ThumbprintSHA256() != null) {
                    String string2 = "x5t#S256";
                }
                try {
                    if (this.trustStoreCertificatiX509 == null) {
                        throw new UtilsException("TrustStore dei certificati non fornito");
                    }
                    Certificate cer = null;
                    cer = jwsHeaders.getX509ThumbprintSHA256() != null ? this.trustStoreCertificatiX509.getCertificateByDigestSHA256UrlEncoded(jwsHeaders.getX509ThumbprintSHA256()) : this.trustStoreCertificatiX509.getCertificateByDigestSHA1UrlEncoded(jwsHeaders.getX509Thumbprint());
                    if (cer == null) {
                        throw new UtilsException("Certificato, corrispondente al digest indicato, non trovato nel TrustStore dei certificati");
                    }
                    if (!(cer instanceof X509Certificate)) throw new UtilsException("Certificato indicato non \u00e8 nel formato X.509");
                    this.x509Certificate = (X509Certificate)cer;
                    JsonUtils.validate(new CertificateInfo(this.x509Certificate, (String)var4_16), this.trustStoreCertificatiX509, this.crlX509, this.ocspValidatorX509, (String)var4_16, false, this.validityCheck);
                    return JwsUtils.getPublicKeySignatureVerifier((X509Certificate)this.x509Certificate, (SignatureAlgorithm)algo);
                }
                catch (Exception e) {
                    throw new UtilsException(this.getProcessErrorMsg((String)var4_16, e), e);
                }
            }
            List<String> list = this.options.headersNotPermitted((JoseHeaders)jwsHeaders);
            Object notPermitted = "";
            if (list == null) throw new UtilsException("Non \u00e8 stato trovato alcun header che consentisse di recuperare il certificato per effettuare la validazione" + (String)notPermitted);
            if (list.isEmpty()) throw new UtilsException("Non \u00e8 stato trovato alcun header che consentisse di recuperare il certificato per effettuare la validazione" + (String)notPermitted);
            notPermitted = "; header trovati ma non abilitati all'utilizzo: " + list;
            throw new UtilsException("Non \u00e8 stato trovato alcun header che consentisse di recuperare il certificato per effettuare la validazione" + (String)notPermitted);
        }
        if (this.x509Certificate != null) return providerReturn;
        if (!(providerReturn instanceof PublicKeyJwsSignatureVerifier)) return providerReturn;
        PublicKeyJwsSignatureVerifier certVer = (PublicKeyJwsSignatureVerifier)providerReturn;
        this.x509Certificate = certVer.getX509Certificate();
        org.openspcoop2.utils.certificate.KeyStore keyStore = this.trustStoreCertificatiX509;
        if (keyStore == null && this.propsConfig != null) {
            org.openspcoop2.utils.certificate.KeyStore keyStore2 = JsonUtils.getKeyStore(this.jksPasswordRequired, this.pkcs12PasswordRequired, this.propsConfig);
        }
        if (var4_20 == null) return providerReturn;
        try {
            CertificateInfo certificatoInfo = new CertificateInfo(this.x509Certificate, "x509");
            JsonUtils.validate(certificatoInfo, (org.openspcoop2.utils.certificate.KeyStore)var4_20, this.crlX509, this.ocspValidatorX509, null, true, this.validityCheck);
            return providerReturn;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private JsonWebKey getJsonWebKeyByKidIgnoreException() {
        try {
            return this.jsonWebKeys.getKey(this.kid);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private HttpResponse getHttpResponse(String path, String prefixPath) throws UtilsException {
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.trustStoreHttps != null ? HttpUtilities.getHTTPSResponse(path, this.trustStoreHttps.getKeystore(), this.crlHttps, this.ocspValidatorHttps) : HttpUtilities.getHTTPResponse(path);
        }
        catch (Exception e) {
            throw new UtilsException(prefixPath + " unavailable: " + e.getMessage(), e);
        }
        return httpResponse;
    }

    private JwsSignatureVerifier getProviderByRemoteStore(SignatureAlgorithm algo) throws UtilsException {
        switch (this.remoteStoreKeyType) {
            case JWK: {
                JWK jwk = this.remoteStoreProvider.readJWK(this.kid, this.remoteStoreConfig);
                if (jwk == null) {
                    throw this.newUtilsExceptionErrorKidUnavailable(true);
                }
                JsonWebKey jsonWebKey = jwk.getJsonWebKey();
                if (jsonWebKey != null) {
                    this.publicKey = JwkUtils.toRSAPublicKey((JsonWebKey)jsonWebKey);
                    return JwsUtils.getPublicKeySignatureVerifier((PublicKey)this.publicKey, (SignatureAlgorithm)algo);
                }
                throw this.newUtilsExceptionErrorKidUnavailable(true);
            }
            case PUBLIC_KEY: {
                this.publicKey = this.remoteStoreProvider.readPublicKey(this.kid, this.remoteStoreConfig);
                if (this.publicKey == null) {
                    throw this.newUtilsExceptionErrorKidUnavailable(true);
                }
                return JwsUtils.getPublicKeySignatureVerifier((PublicKey)this.publicKey, (SignatureAlgorithm)algo);
            }
            case X509: {
                org.openspcoop2.utils.certificate.Certificate certificate = this.remoteStoreProvider.readX509(this.kid, this.remoteStoreConfig);
                if (certificate == null) {
                    throw this.newUtilsExceptionErrorKidUnavailable(false);
                }
                this.x509Certificate = certificate.getCertificate().getCertificate();
                return JwsUtils.getPublicKeySignatureVerifier((X509Certificate)this.x509Certificate, (SignatureAlgorithm)algo);
            }
        }
        throw new UtilsException("RemoteStoreKeyType '" + this.remoteStoreKeyType + "' unknown");
    }

    private UtilsException newUtilsExceptionErrorKidUnavailable(boolean publicKey) {
        String prefix = publicKey ? "Public Key" : "Certificate";
        return new UtilsException(prefix + " with kid '" + this.kid + "' unavailable");
    }
}

