/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security.test;

import java.util.Properties;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.security.JOSESerialization;
import org.openspcoop2.utils.security.JWTOptions;
import org.openspcoop2.utils.security.JsonVerifySignature;

public class VerifyGoogleJWTTest {
    public static void main(String[] args) throws Exception {
        VerifyGoogleJWTTest.test();
    }

    public static void test() throws Exception {
        Properties verifySignatureProps = new Properties();
        verifySignatureProps.setProperty("rs.security.keystore.type", KeystoreType.JWK_SET.getNome());
        verifySignatureProps.setProperty("rs.security.keystore.file", "https://www.googleapis.com/oauth2/v3/certs");
        verifySignatureProps.setProperty("rs.security.keystore.alias", "*");
        String compactSign = "eyJhbGciOiJSUzI1NiIsImtpZCI6IjQ4NmYxNjQ4MjAwNWEyY2RhZjI2ZDkyMTQwMThkMDI5Y2E0NmZiNTYiLCJ0eXAiOiJKV1QifQ.eyJpc3MiOiJodHRwczovL2FjY291bnRzLmdvb2dsZS5jb20iLCJhenAiOiI0MDc0MDg3MTgxOTIuYXBwcy5nb29nbGV1c2VyY29udGVudC5jb20iLCJhdWQiOiI0MDc0MDg3MTgxOTIuYXBwcy5nb29nbGV1c2VyY29udGVudC5jb20iLCJzdWIiOiIxMDYyMzU2NTc1OTI2NTQzOTc2ODkiLCJhdF9oYXNoIjoiVy1ELXNPa0w4cUpBVWNleEZNWmRkUSIsImlhdCI6MTY1MzQ3Mzc4MywiZXhwIjoxNjUzNDc3MzgzfQ.chyZymyS4Ie1ZU-WWlQGDMYSLp4fcH4OD8wJovR4SQH6LQRYj2SuC_K7xUsrXWSe71X24bCo1dkJi6L56jDGvmYhEHaQ4nya0xeizMoE8GJ_VNALwD3YvhjcxTZ7pPgjbGdL1ej9VTAYxyCWGf4qGueJlYp3tVawkhdeqd-sGXm4nc6jOriD0Ynb_3wbCM7uqh7D3-B0ujEcmmvR6SSaKYfbmjDPTIdG8YBEgEWSsPqfXz8n2Y_oKlDTOEg5LcrYKbl-ek0AcrqlWVhx84J7bRGW8WCtOL0Lo8D0cdjD4ho78zD6-En_cOqoLUoh9oJIiBbOObFL37udaDtLRFFJvw";
        try {
            JWTOptions options = new JWTOptions(JOSESerialization.COMPACT);
            JsonVerifySignature jsonCompactVerify = new JsonVerifySignature(verifySignatureProps, options);
            System.out.println("JsonCompactSignature Verify (" + jsonCompactVerify.verify(compactSign) + " ) payload: " + jsonCompactVerify.getDecodedPayload());
        }
        catch (Exception e) {
            if (e.getMessage().contains("NO_VERIFIER")) {
                System.out.println("JsonCompactSignature fallimento atteso: " + e.getMessage());
                System.out.println("WARNING: aggiornare l'id_token tramite playground selezionando solo lo scope 'oauth2 -> openid'");
            }
            throw e;
        }
    }
}

