/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.semaphore.test;

import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.semaphore.ISemaphoreEventGenerator;
import org.openspcoop2.utils.semaphore.SemaphoreEvent;
import org.openspcoop2.utils.semaphore.SemaphoreOperationType;
import org.slf4j.Logger;

class EventGeneratorLog
implements ISemaphoreEventGenerator {
    private Logger log;
    private List<String> acquisiti = new ArrayList<String>();
    private List<String> aggiornati = new ArrayList<String>();
    private List<String> rilasciati = new ArrayList<String>();
    private List<String> errori = new ArrayList<String>();

    public List<String> getAcquisiti() {
        return this.acquisiti;
    }

    public List<String> getAggiornati() {
        return this.aggiornati;
    }

    public List<String> getRilasciati() {
        return this.rilasciati;
    }

    public List<String> getErrori() {
        return this.errori;
    }

    public EventGeneratorLog(Logger log) {
        this.log = log;
    }

    @Override
    public void emitEvent(Connection con, SemaphoreEvent event) {
        SimpleDateFormat dateformat = DateUtils.getSimpleDateFormatMs();
        this.log.info("[" + event.getSeverity() + "] [" + event.getOperationType() + "] Date[" + dateformat.format(event.getDate()) + "] IdNode[" + event.getIdNode() + "] [Lock:" + event.isLock() + "]: " + event.getDetails() + "\n");
        if (event.isLock()) {
            if (SemaphoreOperationType.NEW.equals((Object)event.getOperationType())) {
                if (this.acquisiti.contains(event.getIdNode())) {
                    this.errori.add("Riscontrato pi\u00f9 di un lock per l'id node: " + event.getIdNode());
                } else {
                    this.acquisiti.add(event.getIdNode());
                }
            } else if (SemaphoreOperationType.UPDATE.equals((Object)event.getOperationType())) {
                this.aggiornati.add(event.getIdNode());
            } else if (SemaphoreOperationType.RELEASE.equals((Object)event.getOperationType())) {
                if (!this.acquisiti.contains(event.getIdNode())) {
                    this.errori.add("Riscontrato un rilascio di lock per un nodo per cui non era stato ottenuto un lock: " + event.getIdNode());
                } else if (this.rilasciati.contains(event.getIdNode())) {
                    this.errori.add("Riscontrato pi\u00f9 di un rilascio di lock per l'id node: " + event.getIdNode());
                } else {
                    this.rilasciati.add(event.getIdNode());
                }
            }
        }
    }
}

