/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.serialization;

import org.openspcoop2.utils.checksum.ChecksumAdler;
import org.openspcoop2.utils.checksum.ChecksumCRC;
import org.openspcoop2.utils.serialization.Filter;
import org.openspcoop2.utils.serialization.FilterChecksumTypes;
import org.openspcoop2.utils.serialization.FilteredObject;
import org.openspcoop2.utils.serialization.IDBuilder;
import org.openspcoop2.utils.serialization.ISerializer;

public class PropertyFilterCore {
    private IDBuilder idBuilder = null;
    private Filter filter = null;
    private ISerializer serializer = null;

    public IDBuilder getIdBuilder() {
        return this.idBuilder;
    }

    public void setIdBuilder(IDBuilder idBuilder) {
        this.idBuilder = idBuilder;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public ISerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(ISerializer serializer) {
        this.serializer = serializer;
    }

    public PropertyFilterCore(Filter filter, IDBuilder idBuilder, ISerializer serializer) {
        this.idBuilder = idBuilder;
        this.filter = filter;
        this.serializer = serializer;
    }

    public PropertyFilterCore(Filter filter, ISerializer serializer) {
        this.filter = filter;
        this.serializer = serializer;
    }

    protected void applicaFiltro(Object source, String name, Object value, Class<?> classFilter) {
        try {
            FilteredObject oggettoFiltrato = new FilteredObject();
            String id = null;
            try {
                if (this.idBuilder == null) {
                    throw new Exception("IDBuilder not initialized");
                }
                id = this.idBuilder.toID(source, name);
            }
            catch (Exception e) {
                return;
            }
            if (this.filter.existsFilteredObject(id)) {
                return;
            }
            if (this.idBuilder != null) {
                oggettoFiltrato.setId(id);
            }
            long checksum = -1L;
            byte[] byteOggetto = null;
            byteOggetto = value instanceof byte[] ? (byte[])value : this.serializer.getObject(value).getBytes();
            checksum = FilterChecksumTypes.ADLER.toString().equals(this.filter.getFilterChecksumType().toString()) ? ChecksumAdler.checksumAdler32(byteOggetto) : ChecksumCRC.checksumCRC32(byteOggetto);
            oggettoFiltrato.setChecksum(checksum);
            oggettoFiltrato.setClassType(classFilter);
            this.filter.addFilteredObject(oggettoFiltrato);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }
}

