/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.serialization;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.ezmorph.MorpherRegistry;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.JSONUtils;
import net.sf.json.util.PropertyFilter;
import net.sf.json.xml.XMLSerializer;
import org.openspcoop2.utils.CopyCharStream;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.resources.ClassLoaderUtilities;
import org.openspcoop2.utils.serialization.ExclusionPropertyFilter;
import org.openspcoop2.utils.serialization.IDeserializer;
import org.openspcoop2.utils.serialization.IOException;
import org.openspcoop2.utils.serialization.SerializationConfig;
import org.openspcoop2.utils.serialization.Utilities;

public class XMLDeserializer
implements IDeserializer {
    private XMLSerializer xmlSerializer;
    private JsonConfig jsonConfig;
    private List<String> morpherPackage = new ArrayList<String>();
    private boolean throwExceptionMorpherFailed = true;

    public XMLDeserializer() {
        this(new SerializationConfig());
    }

    public XMLDeserializer(SerializationConfig config) {
        this.xmlSerializer = new XMLSerializer();
        JsonConfig jsonConfig = new JsonConfig();
        if (config.getExcludes() != null) {
            jsonConfig.setJavaPropertyFilter((PropertyFilter)new ExclusionPropertyFilter(config.getExcludes()));
        }
        this.jsonConfig = jsonConfig;
        this.addMorpherPackage("org.openspcoop2");
    }

    public void addMorpherPackage(String p) {
        this.morpherPackage.add(p);
    }

    public boolean isThrowExceptionMorpherFailed() {
        return this.throwExceptionMorpherFailed;
    }

    public void setThrowExceptionMorpherFailed(boolean throwExceptionMorpherFailed) {
        this.throwExceptionMorpherFailed = throwExceptionMorpherFailed;
    }

    @Override
    public Object getObject(String s, Class<?> classType) throws IOException {
        return this.getObject(s, classType, null);
    }

    public Object getListObject(String s, Class<?> listType, Class<?> elementsTypes) throws IOException {
        Object o = this.getObject(s, listType, elementsTypes);
        if (!(o instanceof List)) {
            throw new IOException("Object de-serializzato di tipo non java.util.List: " + o.getClass().getName());
        }
        return o;
    }

    public Object getSetObject(String s, Class<?> setType, Class<?> elementsTypes) throws IOException {
        Object o = this.getObject(s, setType, elementsTypes);
        if (!(o instanceof Set)) {
            throw new IOException("Object de-serializzato di tipo non java.util.Set: " + o.getClass().getName());
        }
        return o;
    }

    private Object getObject(String s, Class<?> classType, Class<?> elementsTypes) throws IOException {
        try {
            return this.readObject_engine(s, classType, elementsTypes);
        }
        catch (Exception e) {
            throw new IOException("Trasformazione in oggetto non riuscita: " + e.getMessage(), e);
        }
    }

    @Override
    public Object readObject(InputStream is, Class<?> classType) throws IOException {
        return this.readObject(is, classType, null);
    }

    public Object readListObject(InputStream is, Class<?> listType, Class<?> elementsTypes) throws IOException {
        Object o = this.readObject(is, listType, elementsTypes);
        if (!(o instanceof List)) {
            throw new IOException("Object de-serializzato di tipo non java.util.List: " + o.getClass().getName());
        }
        return o;
    }

    public Object readSetObject(InputStream is, Class<?> setType, Class<?> elementsTypes) throws IOException {
        Object o = this.readObject(is, setType, elementsTypes);
        if (!(o instanceof Set)) {
            throw new IOException("Object de-serializzato di tipo non java.util.Set: " + o.getClass().getName());
        }
        return o;
    }

    private Object readObject(InputStream is, Class<?> classType, Class<?> elementsTypes) throws IOException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            CopyStream.copy(is, (OutputStream)bout);
            bout.flush();
            bout.close();
            return this.readObject_engine(bout.toString(), classType, elementsTypes);
        }
        catch (Exception e) {
            throw new IOException("Trasformazione in oggetto non riuscita: " + e.getMessage(), e);
        }
    }

    @Override
    public Object readObject(Reader reader, Class<?> classType) throws IOException {
        return this.readObject(reader, classType, null);
    }

    public Object readListObject(Reader reader, Class<?> listType, Class<?> elementsTypes) throws IOException {
        Object o = this.readObject(reader, listType, elementsTypes);
        if (!(o instanceof List)) {
            throw new IOException("Object de-serializzato di tipo non java.util.List: " + o.getClass().getName());
        }
        return o;
    }

    public Object readSetObject(Reader reader, Class<?> setType, Class<?> elementsTypes) throws IOException {
        Object o = this.readObject(reader, setType, elementsTypes);
        if (!(o instanceof Set)) {
            throw new IOException("Object de-serializzato di tipo non java.util.Set: " + o.getClass().getName());
        }
        return o;
    }

    private Object readObject(Reader reader, Class<?> classType, Class<?> elementsTypes) throws IOException {
        try {
            StringWriter writer = new StringWriter();
            CopyCharStream.copy(reader, (Writer)writer);
            return this.readObject_engine(writer.toString(), classType, elementsTypes);
        }
        catch (Exception e) {
            throw new IOException("Trasformazione in oggetto non riuscita: " + e.getMessage(), e);
        }
    }

    private Object readObject_engine(String object, Class<?> classType, Class<?> elementsTypes) throws Exception {
        boolean list = false;
        try {
            classType.asSubclass(List.class);
            list = true;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        boolean set = false;
        try {
            classType.asSubclass(Set.class);
            set = true;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (classType.isEnum()) {
            JSON oResult = this.xmlSerializer.read(object);
            Object en = null;
            if (oResult instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)oResult;
                en = jsonObject.get(jsonObject.keys().next());
            } else {
                JSONArray jsonArray = (JSONArray)oResult;
                en = jsonArray.toArray()[0];
            }
            ?[] o = classType.getEnumConstants();
            Class<?> enumeration = o[0].getClass();
            Method method = enumeration.getMethod("valueOf", String.class);
            Object value = method.invoke(enumeration, en);
            return value;
        }
        if (classType.isArray()) {
            JSON oResult = this.xmlSerializer.read(object);
            if (oResult instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)oResult;
                Iterator it = jsonObject.keys();
                Object[] array = new Object[jsonObject.values().size()];
                int i = 0;
                while (it.hasNext()) {
                    Object key = it.next();
                    Object value = jsonObject.get(key);
                    JSONObject json = (JSONObject)value;
                    array[i] = this.fromJSONObjectToOriginalObject(classType.getComponentType(), json);
                    ++i;
                }
                return array;
            }
            JSONArray jsonArray = (JSONArray)oResult;
            Object[] oarray = jsonArray.toArray();
            Object[] array = new Object[oarray.length];
            for (int i = 0; i < oarray.length; ++i) {
                JSONObject json = (JSONObject)oarray[i];
                array[i] = this.fromJSONObjectToOriginalObject(classType.getComponentType(), json);
            }
            return array;
        }
        if (list) {
            if (elementsTypes == null) {
                throw new Exception("elementsTypes non definito, e' obbligatorio per il tipo che si desidera de-serializzare: " + classType.getName());
            }
            JSON oResult = this.xmlSerializer.read(object);
            if (oResult instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)oResult;
                Iterator it = jsonObject.keys();
                List listReturn = (List)ClassLoaderUtilities.newInstance(classType);
                while (it.hasNext()) {
                    Object key = it.next();
                    Object value = jsonObject.get(key);
                    JSONObject json = (JSONObject)value;
                    Object o = this.fromJSONObjectToOriginalObject(elementsTypes, json);
                    listReturn.add(o);
                }
                return listReturn;
            }
            JSONArray jsonArray = (JSONArray)oResult;
            Object[] oarray = jsonArray.toArray();
            List listReturn = (List)ClassLoaderUtilities.newInstance(classType);
            for (int i = 0; i < oarray.length; ++i) {
                JSONObject json = (JSONObject)oarray[i];
                Object o = this.fromJSONObjectToOriginalObject(elementsTypes, json);
                listReturn.add(o);
            }
            return listReturn;
        }
        if (set) {
            if (elementsTypes == null) {
                throw new Exception("elementsTypes non definito, e' obbligatorio per il tipo che si desidera de-serializzare: " + classType.getName());
            }
            JSON oResult = this.xmlSerializer.read(object);
            if (oResult instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)oResult;
                Iterator it = jsonObject.keys();
                Set setReturn = (Set)ClassLoaderUtilities.newInstance(classType);
                while (it.hasNext()) {
                    Object key = it.next();
                    Object value = jsonObject.get(key);
                    JSONObject json = (JSONObject)value;
                    Object o = this.fromJSONObjectToOriginalObject(elementsTypes, json);
                    setReturn.add(o);
                }
                return setReturn;
            }
            JSONArray jsonArray = (JSONArray)oResult;
            Object[] oarray = jsonArray.toArray();
            Set setReturn = (Set)ClassLoaderUtilities.newInstance(classType);
            for (int i = 0; i < oarray.length; ++i) {
                JSONObject json = (JSONObject)oarray[i];
                Object o = this.fromJSONObjectToOriginalObject(elementsTypes, json);
                setReturn.add(o);
            }
            return setReturn;
        }
        JSONObject jsonObject = (JSONObject)this.xmlSerializer.read(object);
        return this.fromJSONObjectToOriginalObject(classType, jsonObject);
    }

    private Object fromJSONObjectToOriginalObject(Class<?> classType, JSONObject jsonObject) throws UtilsException {
        this.jsonConfig.setRootClass(classType);
        MorpherRegistry morpherRegistry = JSONUtils.getMorpherRegistry();
        Utilities.registerMorpher(classType, morpherRegistry, new ArrayList<String>(), this.morpherPackage);
        Object o = JSONObject.toBean((JSONObject)jsonObject, (JsonConfig)this.jsonConfig);
        Utilities.morpher(o, morpherRegistry, this.morpherPackage, this.throwExceptionMorpherFailed);
        return o;
    }
}

