/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriInfo;
import org.openspcoop2.utils.service.context.Context;
import org.openspcoop2.utils.service.context.ContextThreadLocal;
import org.openspcoop2.utils.service.context.IContext;
import org.slf4j.Logger;

public class BaseImpl {
    @javax.ws.rs.core.Context
    protected HttpServletRequest servletRequest;
    @javax.ws.rs.core.Context
    protected HttpServletResponse servletResponse;
    @javax.ws.rs.core.Context
    protected UriInfo uriInfo;
    protected Logger log;

    public BaseImpl(Logger log) {
        this.log = log;
    }

    protected synchronized IContext getContext() {
        IContext context = ContextThreadLocal.get();
        if (context instanceof Context) {
            ((Context)context).update(this.servletRequest, this.servletResponse, this.uriInfo, 2, this.log);
            ((Context)context).setRestPath(this.getPathFromRestMethod(context.getMethodName()));
        }
        return context;
    }

    private String getPathFromRestMethod(String methodName) {
        try {
            Class<?> c = this.getClass();
            Class<?>[] interfaces = c.getInterfaces();
            if (interfaces == null || interfaces.length <= 0) {
                return null;
            }
            Class<?> cInterface = null;
            for (int i = 0; i < interfaces.length; ++i) {
                if (interfaces[i] == null || !interfaces[i].isAnnotationPresent(Path.class)) continue;
                cInterface = interfaces[i];
                break;
            }
            if (cInterface == null) {
                return null;
            }
            Method[] methods = cInterface.getMethods();
            if (methods == null || methods.length <= 0) {
                return null;
            }
            Method method = null;
            for (int i = 0; i < methods.length; ++i) {
                if (methods[i] == null || !methods[i].getName().equals(methodName) || !methods[i].isAnnotationPresent(Path.class)) continue;
                method = methods[i];
                break;
            }
            if (method == null) {
                return null;
            }
            Path path = method.getAnnotation(Path.class);
            if (path == null) {
                return null;
            }
            return path.value();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

