/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.authorization;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.openspcoop2.utils.UtilsException;

public class AuthorizationConfigACL {
    public static final String WILDCARD = "*";
    public static final String PREFIX = "auth.";
    public static final String SUFFIX_METHOD = ".resource.method";
    public static final String SUFFIX_PATH = ".resource.path";
    public static final String SUFFIX_PRINCIPAL = ".principal";
    public static final String SUFFIX_ROLES = ".roles";
    public static final String SUFFIX_ROLES_MATCH_ALL = ".roles.matchAll";
    private String name;
    private String method;
    private String path;
    private List<String> principal = new ArrayList<String>();
    private List<String> roles = new ArrayList<String>();
    private boolean rolesMatchAll = false;

    public AuthorizationConfigACL(String name) {
        this.name = name;
    }

    public AuthorizationConfigACL(String name, Properties p) throws UtilsException {
        this(name);
        int i;
        String[] tmpList;
        this.method = p.getProperty(PREFIX + name + SUFFIX_METHOD);
        if (this.method == null) {
            throw new UtilsException("Method undefined for acl '" + this.name + "'");
        }
        this.method = this.method.trim();
        this.path = p.getProperty(PREFIX + name + SUFFIX_PATH);
        if (this.path == null) {
            throw new UtilsException("Path undefined for acl '" + this.name + "'");
        }
        this.path = this.path.trim();
        String tmp = p.getProperty(PREFIX + name + SUFFIX_PRINCIPAL);
        if (tmp != null) {
            if ((tmp = tmp.trim()).contains(",")) {
                tmpList = tmp.split(",");
                for (i = 0; i < tmpList.length; ++i) {
                    this.principal.add(tmpList[i].trim());
                }
            } else {
                this.principal.add(tmp);
            }
        }
        if ((tmp = p.getProperty(PREFIX + name + SUFFIX_ROLES)) != null) {
            if ((tmp = tmp.trim()).contains(",")) {
                tmpList = tmp.split(",");
                for (i = 0; i < tmpList.length; ++i) {
                    this.roles.add(tmpList[i].trim());
                }
            } else {
                this.roles.add(tmp);
            }
        }
        if (!this.roles.isEmpty() && (tmp = p.getProperty(PREFIX + name + SUFFIX_ROLES_MATCH_ALL)) != null) {
            tmp = tmp.trim();
            this.rolesMatchAll = Boolean.parseBoolean(tmp);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<String> getPrincipal() {
        return this.principal;
    }

    public void addPrincipal(String principal) {
        this.principal.add(principal);
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void addRole(String role) {
        this.roles.add(role);
    }

    public boolean isRolesMatchAll() {
        return this.rolesMatchAll;
    }

    public void setRolesMatchAll(boolean rolesMatchAll) {
        this.rolesMatchAll = rolesMatchAll;
    }
}

