/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.authorization;

import java.util.List;
import java.util.stream.Collectors;
import org.openspcoop2.utils.service.authorization.AuthorizationConfig;
import org.openspcoop2.utils.service.authorization.AuthorizationConfigACL;
import org.openspcoop2.utils.service.context.IContext;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.springframework.security.core.GrantedAuthority;

public class AuthorizationManager {
    public static void authorize(IContext context, AuthorizationConfig config) {
        if (config == null || config.getAclList() == null || config.getAclList().isEmpty()) {
            return;
        }
        try {
            String method = context.getServletRequest().getMethod();
            String restPath = context.getRestPath();
            AuthorizationConfigACL acl = null;
            for (AuthorizationConfigACL authorizationConfigACL : config.getAclList()) {
                String methodCheck = authorizationConfigACL.getMethod();
                if (!"*".equals(methodCheck) && !methodCheck.toUpperCase().equals(method.toUpperCase())) continue;
                String pathCheck = authorizationConfigACL.getPath();
                if (!"*".equals(pathCheck)) {
                    if (pathCheck.endsWith("*")) {
                        String patchCheckWitoutStar = pathCheck.substring(0, pathCheck.length() - "*".length());
                        if (!AuthorizationManager.normalizePath(restPath).startsWith(AuthorizationManager.normalizePath(patchCheckWitoutStar))) {
                            continue;
                        }
                    } else if (!AuthorizationManager.normalizePath(restPath).equals(AuthorizationManager.normalizePath(pathCheck))) continue;
                }
                acl = authorizationConfigACL;
                break;
            }
            if (acl == null) {
                throw new Exception("Acl rule match for request not found");
            }
            if (acl.getPrincipal().isEmpty() && acl.getRoles().isEmpty()) {
                return;
            }
            if (!acl.getPrincipal().isEmpty()) {
                for (String string : acl.getPrincipal()) {
                    if (!string.equals(context.getAuthentication().getName())) continue;
                    return;
                }
            }
            if (!acl.getRoles().isEmpty()) {
                for (String string : acl.getRoles()) {
                    List listaRuoliUtenza;
                    boolean found = false;
                    if (context.getAuthentication().getAuthorities() != null && (listaRuoliUtenza = context.getAuthentication().getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList())) != null && !listaRuoliUtenza.isEmpty()) {
                        for (String role : listaRuoliUtenza) {
                            if (!string.equals(role)) continue;
                            if (!acl.isRolesMatchAll()) {
                                return;
                            }
                            found = true;
                            break;
                        }
                    }
                    if (!acl.isRolesMatchAll() || found) continue;
                    break;
                }
            }
            throw new Exception("Acl rule '" + acl.getName() + "' not satisfied");
        }
        catch (Exception eAuthorized) {
            FaultCode.AUTORIZZAZIONE.throwException(String.format("L'utente '%s' non \u00e8 autorizzato ad invocare l'operazione '%s': %s", context.getAuthentication().getName(), context.getMethodName(), eAuthorized.getMessage()));
            return;
        }
    }

    private static String normalizePath(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }
}

