/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.beans;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Problem {
    @Schema(example="https://tools.ietf.org/html/rfc7231#section-6.6.4", description="An absolute URI that identifies the problem type.  When dereferenced, it SHOULD provide human-readable documentation for the problem type (e.g., using HTML). ")
    private String type = "about:blank";
    @Schema(description="A short, summary of the problem type. Written in english and readable for engineers (usually not suited for non technical stakeholders and not localized); example: Service Unavailable ")
    private String title = null;
    @Schema(example="503", description="The HTTP status code generated by the origin server for this occurrence of the problem. ")
    private Integer status = null;
    @Schema(example="Request took too long to complete.", description="A human readable explanation specific to this occurrence of the problem. You MUST NOT expose internal informations, personal data or implementation details through this field. ")
    private String detail = null;
    @Schema(description="An absolute URI that identifies the specific occurrence of the problem. It may or may not yield further information if dereferenced. ")
    private String instance = null;

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Problem type(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Problem title(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty(value="status")
    @Min(value=100L)
    @Max(value=600L)
    public @Min(value=100L) @Max(value=600L) Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Problem status(Integer status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="detail")
    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Problem detail(String detail) {
        this.detail = detail;
        return this;
    }

    @JsonProperty(value="instance")
    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public Problem instance(String instance) {
        this.instance = instance;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Problem {\n");
        sb.append("    type: ").append(Problem.toIndentedString(this.type)).append("\n");
        sb.append("    title: ").append(Problem.toIndentedString(this.title)).append("\n");
        sb.append("    status: ").append(Problem.toIndentedString(this.status)).append("\n");
        sb.append("    detail: ").append(Problem.toIndentedString(this.detail)).append("\n");
        sb.append("    instance: ").append(Problem.toIndentedString(this.instance)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private static String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

