/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.context;

import java.util.Date;
import java.util.HashSet;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.ext.logging.event.DefaultLogEventMapper;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.openspcoop2.utils.logger.beans.context.core.AbstractTransaction;
import org.openspcoop2.utils.logger.beans.context.core.AbstractTransactionWithClient;
import org.openspcoop2.utils.logger.beans.context.core.HttpClient;
import org.openspcoop2.utils.logger.beans.context.core.Response;
import org.openspcoop2.utils.service.context.ContextThreadLocal;
import org.openspcoop2.utils.service.context.IContext;

@NoJSR250Annotations
public class ServiceInfoOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    public ServiceInfoOutInterceptor() {
        super("send");
    }

    public void handleMessage(Message message) throws Fault {
        HashSet sensitiveProtocolHeaders = new HashSet();
        LogEvent event = new DefaultLogEventMapper().map(message, sensitiveProtocolHeaders);
        IContext ctx = ContextThreadLocal.get();
        AbstractTransaction transaction = ctx.getApplicationContext().getTransaction();
        AbstractTransactionWithClient transactionWithClient = null;
        if (transaction instanceof AbstractTransactionWithClient) {
            transactionWithClient = (AbstractTransactionWithClient)transaction;
            if (transactionWithClient.getClient() instanceof HttpClient) {
                HttpClient httpClient = (HttpClient)transactionWithClient.getClient();
                try {
                    if (event.getResponseCode() != null) {
                        httpClient.setResponseStatusCode(Integer.parseInt(event.getResponseCode()));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (transactionWithClient.getResponse() == null) {
                transactionWithClient.setResponse(new Response());
            }
            if (transactionWithClient.getResponse().getDate() == null) {
                transactionWithClient.getResponse().setDate(new Date());
            }
        }
    }
}

