/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.fault.jaxrs;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.utils.service.fault.jaxrs.ITypeGenerator;
import org.openspcoop2.utils.service.fault.jaxrs.ProblemRFC7807;
import org.openspcoop2.utils.service.fault.jaxrs.ProblemValidation;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

@Provider
public class ValidationExceptionMapper
implements ExceptionMapper<ValidationException> {
    private Logger log = LoggerWrapperFactory.getLogger(ValidationExceptionMapper.class);
    private boolean updateTitle = true;
    private ITypeGenerator typeGenerator;

    public boolean isUpdateTitle() {
        return this.updateTitle;
    }

    public void setUpdateTitle(boolean updateTitle) {
        this.updateTitle = updateTitle;
    }

    public ITypeGenerator getTypeGenerator() {
        return this.typeGenerator;
    }

    public void setTypeGenerator(ITypeGenerator typeGenerator) {
        this.typeGenerator = typeGenerator;
    }

    public Response toResponse(ValidationException exception) {
        this.log.error(exception.getMessage(), (Throwable)exception);
        ProblemValidation problem = new ProblemValidation(FaultCode.RICHIESTA_NON_VALIDA.toFault());
        if (exception instanceof ConstraintViolationException) {
            ConstraintViolationException constraint = (ConstraintViolationException)exception;
            for (ConstraintViolation violation : constraint.getConstraintViolations()) {
                problem.addInvalidParam(violation.getPropertyPath().toString(), violation.getMessage(), violation.getInvalidValue());
            }
        }
        this.updateProblem(problem, exception);
        this._setType(problem, exception);
        if (this.updateTitle) {
            problem.setTitle(HttpUtilities.getHttpReason(problem.getStatus()));
        }
        return Response.status((int)problem.getStatus()).entity((Object)problem).type("application/problem+json").build();
    }

    public void _setType(ProblemRFC7807 problem, ValidationException e) {
        if (this.typeGenerator == null) {
            return;
        }
        problem.setType(this.typeGenerator.getType(problem.getStatus(), (Exception)e));
    }

    public void updateProblem(ProblemRFC7807 problem, ValidationException e) {
    }
}

