/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.sonde;

import java.sql.Connection;
import java.util.Date;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.sonde.ParametriSonda;
import org.openspcoop2.utils.sonde.SondaException;
import org.openspcoop2.utils.sonde.SondaFactory;

public abstract class Sonda {
    private ParametriSonda param;
    protected static final String PATTERN = "dd/MM/yyyy HH:mm:ss.sss";

    public Sonda(ParametriSonda param) {
        this.param = param;
    }

    public abstract StatoSonda getStatoSonda();

    protected StatoSonda updateSonda(Connection connection, TipiDatabase tipoDatabase) throws SondaException {
        this.param.setDataUltimoCheck(new Date());
        StatoSonda statoSonda = this.getStatoSonda();
        int statoNew = statoSonda.getStato();
        if (this.param.getStatoUltimoCheck() != statoNew) {
            if (this.param.getStatoUltimoCheck() == 0 && statoNew == 1) {
                this.param.setDataWarn(new Date());
                this.param.setDataError(null);
                this.param.setDataOk(null);
            }
            if (statoNew == 2) {
                this.param.setDataError(new Date());
                this.param.setDataWarn(null);
                this.param.setDataOk(null);
            }
            if (statoNew == 0) {
                this.param.setDataOk(new Date());
                this.param.setDataError(null);
                this.param.setDataWarn(null);
            }
        }
        this.param.setStatoUltimoCheck(statoNew);
        SondaFactory.updateStatoSonda(this.param.getNome(), this, connection, tipoDatabase);
        return statoSonda;
    }

    public ParametriSonda getParam() {
        return this.param;
    }

    public class StatoSonda {
        private int stato;
        private String descrizione;

        public int getStato() {
            return this.stato;
        }

        public void setStato(int stato) {
            this.stato = stato;
        }

        public String getDescrizione() {
            return this.descrizione;
        }

        public void setDescrizione(String descrizione) {
            this.descrizione = descrizione;
        }
    }
}

