/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openspcoop2.utils.transport.TransportUtils;

public abstract class AbstractHttp {
    private String contentType;
    private byte[] content;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private Map<String, String> params = new HashMap<String, String>();
    private InputStream contentStream;

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public InputStream getContentStream() {
        return this.contentStream;
    }

    public void setContentStream(InputStream contentStream) {
        this.contentStream = contentStream;
    }

    public void addHeader(String key, String value) {
        List<String> l = this.headers.remove(key);
        if (l == null) {
            l = new ArrayList<String>();
        }
        l.add(value);
        this.headers.put(key, l);
    }

    public void addHeader(String key, List<String> values) {
        List<String> l = this.headers.remove(key);
        if (l == null) {
            l = new ArrayList<String>();
        }
        l.addAll(values);
        this.headers.put(key, l);
    }

    @Deprecated
    public Map<String, String> getHeaders() {
        return TransportUtils.convertToMapSingleValue(this.headers);
    }

    public Map<String, List<String>> getHeadersValues() {
        return this.headers;
    }

    @Deprecated
    public String getHeader(String header) {
        return TransportUtils.getObjectAsString(this.headers, header);
    }

    public String getHeader_compactMultipleValues(String name) {
        return TransportUtils.getObjectAsString(this.headers, name);
    }

    public String getHeaderFirstValue(String name) {
        List<String> l = this.getHeaderValues(name);
        if (l != null && !l.isEmpty()) {
            return l.get(0);
        }
        return null;
    }

    public List<String> getHeaderValues(String header) {
        return TransportUtils.getRawObject(this.headers, header);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Enumeration<String> getParamsName() {
        return Collections.enumeration(this.params.keySet());
    }

    public void removeParam(String key) {
        this.params.remove(key);
    }

    public String getParam(String key) {
        return this.params.get(key);
    }

    public void addParam(String key, String value) {
        this.params.put(key, value);
    }

    protected String getQueryString() {
        return this.params.entrySet().stream().map(e -> URLEncoder.encode((String)e.getKey(), StandardCharsets.UTF_8) + "=" + URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
    }
}

