/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import com.sun.xml.messaging.saaj.packaging.mime.internet.ParameterList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.mail.internet.ContentType;
import javax.xml.soap.SOAPException;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.mime.MultipartUtils;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.slf4j.Logger;

public class ContentTypeUtilities {
    public static void validateContentType(String ct) throws UtilsException {
        try {
            if (ct != null && !"".equals(ct)) {
                String internal;
                new ContentType(ct).getBaseType();
                if (ContentTypeUtilities.isMultipart(ct) && (internal = ContentTypeUtilities.getInternalMultipartContentType(ct)) != null) {
                    ContentTypeUtilities.isMtom(internal);
                }
            }
        }
        catch (Throwable e) {
            String msgError = e.getMessage();
            if (msgError == null || "".equals(msgError) || "null".equals(msgError)) {
                msgError = Utilities.getInnerNotEmptyMessageException(e).getMessage();
            }
            if (msgError == null || "".equals(msgError) || "null".equals(msgError)) {
                msgError = "Parsing failed";
            }
            throw new UtilsException(msgError, e);
        }
    }

    public static String buildContentType(String baseType, Map<String, String> parameters) throws UtilsException {
        try {
            com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType cType = new com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType(baseType);
            if (parameters != null && parameters.size() > 0) {
                for (String parameterName : parameters.keySet()) {
                    String parameterValue = parameters.get(parameterName);
                    if (cType.getParameterList() == null) {
                        cType.setParameterList(new ParameterList());
                    }
                    cType.getParameterList().remove(parameterName);
                    cType.getParameterList().set(parameterName, parameterValue);
                }
            }
            String ct = cType.toString();
            ct = ContentTypeUtilities.normalizeToRfc7230(ct);
            ct = ct.trim();
            return ct;
        }
        catch (Exception e) {
            throw new RuntimeException("Error during buildContentType: " + e.getMessage(), e);
        }
    }

    public static String normalizeToRfc7230(String ct) {
        while (ct.contains("\r\n")) {
            ct = ct.replace("\r\n", " ");
        }
        while (ct.contains("\r")) {
            ct = ct.replace("\r", " ");
        }
        while (ct.contains("\n")) {
            ct = ct.replace("\n", " ");
        }
        while (ct.contains("\t")) {
            ct = ct.replace("\t", " ");
        }
        return ct.trim();
    }

    public static String readBaseTypeFromContentType(String cType) throws UtilsException {
        try {
            com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType contentType = new com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType(cType);
            return contentType.getBaseType();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static String readPrimaryTypeFromContentType(String cType) throws UtilsException {
        try {
            com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType contentType = new com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType(cType);
            return contentType.getPrimaryType();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static String readSubTypeFromContentType(String cType) throws UtilsException {
        try {
            com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType contentType = new com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType(cType);
            return contentType.getSubType();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static String readCharsetFromContentType(String cType) throws UtilsException {
        try {
            com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType contentType = new com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType(cType);
            String charsetParam = contentType.getParameter("charset");
            if (charsetParam != null) {
                return charsetParam.trim();
            }
            return null;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static boolean isMatch(Logger logNullable, String contentTypeParam, String contentTypeAtteso) throws UtilsException {
        ArrayList<String> l = new ArrayList<String>();
        l.add(contentTypeAtteso);
        return ContentTypeUtilities.isMatch(logNullable, contentTypeParam, l);
    }

    public static boolean isMatch(Logger logNullable, String contentTypeParam, List<String> contentTypeAttesi) throws UtilsException {
        if (contentTypeAttesi == null || contentTypeAttesi.isEmpty()) {
            return true;
        }
        String baseTypeHttp = contentTypeParam != null ? ContentTypeUtilities.readBaseTypeFromContentType(contentTypeParam) : null;
        boolean found = false;
        for (String checkContentType : contentTypeAttesi) {
            boolean isMatchRegExp;
            boolean isMatchEscaped;
            block20: {
                if ("empty".equals(checkContentType)) {
                    if (baseTypeHttp != null && !"".equals(baseTypeHttp)) continue;
                    found = true;
                    break;
                }
                if (baseTypeHttp == null) continue;
                if (checkContentType == null || "".equals(checkContentType) || !checkContentType.contains("/") || checkContentType.startsWith("/") || checkContentType.endsWith("/")) {
                    throw new UtilsException("Configurazione errata, content type indicato (" + checkContentType + ") possiede un formato non corretto (atteso: type/subtype)");
                }
                String[] ctVerifica = checkContentType.split("/");
                String contentTypeEscaped = null;
                if (ctVerifica != null && ctVerifica.length == 2) {
                    StringBuilder bf = new StringBuilder();
                    String part1 = ctVerifica[0].trim();
                    if ("*".equals(part1)) {
                        bf.append("(.+)");
                    } else {
                        part1 = part1.replace("+", "\\+");
                        bf.append(part1);
                    }
                    bf.append("/");
                    String part2 = ctVerifica[1].trim();
                    if ("*".equals(part2)) {
                        bf.append("(.+)");
                    } else if (part2.startsWith("*")) {
                        bf.append("(.+)");
                        String sub = part2.substring(1);
                        sub = sub.replace("+", "\\+");
                        bf.append(sub);
                    } else {
                        part2 = part2.replace("+", "\\+");
                        bf.append(part2);
                    }
                    contentTypeEscaped = bf.toString();
                }
                isMatchEscaped = false;
                isMatchRegExp = false;
                if (contentTypeEscaped != null) {
                    try {
                        isMatchEscaped = RegularExpressionEngine.isMatch(baseTypeHttp, contentTypeEscaped);
                    }
                    catch (RegExpNotFoundException part2) {
                    }
                    catch (Exception e) {
                        throw new UtilsException(e.getMessage(), e);
                    }
                }
                if (!isMatchEscaped) {
                    try {
                        isMatchRegExp = RegularExpressionEngine.isMatch(baseTypeHttp, checkContentType);
                    }
                    catch (RegExpNotFoundException e) {
                    }
                    catch (Exception e) {
                        if (contentTypeEscaped == null) {
                            throw new UtilsException(e.getMessage(), e);
                        }
                        if (logNullable == null) break block20;
                        logNullable.debug("isMatch failed: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (!isMatchEscaped && !isMatchRegExp) continue;
            found = true;
            break;
        }
        return found;
    }

    public static boolean isMultipartType(String cType) throws UtilsException {
        try {
            com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType contentType = new com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType(cType);
            String baseType = contentType.getBaseType();
            if (baseType != null) {
                baseType = baseType.toLowerCase();
            }
            return baseType != null && baseType.startsWith("multipart/");
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Deprecated
    public static boolean isMultipart(String cType) throws UtilsException {
        return ContentTypeUtilities.isMultipartRelated(cType);
    }

    public static boolean isMultipartRelated(String cType) throws UtilsException {
        return ContentTypeUtilities._isMultipart(cType, "multipart/related");
    }

    public static boolean isMultipartMixed(String cType) throws UtilsException {
        return ContentTypeUtilities._isMultipart(cType, "multipart/mixed");
    }

    public static boolean isMultipartAlternative(String cType) throws UtilsException {
        return ContentTypeUtilities._isMultipart(cType, "multipart/alternative");
    }

    public static boolean isMultipartFormData(String cType) throws UtilsException {
        return ContentTypeUtilities._isMultipart(cType, "multipart/form-data");
    }

    private static boolean _isMultipart(String cType, String expected) throws UtilsException {
        try {
            com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType contentType = new com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType(cType);
            String baseType = contentType.getBaseType();
            if (baseType != null) {
                baseType = baseType.toLowerCase();
            }
            return baseType != null && baseType.equals(expected);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static boolean isMultipartContentType(String cType) throws UtilsException {
        try {
            com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType contentType = new com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType(cType);
            String baseType = contentType.getBaseType();
            if (baseType != null) {
                baseType = baseType.toLowerCase();
            }
            return baseType != null && baseType.startsWith("multipart/");
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static String getInternalMultipartContentType(String cType) throws UtilsException {
        try {
            com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType contentType = new com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType(cType);
            String baseType = contentType.getBaseType();
            if (baseType != null) {
                baseType = baseType.toLowerCase();
            }
            String internalContentType = null;
            boolean mtom = false;
            if (baseType == null) {
                internalContentType = null;
            } else if (baseType.equals("multipart/related")) {
                String typeParam = contentType.getParameter("type");
                if (typeParam != null && "application/xop+xml".equals(internalContentType = typeParam.toLowerCase())) {
                    mtom = true;
                }
            } else {
                internalContentType = baseType;
            }
            if (mtom) {
                internalContentType = ContentTypeUtilities.readInternalMultipartMtomContentType(contentType);
            }
            return internalContentType;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Deprecated
    public static String buildMultipartContentType(byte[] message, String type) throws UtilsException {
        return ContentTypeUtilities.buildMultipartRelatedContentType(message, type);
    }

    public static String buildMultipartRelatedContentType(byte[] message, String type) throws UtilsException {
        return ContentTypeUtilities.buildMultipartContentType("related", message, type);
    }

    public static String buildMultipartContentType(String subtype, byte[] message, String type) throws UtilsException {
        if (MultipartUtils.messageWithAttachment(message)) {
            String IDfirst = MultipartUtils.firstContentID(message);
            return ContentTypeUtilities.buildMultipartContentType(subtype, message, type, IDfirst);
        }
        throw new UtilsException("Messaggio non contiene una struttura mime");
    }

    @Deprecated
    public static String buildMultipartContentType(byte[] message, String type, String ID) throws UtilsException {
        return ContentTypeUtilities.buildMultipartRelatedContentType(message, type, ID);
    }

    public static String buildMultipartRelatedContentType(byte[] message, String type, String ID) throws UtilsException {
        return ContentTypeUtilities.buildMultipartContentType("related", message, type, ID);
    }

    public static String buildMultipartContentType(String subtype, byte[] message, String type, String ID) throws UtilsException {
        if (MultipartUtils.messageWithAttachment(message)) {
            String boundary = MultipartUtils.findBoundary(message);
            if (boundary == null) {
                throw new UtilsException("Errore avvenuto durante la lettura del boundary associato al multipart message.");
            }
            StringBuilder bf = new StringBuilder();
            bf.append("multipart/" + subtype);
            if (type != null) {
                bf.append("; ").append("type").append("=\"").append(type).append("\"");
            }
            if (ID != null) {
                bf.append("; ").append("start").append("=\"").append(ID).append("\"");
            }
            bf.append("; ").append("boundary").append("=\"").append(boundary.substring(2, boundary.length())).append("\"");
            return bf.toString();
        }
        throw new UtilsException("Messaggio non contiene una struttura mime");
    }

    public static boolean isMtom(String cType) throws UtilsException {
        try {
            com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType contentType = new com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType(cType);
            String baseType = contentType.getBaseType();
            if (baseType != null) {
                baseType = baseType.toLowerCase();
            }
            boolean mtom = false;
            if (baseType != null && baseType.equals("multipart/related")) {
                String typeParam = contentType.getParameter("type");
                if (typeParam == null) {
                    throw new SOAPException("Missing 'type' parameter in multipart/related");
                }
                String soapContentType = typeParam.toLowerCase();
                if ("application/xop+xml".equals(soapContentType)) {
                    mtom = true;
                }
            }
            return mtom;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static String readInternalMultipartMtomContentType(String contentType) throws UtilsException {
        try {
            return ContentTypeUtilities.readInternalMultipartMtomContentType(new com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType(contentType));
        }
        catch (UtilsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static String readInternalMultipartMtomContentType(com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType contentType) throws UtilsException {
        try {
            if (contentType == null) {
                throw new UtilsException("ContentType non fornito");
            }
            if (contentType.getBaseType() == null) {
                throw new UtilsException("ContentType.baseType non definito");
            }
            if (!"multipart/related".equals(contentType.getBaseType().toLowerCase())) {
                throw new UtilsException("ContentType.baseType [" + contentType.getBaseType() + "] differente da quello atteso per un messaggio MTOM/XOP [multipart/related]");
            }
            if (contentType.getParameterList() == null || contentType.getParameterList().size() <= 0) {
                throw new UtilsException("ContentType non conforme a quanto definito nella specifica MTOM/XOP (non sono presenti parametri)");
            }
            String type = contentType.getParameter("type");
            if (type == null) {
                throw new UtilsException("ContentType non conforme a quanto definito nella specifica MTOM/XOP (Parametro 'type' non presente)");
            }
            if (!"application/xop+xml".equals(type.toLowerCase())) {
                throw new UtilsException("ContentType.parameters.type [" + type + "] differente da quello atteso per un messaggio MTOM/XOP [application/xop+xml]");
            }
            String startInfo = contentType.getParameter("start-info");
            if (startInfo == null) {
                throw new UtilsException("ContentType non conforme a quanto definito nella specifica MTOM/XOP (Parametro 'start-info' non presente)");
            }
            return ContentTypeUtilities.readBaseTypeFromContentType(startInfo);
        }
        catch (UtilsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static String readMultipartBoundaryFromContentType(String cType) throws UtilsException {
        try {
            com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType contentType = new com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType(cType);
            String boundaryParam = contentType.getParameter("boundary");
            if (boundaryParam != null) {
                return boundaryParam.trim();
            }
            return null;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

