/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HttpConstants {
    public static byte[] CR_LF_BREAK_LINE = new byte[]{13, 10};
    public static String HTTP_HEADER_SEPARATOR = ": ";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_LOCATION = "Content-Location";
    public static final String CONTENT_ID = "Content-ID";
    public static final String RETURN_CODE = "ReturnCode";
    public static final String CONTENT_TYPE_NON_VALORIZZATO = "Not valued (null)";
    public static final String CONTENT_TYPE_NON_PRESENTE = "Undefined";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String TRANSFER_ENCODING_VALUE_CHUNCKED = "chunked";
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final String CONTENT_TRANSFER_ENCODING_VALUE_BINARY = "binary";
    public static final String CONTENT_TRANSFER_ENCODING_VALUE_BASE64 = "base64";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String REDIRECT_LOCATION = "Location";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String ACCEPT = "Accept";
    public static final String CONNECTION = "Connection";
    public static final String CONNECTION_VALUE_KEEP_ALIVE = "keep-alive";
    public static final String CONNECTION_VALUE_CLOSE = "close";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String COOKIE = "Cookie";
    public static final String COOKIE_SEPARATOR = ";";
    public static final String COOKIE_NAME_VALUE_SEPARATOR = "=";
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String SET_COOKIE_EXPIRES_PARAMETER = "Expires";
    public static final String SET_COOKIE_MAX_AGE_PARAMETER = "Max-Age";
    public static final String SET_COOKIE_PATH_PARAMETER = "Path";
    public static final String SET_COOKIE_DOMAIN_PARAMETER = "Domain";
    public static final String SET_COOKIE_SECURE_PARAMETER = "Secure";
    public static final String SET_COOKIE_HTTP_ONLY_PARAMETER = "HttpOnly";
    public static final String DIGEST = "Digest";
    public static final String DIGEST_ALGO_MD5 = "MD5";
    public static final String DIGEST_ALGO_SHA = "SHA";
    public static final String DIGEST_ALGO_SHA_1 = "SHA-1";
    public static final String DIGEST_ALGO_SHA_256 = "SHA-256";
    public static final String DIGEST_ALGO_SHA_384 = "SHA-384";
    public static final String DIGEST_ALGO_SHA_512 = "SHA-512";
    public static final String AUTHENTICATION_BASIC = "Basic";
    public static final String AUTHENTICATION_BEARER = "Bearer";
    public static final String AUTHORIZATION = "Authorization";
    public static final String AUTHORIZATION_PREFIX_BASIC = "Basic ";
    public static final String AUTHORIZATION_PREFIX_BEARER = "Bearer ";
    public static final String AUTHORIZATION_RESPONSE_WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String AUTHORIZATION_RESPONSE_WWW_AUTHENTICATE_BASIC_REALM_PREFIX = "Basic realm=\"\"";
    public static final String AUTHORIZATION_RESPONSE_WWW_AUTHENTICATE_BASIC_REALM_SUFFIX = "\"";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_DISPOSITION_ATTACH_FILE_PREFIX = "attachment; filename=";
    public static final String CONTENT_DISPOSITION_FORM_DATA_FILE_PREFIX = "form-data; filename=";
    public static final String CONTENT_DISPOSITION_FORM_DATA_NAME_PREFIX = "form-data; name=";
    public static final String CONTENT_DISPOSITION_NAME_PREFIX = "name=";
    public static final String CONTENT_DISPOSITION_FILENAME_PREFIX = "filename=";
    public static final String CACHE_STATUS_DIRECTIVE_NO_CACHE = "no-cache";
    public static final String CACHE_STATUS_DIRECTIVE_NO_STORE = "no-store";
    public static final String CACHE_STATUS_DIRECTIVE_MAX_AGE = "max-age";
    public static final String CACHE_STATUS_DIRECTIVE_MUST_REVALIDATE = "must-revalidate";
    public static final String CACHE_STATUS_HTTP_1_1 = "Cache-Control";
    public static final String CACHE_STATUS_HTTP_1_1_DISABLE_CACHE = "no-cache, no-store, must-revalidate";
    public static final String CACHE_STATUS_HTTP_1_0 = "Pragma";
    public static final String CACHE_STATUS_HTTP_1_0_DISABLE_CACHE = "no-cache";
    public static final String CACHE_STATUS_PROXY_EXPIRES = "Expires";
    public static final long CACHE_STATUS_PROXY_EXPIRES_DISABLE_CACHE = 0L;
    public static final String CACHE_STATUS_VARY = "Vary";
    public static final String CACHE_STATUS_VARY_UNCACHABLE = "*";
    public static final List<String> CACHE_STATUS_HEADERS = new ArrayList<String>();
    public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    public static final String ACCESS_CONTROL_REQUEST_ORIGIN = "Origin";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ALLOW_HEADERS = "Allow";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN_ALL_VALUE = "*";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN_VARY = "Vary";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN_VARY_ORIGIN_VALUE = "Origin";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String ACCESS_CONTROL_MAX_AGE_DISABLE_CACHE = "-1";
    public static final List<String> ACCESS_CONTROL_SIMPLE_REQUEST_CONTENT_TYPES;
    public static final String USER_AGENT = "User-Agent";
    public static final String SERVER = "Server";
    public static final String X_POWERED_BY = "X-Powered-By";
    public static final String CONTENT_TYPE_SOAP_1_1 = "text/xml";
    public static final String CONTENT_TYPE_SOAP_1_2 = "application/soap+xml";
    public static final String CONTENT_TYPE_APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String CONTENT_TYPE_ZIP = "application/zip";
    public static final String CONTENT_TYPE_PDF = "application/pdf";
    public static final String CONTENT_TYPE_APPLICATION_XOP_XML = "application/xop+xml";
    public static final String CONTENT_TYPE_HTML = "text/html";
    public static final String CONTENT_TYPE_PLAIN = "text/plain";
    public static final String CONTENT_TYPE_CSV = "text/csv";
    public static final String CONTENT_TYPE_XML = "application/xml";
    public static final String CONTENT_TYPE_TEXT_XML = "text/xml";
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CONTENT_TYPE_OPENSPCOOP2_TUNNEL_SOAP = "application/openspcoop2";
    public static final String CONTENT_TYPE_X_DOWNLOAD = "application/x-download";
    public static final String CONTENT_TYPE_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE_FORM_DATA = "multipart/form-data";
    public static final String CONTENT_TYPE_JSON_PROBLEM_DETAILS_RFC_7807 = "application/problem+json";
    public static final String CONTENT_TYPE_XML_PROBLEM_DETAILS_RFC_7807 = "application/problem+xml";
    public static final String CONTENT_TYPE_OCSP_REQUEST = "application/ocsp-request";
    public static final String CONTENT_TYPE_OCSP_RESPONSE = "application/ocsp-response";
    public static final String SOAP11_MANDATORY_HEADER_HTTP_SOAP_ACTION = "SOAPAction";
    public static final String SOAP12_OPTIONAL_CONTENT_TYPE_PARAMETER_SOAP_ACTION = "action";
    public static final String CONTENT_TYPE_PARAMETER_CHARSET = "charset";
    public static final String CONTENT_TYPE_MULTIPART_TYPE = "multipart";
    public static final String CONTENT_TYPE_MULTIPART_ALTERNATIVE_SUBTYPE = "alternative";
    public static final String CONTENT_TYPE_MULTIPART_MIXED_SUBTYPE = "mixed";
    public static final String CONTENT_TYPE_MULTIPART_RELATED_SUBTYPE = "related";
    public static final String CONTENT_TYPE_MULTIPART_FORM_DATA_SUBTYPE = "form-data";
    public static final String CONTENT_TYPE_MULTIPART_ALTERNATIVE = "multipart/alternative";
    public static final String CONTENT_TYPE_MULTIPART_MIXED = "multipart/mixed";
    public static final String CONTENT_TYPE_MULTIPART_RELATED = "multipart/related";
    public static final String CONTENT_TYPE_MULTIPART_FORM_DATA = "multipart/form-data";
    @Deprecated
    public static final String CONTENT_TYPE_MULTIPART = "multipart/related";
    public static final String CONTENT_TYPE_MULTIPART_PARAMETER_BOUNDARY = "boundary";
    public static final String CONTENT_TYPE_MULTIPART_PARAMETER_TYPE = "type";
    public static final String CONTENT_TYPE_MULTIPART_PARAMETER_START = "start";
    public static final String CONTENT_TYPE_MULTIPART_PARAMETER_START_INFO = "start-info";
    public static final String CONTENT_TYPE_MULTIPART_PARAMETER_FORM_DATA = "form-data";
    public static final String SEPARATOR_SOURCE = ":";
    public static final String HEADER_NAME_CONTENT_SECURITY_POLICY = "Content-Security-Policy";
    public static final String HEADER_NAME_CONTENT_SECURITY_POLICY_REPORT_ONLY = "Content-Security-Policy-Report-Only";

    public static boolean isCacheStatusHeader(String hdr) {
        if (hdr == null) {
            return false;
        }
        for (String h : CACHE_STATUS_HEADERS) {
            if (!h.toLowerCase().equals(hdr.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    static {
        CACHE_STATUS_HEADERS.add(CACHE_STATUS_HTTP_1_1);
        CACHE_STATUS_HEADERS.add(CACHE_STATUS_HTTP_1_0);
        CACHE_STATUS_HEADERS.add("Expires");
        CACHE_STATUS_HEADERS.add("Vary");
        ACCESS_CONTROL_SIMPLE_REQUEST_CONTENT_TYPES = new ArrayList<String>(Arrays.asList(CONTENT_TYPE_X_WWW_FORM_URLENCODED, "multipart/form-data", CONTENT_TYPE_PLAIN));
    }
}

