/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import javax.mail.internet.MimeUtility;
import org.apache.logging.log4j.Level;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.transport.http.RFC2047Encoding;
import org.slf4j.Logger;

public class RFC2047Utilities {
    private static Logger log = null;
    private static final String VALORE_DIVERSO_ATTESO = "Riscontrato valore diverso da quello atteso";
    private static final String VALORE_DIVERSO_SORGENTE = "Valore decodificato diverso dal sorgente";
    private static final String ENCODED_IN = "] encoded in RFC2047(";
    private static final String DECODE = "Decode: ";

    public static void main(String[] args) throws Exception {
        RFC2047Utilities.test();
    }

    private static void initLogger() {
        LoggerWrapperFactory.setDefaultConsoleLogConfiguration(Level.ALL);
        log = LoggerWrapperFactory.getLogger(RFC2047Utilities.class);
    }

    private static void logInfo(String msg) {
        log.info(msg);
    }

    public static void test() throws UtilsException {
        RFC2047Utilities.initLogger();
        String stringIso88591 = "f\u00fcr psychisch";
        String stringUsAscii = "fur psychisch";
        String stringLunga = "Non \u00e8 possibile inviare un header con questi/caratteri nella richiesta";
        boolean v = RFC2047Utilities.isAllCharactersInCharset(stringIso88591, org.openspcoop2.utils.resources.Charset.ISO_8859_1);
        RFC2047Utilities.logInfo("IS [" + stringIso88591 + "] in CHARSET ISO_8859_1 ?: " + v);
        if (!v) {
            throw new UtilsException(VALORE_DIVERSO_ATTESO);
        }
        v = RFC2047Utilities.isAllCharactersInCharset(stringIso88591, org.openspcoop2.utils.resources.Charset.US_ASCII);
        RFC2047Utilities.logInfo("IS [" + stringIso88591 + "] in CHARSET US_ASCII ?: " + v);
        if (v) {
            throw new UtilsException(VALORE_DIVERSO_ATTESO);
        }
        v = RFC2047Utilities.isAllCharactersInCharset(stringUsAscii, org.openspcoop2.utils.resources.Charset.ISO_8859_1);
        RFC2047Utilities.logInfo("IS [" + stringUsAscii + "] in CHARSET ISO_8859_1 ?: " + v);
        if (!v) {
            throw new UtilsException(VALORE_DIVERSO_ATTESO);
        }
        v = RFC2047Utilities.isAllCharactersInCharset(stringUsAscii, org.openspcoop2.utils.resources.Charset.US_ASCII);
        RFC2047Utilities.logInfo("IS [" + stringUsAscii + "] in CHARSET US_ASCII ?: " + v);
        if (!v) {
            throw new UtilsException(VALORE_DIVERSO_ATTESO);
        }
        RFC2047Utilities.logInfo("\n*** RFC2047 ISO_8859_1 B ***");
        String varRFC2047ISO88591B = RFC2047Utilities.encode(stringIso88591, org.openspcoop2.utils.resources.Charset.ISO_8859_1, RFC2047Encoding.B);
        RFC2047Utilities.logInfo("[" + stringIso88591 + ENCODED_IN + org.openspcoop2.utils.resources.Charset.ISO_8859_1 + "," + RFC2047Encoding.B + "): " + varRFC2047ISO88591B);
        String decode = RFC2047Utilities.decode(varRFC2047ISO88591B);
        RFC2047Utilities.logInfo(DECODE + decode);
        if (!stringIso88591.equals(decode)) {
            throw new UtilsException(VALORE_DIVERSO_SORGENTE);
        }
        RFC2047Utilities.logInfo("\n*** RFC2047 ISO_8859_1 Q ***");
        String varRFC2047ISO88591Q = RFC2047Utilities.encode(stringIso88591, org.openspcoop2.utils.resources.Charset.ISO_8859_1, RFC2047Encoding.Q);
        RFC2047Utilities.logInfo("[" + stringIso88591 + ENCODED_IN + org.openspcoop2.utils.resources.Charset.ISO_8859_1 + "," + RFC2047Encoding.Q + "): " + varRFC2047ISO88591Q);
        decode = RFC2047Utilities.decode(varRFC2047ISO88591Q);
        RFC2047Utilities.logInfo(DECODE + decode);
        if (!stringIso88591.equals(decode)) {
            throw new UtilsException(VALORE_DIVERSO_SORGENTE);
        }
        RFC2047Utilities.logInfo("\n*** RFC2047 US_ASCII B ***");
        String varRFC2047USASCIIB = RFC2047Utilities.encode(stringIso88591, org.openspcoop2.utils.resources.Charset.US_ASCII, RFC2047Encoding.B);
        RFC2047Utilities.logInfo("[" + stringIso88591 + ENCODED_IN + org.openspcoop2.utils.resources.Charset.US_ASCII + "," + RFC2047Encoding.B + "): " + varRFC2047USASCIIB);
        decode = RFC2047Utilities.decode(varRFC2047USASCIIB);
        RFC2047Utilities.logInfo(DECODE + decode);
        if (!stringIso88591.equals(decode)) {
            throw new UtilsException(VALORE_DIVERSO_SORGENTE);
        }
        RFC2047Utilities.logInfo("\n*** RFC2047 US_ASCII Q ***");
        String varRFC2047USASCIIQ = RFC2047Utilities.encode(stringIso88591, org.openspcoop2.utils.resources.Charset.US_ASCII, RFC2047Encoding.Q);
        RFC2047Utilities.logInfo("[" + stringIso88591 + ENCODED_IN + org.openspcoop2.utils.resources.Charset.US_ASCII + "," + RFC2047Encoding.Q + "): " + varRFC2047USASCIIQ);
        decode = RFC2047Utilities.decode(varRFC2047USASCIIQ);
        RFC2047Utilities.logInfo(DECODE + decode);
        if (!stringIso88591.equals(decode)) {
            throw new UtilsException(VALORE_DIVERSO_SORGENTE);
        }
        RFC2047Utilities.logInfo("\n*** RFC2047 US_ASCII B (stringa lunga) ***");
        varRFC2047USASCIIB = RFC2047Utilities.encode(stringLunga, org.openspcoop2.utils.resources.Charset.US_ASCII, RFC2047Encoding.B);
        RFC2047Utilities.logInfo("[" + stringLunga + ENCODED_IN + org.openspcoop2.utils.resources.Charset.US_ASCII + "," + RFC2047Encoding.B + "): " + varRFC2047USASCIIB);
        decode = RFC2047Utilities.decode(varRFC2047USASCIIB);
        RFC2047Utilities.logInfo(DECODE + decode);
        if (!stringLunga.equals(decode)) {
            throw new UtilsException(VALORE_DIVERSO_SORGENTE);
        }
        RFC2047Utilities.logInfo("\n*** RFC2047 US_ASCII Q (stringa lunga) ***");
        varRFC2047USASCIIQ = RFC2047Utilities.encode(stringLunga, org.openspcoop2.utils.resources.Charset.US_ASCII, RFC2047Encoding.Q);
        RFC2047Utilities.logInfo("[" + stringLunga + ENCODED_IN + org.openspcoop2.utils.resources.Charset.US_ASCII + "," + RFC2047Encoding.Q + "): " + varRFC2047USASCIIQ);
        decode = RFC2047Utilities.decode(varRFC2047USASCIIQ);
        RFC2047Utilities.logInfo(DECODE + decode);
        if (!stringLunga.equals(decode)) {
            throw new UtilsException(VALORE_DIVERSO_SORGENTE);
        }
    }

    public static String encode(String value, org.openspcoop2.utils.resources.Charset charset, RFC2047Encoding encoding) throws UtilsException {
        try {
            return MimeUtility.encodeWord((String)value, (String)charset.getValue(), (String)encoding.name());
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static String decode(String value) throws UtilsException {
        try {
            return MimeUtility.decodeText((String)value);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static boolean isAllCharactersInCharset(String value, org.openspcoop2.utils.resources.Charset charset) throws UtilsException {
        try {
            CharsetEncoder encoder = Charset.forName(charset.getValue()).newEncoder();
            return encoder.canEncode(value);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void validHeader(String key, List<String> values) throws UtilsException {
        if (values != null && !values.isEmpty()) {
            for (String value : values) {
                RFC2047Utilities.validHeader(key, value);
            }
        }
    }

    public static void validHeader(String key, String value) throws UtilsException {
        int lf = 10;
        int index = key.indexOf(lf);
        if (index != -1) {
            throw new UtilsException("Found illegal character(s) in message header field [" + key + "]");
        }
        if (value == null) {
            return;
        }
        index = value.indexOf(lf);
        while (index != -1) {
            char c;
            if (++index < value.length() && ((c = value.charAt(index)) == ' ' || c == '\t')) {
                index = value.indexOf(lf, index);
                continue;
            }
            throw new UtilsException("Found Illegal character(s) in message header [" + key + "]. Found value: [" + value + "]");
        }
    }
}

