/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import java.io.Serializable;
import java.security.KeyStore;
import java.security.cert.CertStore;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.utils.LoggerBuffer;
import org.slf4j.Logger;

public class SSLConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean trustAllCerts = false;
    private transient KeyStore trustStore;
    private transient boolean trustStoreHsm;
    private String trustStoreLocation;
    private String trustStorePassword;
    private String trustManagementAlgorithm;
    private String trustStoreType;
    private String trustStoreCRLsLocation;
    private transient CertStore trustStoreCRLs;
    private String trustStoreOCSPPolicy;
    private transient KeyStore keyStore;
    private transient boolean keyStoreHsm;
    private String keyStoreLocation;
    private String keyStorePassword;
    private String keyAlias;
    private String keyPassword;
    private String keyManagementAlgorithm;
    private String keyStoreType;
    private String keyStoreBYOKPolicy;
    private boolean hostnameVerifier = true;
    private String classNameHostnameVerifier;
    private String sslType = null;
    private boolean secureRandomSet = false;
    private boolean secureRandom = false;
    private String secureRandomAlgorithm = null;
    private StringBuilder sbError;
    private StringBuilder sbDebug;
    private transient Logger logger;
    private Map<String, Object> dynamicMap;

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean includePassword) {
        StringBuilder sb = new StringBuilder();
        sb.append("sslType=").append(this.sslType);
        sb.append(" ");
        sb.append("secureRandom=").append(this.secureRandom);
        sb.append(" ");
        if (this.secureRandomAlgorithm != null) {
            sb.append("secureRandomAlgorithm=").append(this.secureRandomAlgorithm);
            sb.append(" ");
        }
        sb.append("hostnameVerifier=").append(this.hostnameVerifier);
        sb.append(" ");
        if (this.classNameHostnameVerifier != null) {
            sb.append("classNameHostnameVerifier=").append(this.classNameHostnameVerifier);
            sb.append(" ");
        }
        sb.append("trustAllCerts=").append(this.trustAllCerts);
        sb.append(" ");
        if (!this.trustAllCerts) {
            sb.append("trustStoreLocation=").append(this.trustStoreLocation);
            sb.append(" ");
            sb.append("trustStoreType=").append(this.trustStoreType);
            sb.append(" ");
            sb.append("trustStorePassword=").append(includePassword ? this.trustStorePassword : this.hidePassword(this.trustStorePassword));
            sb.append(" ");
            sb.append("trustManagementAlgorithm=").append(this.trustManagementAlgorithm);
            sb.append(" ");
            sb.append("trustStoreCRLsLocation=").append(this.trustStoreCRLsLocation);
            sb.append(" ");
            sb.append("trustStoreOCSPPolicy=").append(this.trustStoreOCSPPolicy);
            sb.append(" ");
        } else if (this.trustStoreOCSPPolicy != null && StringUtils.isNotEmpty((String)this.trustStoreOCSPPolicy)) {
            sb.append("trustStoreCRLsLocation=").append(this.trustStoreCRLsLocation);
            sb.append(" ");
            sb.append("trustStoreOCSPPolicy=").append(this.trustStoreOCSPPolicy);
            sb.append(" ");
        }
        if (this.keyStoreLocation != null) {
            sb.append("keyStoreLocation=").append(this.keyStoreLocation);
            sb.append(" ");
            sb.append("keyStoreType=").append(this.keyStoreType);
            sb.append(" ");
            sb.append("keyStorePassword=").append(includePassword ? this.keyStorePassword : this.hidePassword(this.keyStorePassword));
            sb.append(" ");
            sb.append("keyStoreBYOKPolicy=").append(this.keyStoreBYOKPolicy);
            sb.append(" ");
            sb.append("keyAlias=").append(this.keyAlias);
            sb.append(" ");
            sb.append("keyPassword=").append(includePassword ? this.keyPassword : this.hidePassword(this.keyPassword));
            sb.append(" ");
            sb.append("keyManagementAlgorithm=").append(this.keyManagementAlgorithm);
            sb.append(" ");
        } else {
            sb.append("keyStore=disabled");
            sb.append(" ");
        }
        return sb.toString();
    }

    private String hidePassword(String value) {
        return value != null ? "***" : "unset";
    }

    public boolean isTrustAllCerts() {
        return this.trustAllCerts;
    }

    public void setTrustAllCerts(boolean trustAllCerts) {
        this.trustAllCerts = trustAllCerts;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public boolean isTrustStoreHsm() {
        return this.trustStoreHsm;
    }

    public void setTrustStore(KeyStore trustStore) {
        this.setTrustStore(trustStore, false);
    }

    public void setTrustStore(KeyStore trustStore, boolean hsm) {
        this.trustStore = trustStore;
        this.trustStoreHsm = hsm;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public boolean isKeyStoreHsm() {
        return this.keyStoreHsm;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.setKeyStore(keyStore, false);
    }

    public void setKeyStore(KeyStore keyStore, boolean hsm) {
        this.keyStore = keyStore;
        this.keyStoreHsm = hsm;
    }

    public String getTrustStoreLocation() {
        return this.trustStoreLocation;
    }

    public void setTrustStoreLocation(String trustStoreLocation) {
        this.trustStoreLocation = trustStoreLocation;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getTrustManagementAlgorithm() {
        return this.trustManagementAlgorithm;
    }

    public void setTrustManagementAlgorithm(String trustManagementAlgorithm) {
        this.trustManagementAlgorithm = trustManagementAlgorithm;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getTrustStoreCRLsLocation() {
        return this.trustStoreCRLsLocation;
    }

    public void setTrustStoreCRLsLocation(String trustStoreCRLsLocation) {
        this.trustStoreCRLsLocation = trustStoreCRLsLocation;
    }

    public CertStore getTrustStoreCRLs() {
        return this.trustStoreCRLs;
    }

    public void setTrustStoreCRLs(CertStore trustStoreCRLs) {
        this.trustStoreCRLs = trustStoreCRLs;
    }

    public String getTrustStoreOCSPPolicy() {
        return this.trustStoreOCSPPolicy;
    }

    public void setTrustStoreOCSPPolicy(String trustStoreOCSPPolicy) {
        this.trustStoreOCSPPolicy = trustStoreOCSPPolicy;
    }

    public String getKeyStoreLocation() {
        return this.keyStoreLocation;
    }

    public void setKeyStoreLocation(String keyStoreLocation) {
        this.keyStoreLocation = keyStoreLocation;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getKeyManagementAlgorithm() {
        return this.keyManagementAlgorithm;
    }

    public void setKeyManagementAlgorithm(String keyManagementAlgorithm) {
        this.keyManagementAlgorithm = keyManagementAlgorithm;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStoreBYOKPolicy() {
        return this.keyStoreBYOKPolicy;
    }

    public void setKeyStoreBYOKPolicy(String keyStoreBYOKPolicy) {
        this.keyStoreBYOKPolicy = keyStoreBYOKPolicy;
    }

    public boolean isHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(boolean hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public String getClassNameHostnameVerifier() {
        return this.classNameHostnameVerifier;
    }

    public void setClassNameHostnameVerifier(String classNameHostnameVerifier) {
        this.classNameHostnameVerifier = classNameHostnameVerifier;
    }

    public String getSslType() {
        return this.sslType;
    }

    public void setSslType(String sslType) {
        this.sslType = sslType;
    }

    public boolean isSecureRandom() {
        return this.secureRandom;
    }

    public void setSecureRandom(boolean secureRandom) {
        this.secureRandom = secureRandom;
        this.secureRandomSet = true;
    }

    public boolean isSecureRandomSet() {
        return this.secureRandomSet;
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    public void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
    }

    public StringBuilder getSbError() {
        return this.sbError;
    }

    public void setSbError(StringBuilder sbError) {
        this.sbError = sbError;
    }

    public StringBuilder getSbDebug() {
        return this.sbDebug;
    }

    public void setSbDebug(StringBuilder sbDebug) {
        this.sbDebug = sbDebug;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerBuffer getLoggerBuffer() {
        LoggerBuffer lb = new LoggerBuffer();
        lb.setSbDebug(this.sbDebug);
        lb.setSbError(this.sbError);
        lb.setLogErrorInDebug(true);
        return lb;
    }

    public LoggerBuffer getLog4jBuffer() {
        LoggerBuffer lb = new LoggerBuffer();
        lb.setLogError(this.logger);
        if (this.sbDebug != null) {
            lb.setLogDebug(this.logger);
        }
        return lb;
    }

    public Map<String, Object> getDynamicMap() {
        return this.dynamicMap;
    }

    public void setDynamicMap(Map<String, Object> dynamicMap) {
        this.dynamicMap = dynamicMap;
    }
}

