/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.wadl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jvnet.ws.wadl.ast.ApplicationNode;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.XMLException;
import org.openspcoop2.utils.xml.XSDSchemaCollection;
import org.openspcoop2.utils.xml.XSDUtils;
import org.slf4j.Logger;

public class ApplicationWrapper {
    private ApplicationNode applicationNode;
    private Map<String, byte[]> resources = new HashMap<String, byte[]>();
    private Map<String, List<String>> mappingNamespaceLocations = new HashMap<String, List<String>>();
    private AbstractXMLUtils xmlUtils = null;
    private XSDUtils xsdUtils = null;

    public ApplicationWrapper(ApplicationNode applicationNode, Map<String, byte[]> resources, Map<String, List<String>> mappingNamespaceLocations, AbstractXMLUtils xmlUtils) {
        this.applicationNode = applicationNode;
        this.resources = resources;
        this.mappingNamespaceLocations = mappingNamespaceLocations;
        this.xmlUtils = xmlUtils;
        this.xsdUtils = new XSDUtils(this.xmlUtils);
    }

    public ApplicationNode getApplicationNode() {
        return this.applicationNode;
    }

    public Map<String, byte[]> getResources() {
        return this.resources;
    }

    public Map<String, List<String>> getMappingNamespaceLocations() {
        return this.mappingNamespaceLocations;
    }

    public void addResource(String systemId, byte[] resource) throws XMLException {
        if (!this.resources.containsKey(systemId)) {
            this.resources.put(systemId, resource);
            this.xsdUtils.registraMappingNamespaceLocations(resource, systemId, this.mappingNamespaceLocations);
        }
    }

    public XSDSchemaCollection buildSchemaCollection(Logger log) throws XMLException {
        return this.xsdUtils.buildSchemaCollection(this.resources, this.mappingNamespaceLocations, log);
    }
}

