/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.wadl.test;

import java.net.URI;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.jvnet.ws.wadl.Doc;
import org.jvnet.ws.wadl.Param;
import org.jvnet.ws.wadl.ast.ApplicationNode;
import org.jvnet.ws.wadl.ast.FaultNode;
import org.jvnet.ws.wadl.ast.MethodNode;
import org.jvnet.ws.wadl.ast.PathSegment;
import org.jvnet.ws.wadl.ast.RepresentationNode;
import org.jvnet.ws.wadl.ast.ResourceNode;
import org.jvnet.ws.wadl.ast.WadlAstBuilder;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.rest.ApiFactory;
import org.openspcoop2.utils.rest.ApiFormats;
import org.openspcoop2.utils.rest.ApiReaderConfig;
import org.openspcoop2.utils.rest.IApiReader;
import org.openspcoop2.utils.rest.api.Api;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.wadl.MessageListener;
import org.openspcoop2.utils.wadl.SchemaCallback;
import org.openspcoop2.utils.xml.XMLUtils;

public class WadlTest {
    public static void main(String[] args) throws Exception {
        WadlTest.test();
    }

    public static void test() throws Exception {
        XMLUtils xmlUtils = XMLUtils.getInstance();
        SchemaCallback callback = new SchemaCallback(null, xmlUtils, true, true);
        callback.addResource("test2.xsd", Utilities.getAsByteArray(WadlTest.class.getResourceAsStream("/org/openspcoop2/utils/wadl/test/test2.xsd")));
        MessageListener mListener = new MessageListener(null);
        WadlAstBuilder astBuilder = new WadlAstBuilder((WadlAstBuilder.SchemaCallback)callback, (org.jvnet.ws.wadl.util.MessageListener)mListener);
        URI uri = WadlTest.class.getResource("/org/openspcoop2/utils/wadl/test/test.wadl").toURI();
        ApplicationNode an = astBuilder.buildAst(uri);
        List rs = an.getResources();
        System.out.println("RESOURCE NODE: " + rs.size());
        for (ResourceNode resourceNode : rs) {
            WadlTest.print(resourceNode, "");
        }
        System.out.println("Schemi Letti: " + callback.getResources().size());
        for (String key : callback.getResources().keySet()) {
            System.out.println("Schema [" + key + "]");
        }
        System.out.println("Namespaces:");
        for (String namespace : callback.getMappingNamespaceLocations().keySet()) {
            String key = String.join((CharSequence)", ", (Iterable<? extends CharSequence>)callback.getMappingNamespaceLocations().get(namespace));
            System.out.println("Schema [" + key + "]: " + namespace);
        }
        IApiReader apiReader = ApiFactory.newApiReader(ApiFormats.WADL);
        apiReader.init(LoggerWrapperFactory.getLogger(WadlTest.class), uri, new ApiReaderConfig());
        Api api = apiReader.read();
        System.out.println("API: " + api);
        System.out.println("Validazione ... ");
        api.validate(false);
        System.out.println("Validazione effettuata con successo");
        String test = "http://localhost:8080/smartproxy/ws/rest/allineamentopendenze/id23/ulterioreParametro/id45";
        System.out.println("API-Op [" + test + "]: " + api.findOperation(HttpRequestMethod.GET, test));
        String testSenzaBaseUri = "/allineamentopendenze/id23/ulterioreParametro/id45";
        System.out.println("API-Op [" + testSenzaBaseUri + "]: " + api.findOperation(HttpRequestMethod.GET, testSenzaBaseUri));
        String testParametroDinamico = "/allineamentopendenze/id23";
        System.out.println("API-Op [" + testParametroDinamico + "]: " + api.findOperation(HttpRequestMethod.GET, testParametroDinamico));
        String testParametriRisposta = "/prova2";
        System.out.println("API-Op [" + testParametriRisposta + "]: " + api.findOperation(HttpRequestMethod.GET, testParametriRisposta));
    }

    private static void print(ResourceNode resourceNode, String indent) {
        System.out.println(indent + "========================== INIZIO [" + resourceNode.getUriTemplate() + "]============================");
        System.out.println(indent + "RESOURCE NODE getAllResourceUriTemplate [" + resourceNode.getAllResourceUriTemplate() + "]");
        System.out.println(indent + "RESOURCE NODE getUriTemplate [" + resourceNode.getUriTemplate() + "]");
        System.out.println(indent + "RESOURCE NODE DOC size [" + resourceNode.getDoc().size() + "]");
        System.out.println(indent + "RESOURCE NODE Header Params size [" + resourceNode.getHeaderParams().size() + "]");
        System.out.println(indent + "RESOURCE NODE Matrix Params size [" + resourceNode.getMatrixParams().size() + "]");
        System.out.println(indent + "RESOURCE NODE Methods size [" + resourceNode.getMethods().size() + "]");
        WadlTest.printMethod(resourceNode.getMethods(), indent);
        System.out.println(indent + "RESOURCE Parent Resource [" + resourceNode.getParentResource() + "]");
        try {
            System.out.println(indent + "RESOURCE Location [" + resourceNode.getLocation() + "]");
        }
        catch (Exception e) {
            System.out.println(indent + "RESOURCE Location [" + e.getMessage() + "]");
        }
        System.out.println(indent + "RESOURCE PathSegment [" + resourceNode.getPathSegment() + "]");
        System.out.println(indent + "RESOURCE PathSegment size [" + resourceNode.getPathSegments().size() + "]");
        WadlTest.printPathSegment(resourceNode.getPathSegments(), indent);
        System.out.println(indent + "RESOURCE QueryParams size [" + resourceNode.getQueryParams().size() + "]");
        WadlTest.printParams(resourceNode.getQueryParams(), indent);
        System.out.println(indent + "RESOURCE ResourceTypes size [" + resourceNode.getResourceTypes().size() + "]");
        System.out.println(indent + "RESOURCE NODE getChildResources.size [" + resourceNode.getChildResources().size() + "]");
        for (ResourceNode child : resourceNode.getChildResources()) {
            WadlTest.print(child, indent + "\t");
        }
        System.out.println(indent + "========================== FINE [" + resourceNode.getUriTemplate() + "]============================");
    }

    private static void printParams(List<Param> list, String indent) {
        for (Param param : list) {
            System.out.println(indent + "  PARAM NAME[" + param.getName() + "]");
            System.out.println(indent + "    default [" + param.getDefault() + "]");
            System.out.println(indent + "    fixed [" + param.getFixed() + "]");
            System.out.println(indent + "    href [" + param.getHref() + "]");
            System.out.println(indent + "    id [" + param.getId() + "]");
            System.out.println(indent + "    path [" + param.getPath() + "]");
            System.out.println(indent + "    any.size [" + param.getAny().size() + "]");
            System.out.println(indent + "    doc.size [" + param.getDoc().size() + "]");
            WadlTest.printDoc(param.getDoc(), indent + "    ");
            System.out.println(indent + "    link [" + param.getLink() + "]");
            System.out.println(indent + "    option.size [" + param.getOption().size() + "]");
            System.out.println(indent + "    otherAttributes.size [" + param.getOtherAttributes().size() + "]");
            System.out.println(indent + "    style [" + param.getStyle().name() + "]");
            System.out.println(indent + "    type [" + param.getType() + "]");
        }
    }

    private static void printMethod(List<MethodNode> list, String indent) {
        for (MethodNode param : list) {
            System.out.println(indent + "  METHOD NAME[" + param.getName() + "]");
            System.out.println(indent + "    id [" + param.getId() + "]");
            System.out.println(indent + "    getQueryParameters.size [" + param.getQueryParameters().size() + "]");
            WadlTest.printParams(param.getQueryParameters(), indent + "    ");
            System.out.println(indent + "    getOptionalParameters.size [" + param.getOptionalParameters().size() + "]");
            WadlTest.printParams(param.getOptionalParameters(), indent + "    ");
            System.out.println(indent + "    getMatrixParameters.size [" + param.getMatrixParameters().size() + "]");
            WadlTest.printParams(param.getMatrixParameters(), indent + "    ");
            System.out.println(indent + "    getHeaderParameters.size [" + param.getHeaderParameters().size() + "]");
            WadlTest.printParams(param.getHeaderParameters(), indent + "    ");
            System.out.println(indent + "    getSupportedInputs.size [" + param.getSupportedInputs().size() + "]");
            for (RepresentationNode representationNode : param.getSupportedInputs()) {
                System.out.println(indent + "       mediaType [" + representationNode.getMediaType() + "]");
                System.out.println(indent + "       element [" + representationNode.getElement() + "]");
                if (representationNode.getParam() == null) continue;
                System.out.println(indent + "    inputParams.size [" + representationNode.getParam().size() + "]");
                WadlTest.printParams(representationNode.getParam(), indent + "    ");
            }
            System.out.println(indent + "    getSupportedOutputs.size [" + param.getSupportedOutputs().size() + "]");
            MultivaluedMap mapOutput = param.getSupportedOutputs();
            for (List listLong : mapOutput.keySet()) {
                List representationNode = (List)mapOutput.get((Object)listLong);
                for (int i = 0; i < listLong.size(); ++i) {
                    System.out.println(indent + "       status [" + listLong.get(i) + "]");
                    System.out.println(indent + "         mediaType [" + ((RepresentationNode)representationNode.get(i)).getMediaType() + "]");
                    System.out.println(indent + "         element [" + ((RepresentationNode)representationNode.get(i)).getElement() + "]");
                    if (((RepresentationNode)representationNode.get(i)).getParam() == null) continue;
                    System.out.println(indent + "    outputParams.size [" + ((RepresentationNode)representationNode.get(i)).getParam().size() + "]");
                    WadlTest.printParams(((RepresentationNode)representationNode.get(i)).getParam(), indent + "    ");
                }
            }
            System.out.println(indent + "    getFaults.size [" + param.getFaults().size() + "]");
            MultivaluedMap mapFault = param.getFaults();
            for (List listLong : mapFault.keySet()) {
                List faultNode = (List)mapFault.get((Object)listLong);
                for (int i = 0; i < listLong.size(); ++i) {
                    System.out.println(indent + "       status [" + listLong.get(i) + "]");
                    System.out.println(indent + "         mediaType [" + ((FaultNode)faultNode.get(i)).getMediaType() + "]");
                    System.out.println(indent + "         element [" + ((FaultNode)faultNode.get(i)).getElement() + "]");
                    if (((FaultNode)faultNode.get(i)).getParam() == null) continue;
                    System.out.println(indent + "    faultParams.size [" + ((FaultNode)faultNode.get(i)).getParam().size() + "]");
                    WadlTest.printParams(((FaultNode)faultNode.get(i)).getParam(), indent + "    ");
                }
            }
        }
    }

    private static void printDoc(List<Doc> list, String indent) {
        for (Doc doc : list) {
            System.out.println(indent + "  DOC TITLE[" + doc.getTitle() + "]");
            System.out.println(indent + "    lang [" + doc.getLang() + "]");
            System.out.println(indent + "    content.size [" + doc.getContent().size() + "]");
            System.out.println(indent + "    otherAttributes.size [" + doc.getOtherAttributes().size() + "]");
        }
    }

    private static void printPathSegment(List<PathSegment> list, String indent) {
        for (PathSegment pathSegment : list) {
            System.out.println(indent + "  PATH SEGMENT [" + pathSegment.getTemplate() + "]");
            System.out.println(indent + "    headerParameters.size() [" + pathSegment.getHeaderParameters().size() + "]");
            System.out.println(indent + "    matrixParameters.size() [" + pathSegment.getMatrixParameters().size() + "]");
            System.out.println(indent + "    queryParameters.size() [" + pathSegment.getQueryParameters().size() + "]");
            System.out.println(indent + "    templateParameters.size() [" + pathSegment.getTemplateParameters().size() + "]");
        }
    }
}

