/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.wadl.validator;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import org.jvnet.ws.wadl.ast.AbstractNode;
import org.jvnet.ws.wadl.ast.FaultNode;
import org.jvnet.ws.wadl.ast.MethodNode;
import org.jvnet.ws.wadl.ast.RepresentationNode;
import org.jvnet.ws.wadl.ast.ResourceNode;
import org.openspcoop2.utils.rest.AbstractApiValidator;
import org.openspcoop2.utils.rest.ApiParameterType;
import org.openspcoop2.utils.rest.ApiValidatorConfig;
import org.openspcoop2.utils.rest.IApiValidator;
import org.openspcoop2.utils.rest.ProcessingException;
import org.openspcoop2.utils.rest.ValidatorException;
import org.openspcoop2.utils.rest.api.Api;
import org.openspcoop2.utils.rest.api.ApiOperation;
import org.openspcoop2.utils.rest.api.ApiSchemaTypeRestriction;
import org.openspcoop2.utils.rest.entity.HttpBaseEntity;
import org.openspcoop2.utils.rest.entity.HttpBaseRequestEntity;
import org.openspcoop2.utils.rest.entity.HttpBaseResponseEntity;
import org.openspcoop2.utils.wadl.ApplicationWrapper;
import org.openspcoop2.utils.wadl.WADLApi;
import org.openspcoop2.utils.wadl.WADLException;
import org.openspcoop2.utils.wadl.WADLUtilities;
import org.openspcoop2.utils.wadl.validator.WADLValidatorException;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.ValidatoreXSD;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Validator
extends AbstractApiValidator
implements IApiValidator {
    private WADLApi wadlApi;
    private ApplicationWrapper application;
    private Logger log;
    private AbstractXMLUtils xmlUtils;
    private Schema schema;
    private boolean initialize = false;

    @Override
    public void init(Logger log, Api api, ApiValidatorConfig config) throws WADLException {
        try {
            this.wadlApi = (WADLApi)api;
            this.log = log;
            this.application = this.wadlApi.getApplicationWadlWrapper();
            this.xmlUtils = config.getXmlUtils();
            if (this.application.getResources().size() > 0) {
                this.schema = this.application.buildSchemaCollection(this.log).buildSchema(this.log);
            }
            this.initialize = true;
        }
        catch (Exception e) {
            throw new WADLException(e.getMessage(), e);
        }
    }

    @Override
    public void close(Logger log, Api api, ApiValidatorConfig config) throws ProcessingException {
    }

    @Override
    public void validate(HttpBaseEntity<?> httpEntity) throws ProcessingException, ValidatorException {
        if (!this.initialize) {
            throw new WADLException("Validatore non inizializzato");
        }
        ArrayList context = new ArrayList();
        this.validate(this.wadlApi, httpEntity, context);
    }

    @Override
    public void validatePreConformanceCheck(HttpBaseEntity<?> httpEntity, ApiOperation operation, Object ... args) throws ProcessingException, ValidatorException {
        ResourceNode resourceNode = WADLUtilities.findResourceNode(this.application.getApplicationNode(), httpEntity.getUrl());
        MethodNode methodNode = WADLUtilities.findMethodNode(resourceNode, httpEntity.getMethod());
        ((List)args[0]).add(resourceNode);
        ((List)args[0]).add(methodNode);
        this.validateAgainstXSDSchema(httpEntity, resourceNode, methodNode);
    }

    @Override
    public void validatePostConformanceCheck(HttpBaseEntity<?> httpEntity, ApiOperation operation, Object ... args) throws ProcessingException, ValidatorException {
        ResourceNode resourceNode = (ResourceNode)((List)args[0]).get(0);
        MethodNode methodNode = (MethodNode)((List)args[0]).get(1);
        this.wadlConformanceCheck(httpEntity, resourceNode, methodNode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void validateValueAsType(ApiParameterType parameterType, String value, String type, ApiSchemaTypeRestriction typeRestriction) throws ProcessingException, ValidatorException {
        String tipoEffettivo;
        if (!type.startsWith("{http://www.w3.org/2001/XMLSchema}") || (tipoEffettivo = type.substring("{http://www.w3.org/2001/XMLSchema}".length())) == null) return;
        if ("byte".equalsIgnoreCase(tipoEffettivo = tipoEffettivo.trim()) || "unsignedByte".equalsIgnoreCase(tipoEffettivo)) {
            try {
                Byte.parseByte(value);
                return;
            }
            catch (Exception e) {
                throw new ValidatorException(e.getMessage(), e);
            }
        }
        if ("char".equalsIgnoreCase(tipoEffettivo)) {
            if (value.length() <= 1) return;
            throw new ValidatorException("More than one character");
        }
        if ("double".equalsIgnoreCase(tipoEffettivo) || "decimal".equalsIgnoreCase(tipoEffettivo)) {
            try {
                Double.parseDouble(value);
                return;
            }
            catch (Exception e) {
                throw new ValidatorException(e.getMessage(), e);
            }
        }
        if ("float".equalsIgnoreCase(tipoEffettivo)) {
            try {
                Float.parseFloat(value);
                return;
            }
            catch (Exception e) {
                throw new ValidatorException(e.getMessage(), e);
            }
        }
        if ("int".equalsIgnoreCase(tipoEffettivo) || "integer".equalsIgnoreCase(tipoEffettivo) || "positiveInteger".equalsIgnoreCase(tipoEffettivo) || "negativeInteger".equalsIgnoreCase(tipoEffettivo) || "nonPositiveInteger".equalsIgnoreCase(tipoEffettivo) || "nonNegativeInteger".equalsIgnoreCase(tipoEffettivo) || "unsignedInt".equalsIgnoreCase(tipoEffettivo)) {
            try {
                int i = Integer.parseInt(value);
                if ("positiveInteger".equalsIgnoreCase(tipoEffettivo)) {
                    if (i > 0) return;
                    throw new ValidatorException("Expected a positive value");
                }
                if ("nonNegativeInteger".equalsIgnoreCase(tipoEffettivo)) {
                    if (i >= 0) return;
                    throw new ValidatorException("Expected a non negative value");
                }
                if ("negativeInteger".equalsIgnoreCase(tipoEffettivo)) {
                    if (i < 0) return;
                    throw new ValidatorException("Expected a negative value");
                }
                if ("nonPositiveInteger".equalsIgnoreCase(tipoEffettivo)) {
                    if (i <= 0) return;
                    throw new ValidatorException("Expected a non positive value");
                }
                if (!"unsignedInt".equalsIgnoreCase(tipoEffettivo) || i >= 0) return;
                throw new ValidatorException("Expected a unsigned value");
            }
            catch (Exception e) {
                throw new ValidatorException(e.getMessage(), e);
            }
        }
        if ("long".equalsIgnoreCase(tipoEffettivo) || "unsignedLong".equalsIgnoreCase(tipoEffettivo)) {
            try {
                long l = Long.parseLong(value);
                if (!"unsignedLong".equalsIgnoreCase(tipoEffettivo) || l >= 0L) return;
                throw new ValidatorException("Expected a unsigned value");
            }
            catch (Exception e) {
                throw new ValidatorException(e.getMessage(), e);
            }
        }
        if ("short".equalsIgnoreCase(tipoEffettivo) || "unsignedShort".equalsIgnoreCase(tipoEffettivo)) {
            try {
                short s = Short.parseShort(value);
                if (!"unsignedShort".equalsIgnoreCase(tipoEffettivo) || s >= 0) return;
                throw new ValidatorException("Expected a unsigned value");
            }
            catch (Exception e) {
                throw new ValidatorException(e.getMessage(), e);
            }
        }
        if ("boolean".equalsIgnoreCase(tipoEffettivo)) {
            try {
                Boolean.parseBoolean(value);
                return;
            }
            catch (Exception e) {
                throw new ValidatorException(e.getMessage(), e);
            }
        }
        if (!"anyURI".equalsIgnoreCase(tipoEffettivo)) return;
        try {
            new URI(value);
            return;
        }
        catch (Exception e) {
            throw new ValidatorException(e.getMessage(), e);
        }
    }

    private void validateAgainstXSDSchema(HttpBaseEntity<?> httpEntity, ResourceNode resourceNode, MethodNode methodNode) throws WADLException, WADLValidatorException {
        block15: {
            if (this.schema != null) {
                try {
                    ValidatoreXSD validatore = null;
                    try {
                        validatore = new ValidatoreXSD(this.schema);
                    }
                    catch (Exception e) {
                        throw new WADLException("Riscontrato errore durante la costruzione del validatore XSD per il contenuto applicativo: " + e.getMessage(), e);
                    }
                    QName elementAtteso = null;
                    AbstractNode nodeXML = this.getNode(httpEntity, methodNode);
                    if (nodeXML != null) {
                        if (nodeXML instanceof RepresentationNode) {
                            elementAtteso = ((RepresentationNode)nodeXML).getElement();
                        } else if (nodeXML instanceof FaultNode) {
                            elementAtteso = ((FaultNode)nodeXML).getElement();
                        }
                    }
                    if (elementAtteso == null) break block15;
                    Node node = this.readNode(elementAtteso, httpEntity);
                    String nomeElemento = null;
                    try {
                        nomeElemento = node.getLocalName();
                        validatore.valida(node, true);
                    }
                    catch (Exception e) {
                        StringBuilder errorMsgValidazioneXSD = new StringBuilder();
                        errorMsgValidazioneXSD.append("validation failed");
                        errorMsgValidazioneXSD.append(" (element " + nomeElemento + "): " + e.getMessage());
                        String elementNonValidato = null;
                        try {
                            elementNonValidato = this.xmlUtils.toString(node);
                        }
                        catch (Exception eString) {
                            this.log.error("Errore durante la conversione del Node in String: " + eString.getMessage(), (Throwable)eString);
                        }
                        this.log.error("Validazione fallita (elemento " + nomeElemento + ") [" + elementNonValidato + "]: " + e.getMessage(), (Throwable)e);
                        throw new WADLValidatorException(errorMsgValidazioneXSD.toString(), e);
                    }
                }
                catch (WADLException e) {
                    throw e;
                }
                catch (WADLValidatorException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WADLException(e.getMessage(), e);
                }
            }
        }
    }

    private AbstractNode getNode(HttpBaseEntity<?> httpEntity, MethodNode methodNode) throws WADLException, WADLValidatorException {
        block9: {
            block8: {
                if (!(httpEntity instanceof HttpBaseRequestEntity)) break block8;
                if (methodNode.getSupportedInputs() == null) break block9;
                for (RepresentationNode input : methodNode.getSupportedInputs()) {
                    if (!input.getMediaType().equals("application/xml") && !input.getMediaType().equals("text/xml")) continue;
                    return input;
                }
                break block9;
            }
            if (httpEntity instanceof HttpBaseResponseEntity) {
                List<FaultNode> lstFaults;
                int status = ((HttpBaseResponseEntity)httpEntity).getStatus();
                List lstOutputs = this.getSupportedOutputs((MultivaluedMap<List<Long>, RepresentationNode>)methodNode.getSupportedOutputs(), status);
                if (lstOutputs != null) {
                    for (RepresentationNode output : lstOutputs) {
                        if (!output.getMediaType().equals("application/xml") && !output.getMediaType().equals("text/xml")) continue;
                        return output;
                    }
                }
                if ((lstFaults = this.getSupportedFaults((MultivaluedMap<List<Long>, FaultNode>)methodNode.getFaults(), status)) != null) {
                    for (FaultNode fault : lstFaults) {
                        if (!fault.getMediaType().equals("application/xml") && !fault.getMediaType().equals("text/xml")) continue;
                        return fault;
                    }
                }
                if ((lstOutputs = (List)methodNode.getSupportedOutputs().get(new ArrayList())) != null) {
                    for (RepresentationNode output : lstOutputs) {
                        if (!output.getMediaType().equals("application/xml") && !output.getMediaType().equals("text/xml")) continue;
                        return output;
                    }
                }
            }
        }
        return null;
    }

    private List<RepresentationNode> getSupportedOutputs(MultivaluedMap<List<Long>, RepresentationNode> outputs, int status) {
        for (List lst : outputs.keySet()) {
            for (Long longValue : lst) {
                if (longValue.intValue() != status) continue;
                return (List)outputs.get((Object)lst);
            }
        }
        return null;
    }

    private List<FaultNode> getSupportedFaults(MultivaluedMap<List<Long>, FaultNode> faults, int status) {
        for (List lst : faults.keySet()) {
            for (Long longValue : lst) {
                if (longValue.intValue() != status) continue;
                return (List)faults.get((Object)lst);
            }
        }
        return null;
    }

    private void wadlConformanceCheck(HttpBaseEntity<?> httpEntity, ResourceNode resourceNode, MethodNode methodNode) throws WADLException, WADLValidatorException {
        try {
            QName elementAtteso = null;
            AbstractNode nodeXML = this.getNode(httpEntity, methodNode);
            if (nodeXML != null) {
                if (nodeXML instanceof RepresentationNode) {
                    RepresentationNode representationNode = (RepresentationNode)nodeXML;
                    elementAtteso = representationNode.getElement();
                } else if (nodeXML instanceof FaultNode) {
                    FaultNode faultNode = (FaultNode)nodeXML;
                    elementAtteso = faultNode.getElement();
                }
            }
            if (elementAtteso != null) {
                Node node = this.readNode(elementAtteso, httpEntity);
                if (node.getLocalName() == null) {
                    throw new WADLValidatorException("Verifica presenza element [" + elementAtteso + "] fallita. Element presente nel payload http non contiene un local-name?");
                }
                if (node.getNamespaceURI() == null) {
                    throw new WADLValidatorException("Verifica presenza element [" + elementAtteso + "] fallita. Element presente nel payload http non contiene un namespace?");
                }
                if (!node.getLocalName().equals(elementAtteso.getLocalPart())) {
                    throw new WADLValidatorException("Verifica presenza element [" + elementAtteso + "] fallita. Element presente nel payload http contiene un local-name [" + node.getLocalName() + "] differente da quello atteso [" + elementAtteso.getLocalPart() + "]");
                }
                if (!node.getNamespaceURI().equals(elementAtteso.getNamespaceURI())) {
                    throw new WADLValidatorException("Verifica presenza element [" + elementAtteso + "] fallita. Element presente nel payload http contiene un namespace [" + node.getNamespaceURI() + "] differente da quello atteso [" + elementAtteso.getNamespaceURI() + "]");
                }
            }
        }
        catch (WADLException e) {
            throw e;
        }
        catch (WADLValidatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WADLException(e.getMessage(), e);
        }
    }

    private Node readNode(QName elementAtteso, HttpBaseEntity<?> httpEntity) throws WADLValidatorException, WADLException {
        Node node = null;
        try {
            if (httpEntity.getContent() == null) {
                throw new WADLValidatorException("Verifica presenza element [" + elementAtteso + "] fallita. Non \u00e8 stato riscontrato alcun dato nel payload http");
            }
            Object content = httpEntity.getContent();
            if (content instanceof Element) {
                node = (Element)content;
            } else if (content instanceof Document) {
                node = ((Document)content).getDocumentElement();
            } else if (content instanceof byte[]) {
                byte[] bytes = (byte[])content;
                node = this.xmlUtils.newDocument(bytes);
            } else if (content instanceof String) {
                byte[] bytes = ((String)content).getBytes();
                node = this.xmlUtils.newDocument(bytes);
            } else if (content instanceof InputStream) {
                InputStream is = (InputStream)content;
                node = this.xmlUtils.newDocument(is);
            } else {
                throw new WADLException("HttpBaseEntity [" + httpEntity.getClass().getName() + "] non gestita");
            }
            return node;
        }
        catch (WADLException e) {
            throw e;
        }
        catch (WADLValidatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WADLValidatorException("Verifica presenza element [" + elementAtteso + "] fallita. Non \u00e8 stato riscontrato nel payload http dei dati che contengano una struttura xml valida, " + e.getMessage(), e);
        }
    }
}

