/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.DOMSourceFix;
import org.openspcoop2.utils.xml.XMLException;
import org.slf4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;

public abstract class AbstractValidatoreXSD {
    private Schema schema;
    private static final String FACTORY_DEFAULT = "FactoryDefault";

    public Schema getSchema() {
        return this.schema;
    }

    public AbstractValidatoreXSD(Schema schema) throws Exception {
        try {
            if (schema == null) {
                throw new Exception("Schema is null?");
            }
            this.schema = schema;
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (InputStream): " + e.getMessage(), e);
        }
    }

    public AbstractValidatoreXSD(Logger log, InputStream inputStream) throws Exception {
        this(log, FACTORY_DEFAULT, inputStream);
    }

    public AbstractValidatoreXSD(Logger log, String schemaFactory, InputStream inputStream) throws Exception {
        try {
            StreamSource streamSource = new StreamSource(inputStream);
            this.initializeSchema(log, schemaFactory, null, streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (InputStream): " + e.getMessage(), e);
        }
    }

    public AbstractValidatoreXSD(Logger log, LSResourceResolver lsResourceResolver, InputStream inputStream) throws Exception {
        this(log, FACTORY_DEFAULT, lsResourceResolver, inputStream);
    }

    public AbstractValidatoreXSD(Logger log, String schemaFactory, LSResourceResolver lsResourceResolver, InputStream inputStream) throws Exception {
        try {
            StreamSource streamSource = new StreamSource(inputStream);
            this.initializeSchema(log, schemaFactory, lsResourceResolver, streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (InputStream): " + e.getMessage(), e);
        }
    }

    public AbstractValidatoreXSD(Logger log, InputStream ... inputStream) throws Exception {
        this(log, FACTORY_DEFAULT, inputStream);
    }

    public AbstractValidatoreXSD(Logger log, String schemaFactory, InputStream ... inputStream) throws Exception {
        try {
            Source[] ss = new StreamSource[inputStream.length];
            for (int i = 0; i < inputStream.length; ++i) {
                ss[i] = new StreamSource(inputStream[i]);
            }
            this.initializeSchema(log, schemaFactory, null, ss);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (InputStream): " + e.getMessage(), e);
        }
    }

    public AbstractValidatoreXSD(Logger log, LSResourceResolver lsResourceResolver, InputStream ... inputStream) throws Exception {
        this(log, FACTORY_DEFAULT, lsResourceResolver, inputStream);
    }

    public AbstractValidatoreXSD(Logger log, String schemaFactory, LSResourceResolver lsResourceResolver, InputStream ... inputStream) throws Exception {
        try {
            Source[] ss = new StreamSource[inputStream.length];
            for (int i = 0; i < inputStream.length; ++i) {
                ss[i] = new StreamSource(inputStream[i]);
            }
            this.initializeSchema(log, schemaFactory, lsResourceResolver, ss);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (InputStream): " + e.getMessage(), e);
        }
    }

    public AbstractValidatoreXSD(Logger log, File file) throws Exception {
        this(log, FACTORY_DEFAULT, file);
    }

    public AbstractValidatoreXSD(Logger log, String schemaFactory, File file) throws Exception {
        try {
            StreamSource streamSource = new StreamSource(file);
            this.initializeSchema(log, schemaFactory, null, streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (File:" + file.getName() + "): " + e.getMessage(), e);
        }
    }

    public AbstractValidatoreXSD(Logger log, LSResourceResolver lsResourceResolver, File file) throws Exception {
        this(log, FACTORY_DEFAULT, lsResourceResolver, file);
    }

    public AbstractValidatoreXSD(Logger log, String schemaFactory, LSResourceResolver lsResourceResolver, File file) throws Exception {
        try {
            StreamSource streamSource = new StreamSource(file);
            this.initializeSchema(log, schemaFactory, lsResourceResolver, streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (File:" + file.getName() + "): " + e.getMessage(), e);
        }
    }

    public AbstractValidatoreXSD(Logger log, File ... file) throws Exception {
        this(log, FACTORY_DEFAULT, file);
    }

    public AbstractValidatoreXSD(Logger log, String schemaFactory, File ... file) throws Exception {
        try {
            Source[] ss = new StreamSource[file.length];
            for (int i = 0; i < file.length; ++i) {
                ss[i] = new StreamSource(file[i]);
            }
            this.initializeSchema(log, schemaFactory, null, ss);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (Files): " + e.getMessage(), e);
        }
    }

    public AbstractValidatoreXSD(Logger log, LSResourceResolver lsResourceResolver, File ... file) throws Exception {
        this(log, FACTORY_DEFAULT, lsResourceResolver, file);
    }

    public AbstractValidatoreXSD(Logger log, String schemaFactory, LSResourceResolver lsResourceResolver, File ... file) throws Exception {
        try {
            Source[] ss = new StreamSource[file.length];
            for (int i = 0; i < file.length; ++i) {
                ss[i] = new StreamSource(file[i]);
            }
            this.initializeSchema(log, schemaFactory, lsResourceResolver, ss);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (Files): " + e.getMessage(), e);
        }
    }

    public AbstractValidatoreXSD(Logger log, String url) throws Exception {
        this(log, FACTORY_DEFAULT, url);
    }

    public AbstractValidatoreXSD(Logger log, String schemaFactory, String url) throws Exception {
        try {
            StreamSource streamSource = new StreamSource(url);
            this.initializeSchema(log, schemaFactory, null, streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (URL:" + url + "): " + e.getMessage(), e);
        }
    }

    public AbstractValidatoreXSD(Logger log, LSResourceResolver lsResourceResolver, String url) throws Exception {
        this(log, FACTORY_DEFAULT, lsResourceResolver, url);
    }

    public AbstractValidatoreXSD(Logger log, String schemaFactory, LSResourceResolver lsResourceResolver, String url) throws Exception {
        try {
            StreamSource streamSource = new StreamSource(url);
            this.initializeSchema(log, schemaFactory, lsResourceResolver, streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (URL:" + url + "): " + e.getMessage(), e);
        }
    }

    public AbstractValidatoreXSD(Logger log, String ... url) throws Exception {
        this(log, FACTORY_DEFAULT, url);
    }

    public AbstractValidatoreXSD(Logger log, String schemaFactory, String ... url) throws Exception {
        try {
            Source[] ss = new StreamSource[url.length];
            for (int i = 0; i < url.length; ++i) {
                ss[i] = new StreamSource(url[i]);
            }
            this.initializeSchema(log, schemaFactory, null, ss);
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            if (url != null) {
                for (String u : url) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(u);
                }
            }
            throw new Exception("Riscontrato errore durante la costruzione dello schema (URL:" + sb.toString() + "): " + e.getMessage(), e);
        }
    }

    public AbstractValidatoreXSD(Logger log, LSResourceResolver lsResourceResolver, String ... url) throws Exception {
        this(log, FACTORY_DEFAULT, lsResourceResolver, url);
    }

    public AbstractValidatoreXSD(Logger log, String schemaFactory, LSResourceResolver lsResourceResolver, String ... url) throws Exception {
        try {
            Source[] ss = new StreamSource[url.length];
            for (int i = 0; i < url.length; ++i) {
                ss[i] = new StreamSource(url[i]);
            }
            this.initializeSchema(log, schemaFactory, lsResourceResolver, ss);
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            if (url != null) {
                for (String u : url) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(u);
                }
            }
            throw new Exception("Riscontrato errore durante la costruzione dello schema (URL:" + sb.toString() + "): " + e.getMessage(), e);
        }
    }

    public AbstractValidatoreXSD(Logger log, Node schema) throws Exception {
        this(log, FACTORY_DEFAULT, schema);
    }

    public AbstractValidatoreXSD(Logger log, String schemaFactory, Node schema) throws Exception {
        try {
            DOMSource streamSource = new DOMSource(schema);
            this.initializeSchema(log, schemaFactory, null, streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (Node): " + e.getMessage(), e);
        }
    }

    public AbstractValidatoreXSD(Logger log, LSResourceResolver lsResourceResolver, Node schema) throws Exception {
        this(log, FACTORY_DEFAULT, lsResourceResolver, schema);
    }

    public AbstractValidatoreXSD(Logger log, String schemaFactory, LSResourceResolver lsResourceResolver, Node schema) throws Exception {
        try {
            DOMSource streamSource = new DOMSource(schema);
            this.initializeSchema(log, schemaFactory, lsResourceResolver, streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (Node): " + e.getMessage(), e);
        }
    }

    public AbstractValidatoreXSD(Logger log, Node ... schema) throws Exception {
        this(log, FACTORY_DEFAULT, schema);
    }

    public AbstractValidatoreXSD(Logger log, String schemaFactory, Node ... schema) throws Exception {
        try {
            Source[] ss = new DOMSource[schema.length];
            for (int i = 0; i < schema.length; ++i) {
                ss[i] = new DOMSource(schema[i]);
            }
            this.initializeSchema(log, schemaFactory, null, ss);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (Node): " + e.getMessage(), e);
        }
    }

    public AbstractValidatoreXSD(Logger log, LSResourceResolver lsResourceResolver, Node ... schema) throws Exception {
        this(log, FACTORY_DEFAULT, lsResourceResolver, schema);
    }

    public AbstractValidatoreXSD(Logger log, String schemaFactory, LSResourceResolver lsResourceResolver, Node ... schema) throws Exception {
        try {
            Source[] ss = new DOMSource[schema.length];
            for (int i = 0; i < schema.length; ++i) {
                ss[i] = new DOMSource(schema[i]);
            }
            this.initializeSchema(log, schemaFactory, lsResourceResolver, ss);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (Node): " + e.getMessage(), e);
        }
    }

    public AbstractValidatoreXSD(Logger log, Source source) throws Exception {
        this(log, FACTORY_DEFAULT, source);
    }

    public AbstractValidatoreXSD(Logger log, String schemaFactory, Source source) throws Exception {
        try {
            this.initializeSchema(log, schemaFactory, null, source);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (Source): " + e.getMessage(), e);
        }
    }

    public AbstractValidatoreXSD(Logger log, LSResourceResolver lsResourceResolver, Source source) throws Exception {
        this(log, FACTORY_DEFAULT, lsResourceResolver, source);
    }

    public AbstractValidatoreXSD(Logger log, String schemaFactory, LSResourceResolver lsResourceResolver, Source source) throws Exception {
        try {
            this.initializeSchema(log, schemaFactory, lsResourceResolver, source);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (Source): " + e.getMessage(), e);
        }
    }

    public AbstractValidatoreXSD(Logger log, Source ... source) throws Exception {
        this(log, FACTORY_DEFAULT, source);
    }

    public AbstractValidatoreXSD(Logger log, String schemaFactory, Source ... source) throws Exception {
        try {
            this.initializeSchema(log, schemaFactory, null, source);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (Source): " + e.getMessage(), e);
        }
    }

    public AbstractValidatoreXSD(Logger log, LSResourceResolver lsResourceResolver, Source ... source) throws Exception {
        this(log, FACTORY_DEFAULT, lsResourceResolver, source);
    }

    public AbstractValidatoreXSD(Logger log, String schemaFactory, LSResourceResolver lsResourceResolver, Source ... source) throws Exception {
        try {
            this.initializeSchema(log, schemaFactory, lsResourceResolver, source);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (Source): " + e.getMessage(), e);
        }
    }

    public abstract AbstractXMLUtils getXMLUtils();

    private void initializeSchema(Logger log, String schemaFactory, LSResourceResolver lsResourceResolver, Source streamSource) throws Exception {
        try {
            SchemaFactory factory = null;
            if (schemaFactory != null && !FACTORY_DEFAULT.equals(schemaFactory)) {
                factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema", schemaFactory, this.getClass().getClassLoader());
                if (this.getXMLUtils().isDisabledDTDs()) {
                    factory.setFeature(this.getXMLUtils().getFeatures_disallow_doctype_decl(), true);
                }
            } else {
                factory = this.getXMLUtils().getSchemaFactory();
            }
            log.info("SchemaFactory[" + factory.getClass().getName() + "]");
            if (lsResourceResolver != null) {
                factory.setResourceResolver(lsResourceResolver);
            }
            this.schema = factory.newSchema(streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante l'inizializzazione dello schema: " + e.getMessage(), e);
        }
    }

    private void initializeSchema(Logger log, String schemaFactory, LSResourceResolver lsResourceResolver, Source[] streamSource) throws Exception {
        try {
            SchemaFactory factory = null;
            if (schemaFactory != null && !FACTORY_DEFAULT.equals(schemaFactory)) {
                factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema", schemaFactory, this.getClass().getClassLoader());
                if (this.getXMLUtils().isDisabledDTDs()) {
                    factory.setFeature(this.getXMLUtils().getFeatures_disallow_doctype_decl(), true);
                }
            } else {
                factory = this.getXMLUtils().getSchemaFactory();
            }
            log.info("SchemaFactory[" + factory.getClass().getName() + "]");
            if (lsResourceResolver != null) {
                factory.setResourceResolver(lsResourceResolver);
            }
            this.schema = factory.newSchema(streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante l'inizializzazione dello schema: " + e.getMessage(), e);
        }
    }

    public void valida(Node nodeXML) throws Exception {
        this.valida(new DOMSourceFix(nodeXML));
    }

    public void valida(Node nodeXML, ErrorHandler errorHandler) throws Exception {
        this.valida(new DOMSourceFix(nodeXML), errorHandler);
    }

    public void valida(Node nodeXML, boolean streamSource) throws Exception {
        this.valida(nodeXML, streamSource, null);
    }

    public abstract byte[] getAsByte(Node var1) throws XMLException;

    public void valida(Node nodeXML, boolean streamSource, ErrorHandler errorHandler) throws Exception {
        if (streamSource) {
            ByteArrayInputStream bin = new ByteArrayInputStream(this.getAsByte(nodeXML));
            this.valida(new StreamSource(bin), errorHandler);
        } else {
            this.valida(nodeXML, errorHandler);
        }
    }

    public void valida(InputStream inputStreamXML) throws Exception {
        this.valida(new StreamSource(inputStreamXML));
    }

    public void valida(InputStream inputStreamXML, ErrorHandler errorHandler) throws Exception {
        this.valida(new StreamSource(inputStreamXML), errorHandler);
    }

    public void valida(File fileXML) throws Exception {
        this.valida(new StreamSource(fileXML));
    }

    public void valida(File fileXML, ErrorHandler errorHandler) throws Exception {
        this.valida(new StreamSource(fileXML), errorHandler);
    }

    public void valida(String urlXML) throws Exception {
        this.valida(new StreamSource(urlXML));
    }

    public void valida(String urlXML, ErrorHandler errorHandler) throws Exception {
        this.valida(new StreamSource(urlXML), errorHandler);
    }

    public void valida(Source source) throws Exception {
        this.valida(source, null);
    }

    public void valida(Source source, ErrorHandler errorHandler) throws Exception {
        Validator validator = this.schema.newValidator();
        if (errorHandler != null) {
            validator.setErrorHandler(errorHandler);
        }
        validator.validate(source);
    }
}

