/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.DOMDestination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import org.apache.commons.io.output.CountingOutputStream;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.WrapperDestination;
import org.openspcoop2.utils.xml.WrapperFileXdmNode;
import org.openspcoop2.utils.xml.XQueryEvaluateException;
import org.openspcoop2.utils.xml.XQueryEvaluateNotFoundException;
import org.openspcoop2.utils.xml.XQueryException;
import org.openspcoop2.utils.xml.XQueryNotValidException;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class AbstractXQueryExpressionEngine {
    private static final boolean DEFAULT_RESULT_AS_XML = false;
    private static Configuration saxonConfig = null;
    private static Processor saxonProcessor = null;
    private static XQueryCompiler saxonCompiler = null;
    private static Logger logger = LoggerWrapperFactory.getLogger(AbstractXQueryExpressionEngine.class);

    public static void initXQueryConfiguration() throws XQueryException {
        AbstractXQueryExpressionEngine._initXQueryConfiguration(null);
    }

    public static void initXQueryConfiguration(String fileConfig) throws XQueryException {
        if (fileConfig == null) {
            throw new XQueryException("Configuration file is null");
        }
        AbstractXQueryExpressionEngine.initXQueryConfiguration(new File(fileConfig));
    }

    public static void initXQueryConfiguration(File fileConfig) throws XQueryException {
        if (fileConfig == null) {
            throw new XQueryException("Configuration file is null");
        }
        if (!fileConfig.exists()) {
            throw new XQueryException("Configuration file [" + fileConfig.getAbsolutePath() + "] not exists");
        }
        if (!fileConfig.canRead()) {
            throw new XQueryException("Configuration file [" + fileConfig.getAbsolutePath() + "] cannot read");
        }
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(fileConfig);
            AbstractXQueryExpressionEngine._initXQueryConfiguration(fin);
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void initXQueryConfiguration(InputStream isConfig) throws XQueryException {
        if (isConfig == null) {
            throw new XQueryException("Configuration stream is null");
        }
        AbstractXQueryExpressionEngine._initXQueryConfiguration(isConfig);
    }

    private static synchronized void _initXQueryConfiguration(InputStream isConfig) throws XQueryException {
        try {
            if (saxonConfig == null) {
                if (isConfig == null) {
                    saxonConfig = Configuration.newConfiguration();
                } else {
                    StreamSource s = new StreamSource(isConfig);
                    saxonConfig = Configuration.readConfiguration((Source)s);
                }
            }
        }
        catch (Exception e) {
            throw new XQueryException("Inizializzazione XQueryConfiguration non riuscita", e);
        }
    }

    public static Processor getXQueryProcessor() throws XQueryException {
        if (saxonProcessor == null) {
            AbstractXQueryExpressionEngine.initXQueryProcessor();
        }
        return saxonProcessor;
    }

    public static XQueryCompiler getXQueryCompiler() throws XQueryException {
        if (saxonProcessor == null) {
            AbstractXQueryExpressionEngine.initXQueryProcessor();
        }
        return saxonCompiler;
    }

    public static synchronized void initXQueryProcessor() throws XQueryException {
        try {
            if (saxonProcessor == null) {
                if (saxonConfig == null) {
                    AbstractXQueryExpressionEngine.initXQueryConfiguration();
                }
                saxonProcessor = new Processor(saxonConfig);
                saxonCompiler = saxonProcessor.newXQueryCompiler();
            }
        }
        catch (Exception e) {
            throw new XQueryException("Inizializzazione XQueryFactory non riuscita", e);
        }
    }

    public static void setLogger(Logger logger) {
        AbstractXQueryExpressionEngine.logger = logger;
    }

    public abstract AbstractXMLUtils getXMLUtils();

    public abstract Element readXPathElement(Element var1);

    private XdmNode _buildXdmNode(Object xdmNodeParam) throws XQueryException {
        if (xdmNodeParam == null) {
            throw new XQueryException("Parameter xdmNodeParam is null");
        }
        Source source = null;
        FileInputStream isFile = null;
        try {
            InputSource eis;
            if (xdmNodeParam instanceof Element) {
                source = new DOMSource(this.readXPathElement((Element)xdmNodeParam).getOwnerDocument());
            } else if (xdmNodeParam instanceof Document) {
                source = new DOMSource((Document)xdmNodeParam);
            } else if (xdmNodeParam instanceof Node) {
                source = new DOMSource(((Node)xdmNodeParam).getOwnerDocument());
            } else if (xdmNodeParam instanceof File) {
                isFile = new FileInputStream((File)xdmNodeParam);
                eis = new InputSource(isFile);
                source = new SAXSource(eis);
            } else if (xdmNodeParam instanceof InputStream) {
                eis = new InputSource((InputStream)xdmNodeParam);
                source = new SAXSource(eis);
            } else if (xdmNodeParam instanceof Reader) {
                eis = new InputSource((Reader)xdmNodeParam);
                source = new SAXSource(eis);
            } else if (xdmNodeParam instanceof String) {
                source = new DOMSource(this.getXMLUtils().newDocument(((String)xdmNodeParam).getBytes()));
            } else {
                throw new XQueryException("Type Parameter '" + xdmNodeParam.getClass().getName() + "' not supported");
            }
            DocumentBuilder builder = AbstractXQueryExpressionEngine.getXQueryProcessor().newDocumentBuilder();
            if (isFile != null) {
                return new WrapperFileXdmNode(builder.build(source), isFile);
            }
            return builder.build(source);
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    private WrapperDestination _buildDestination(Object destinationParam, boolean xml) throws XQueryException {
        if (destinationParam == null) {
            throw new XQueryException("Parameter destination is null");
        }
        WrapperDestination wrapper = new WrapperDestination();
        DOMDestination destination = null;
        try {
            if (destinationParam instanceof Node) {
                wrapper.node = (Node)destinationParam;
                destination = new DOMDestination(wrapper.node);
            } else if (destinationParam instanceof File) {
                wrapper.file = (File)destinationParam;
                destination = AbstractXQueryExpressionEngine.getXQueryProcessor().newSerializer(wrapper.file);
            } else if (destinationParam instanceof OutputStream) {
                wrapper.cout = new CountingOutputStream((OutputStream)destinationParam);
                destination = AbstractXQueryExpressionEngine.getXQueryProcessor().newSerializer((OutputStream)wrapper.cout);
            } else if (destinationParam instanceof Writer) {
                wrapper.writer = (Writer)destinationParam;
                destination = AbstractXQueryExpressionEngine.getXQueryProcessor().newSerializer(wrapper.writer);
            } else {
                throw new XQueryException("Type Parameter '" + destinationParam.getClass().getName() + "' not supported");
            }
            if (destination instanceof Serializer && xml) {
                ((Serializer)destination).setOutputProperty(Serializer.Property.METHOD, "xml");
                ((Serializer)destination).setOutputProperty(Serializer.Property.INDENT, "yes");
                ((Serializer)destination).setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
            }
            wrapper.destination = destination;
            return wrapper;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    private XQueryEvaluator _buildEvaluator(Object xquery) throws XQueryException, XQueryNotValidException {
        if (xquery == null) {
            throw new XQueryException("Parameter xquery is null");
        }
        XQueryExecutable exp = null;
        try {
            if (xquery instanceof String) {
                exp = AbstractXQueryExpressionEngine.getXQueryCompiler().compile((String)xquery);
            } else if (xquery instanceof File) {
                exp = AbstractXQueryExpressionEngine.getXQueryCompiler().compile((File)xquery);
            } else if (xquery instanceof InputStream) {
                exp = AbstractXQueryExpressionEngine.getXQueryCompiler().compile((InputStream)xquery);
            } else if (xquery instanceof Reader) {
                exp = AbstractXQueryExpressionEngine.getXQueryCompiler().compile((Reader)xquery);
            } else {
                throw new XQueryException("Type Parameter '" + xquery.getClass().getName() + "' not supported");
            }
            return exp.load();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryNotValidException(e.getMessage(), e);
        }
    }

    private void _evaluate(XdmNode doc, XQueryEvaluator evaluator, WrapperDestination destination) throws XQueryException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            evaluator.setContextItem((XdmItem)doc);
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
        try {
            evaluator.setContextItem((XdmItem)doc);
            evaluator.run(destination.destination);
            if (destination.cout != null) {
                destination.cout.flush();
                destination.cout.close();
                if (destination.cout.getByteCount() <= 0L) {
                    throw new XQueryEvaluateNotFoundException("Not write bytes in output stream destination");
                }
            } else if (destination.file != null) {
                if (destination.file.length() <= 0L) {
                    throw new XQueryEvaluateNotFoundException("File destination is empty");
                }
            } else if (destination.node != null) {
                if (!(destination.node.getChildNodes() != null && destination.node.getChildNodes().getLength() > 0 || destination.node.hasAttributes())) {
                    throw new XQueryEvaluateNotFoundException("Node destination is empty");
                }
            } else if (destination.writer != null) {
                // empty if block
            }
        }
        catch (XQueryEvaluateNotFoundException notFound) {
            throw notFound;
        }
        catch (Exception e) {
            throw new XQueryEvaluateException(e.getMessage(), e);
        }
        finally {
            try {
                if (doc instanceof WrapperFileXdmNode) {
                    ((WrapperFileXdmNode)doc).is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void validate(Object xquery) throws XQueryException, XQueryNotValidException {
        this._buildEvaluator(xquery);
    }

    public String evaluate(Node source, String xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(Node source, String xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public String evaluate(Node source, File xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(Node source, File xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public String evaluate(Node source, InputStream xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(Node source, InputStream xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public String evaluate(Node source, Reader xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(Node source, Reader xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public void evaluate(Node source, String xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Node source, String xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Node source, File xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Node source, File xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Node source, InputStream xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Node source, InputStream xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Node source, Reader xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Node source, Reader xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Node source, String xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Node source, String xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Node source, File xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Node source, File xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Node source, InputStream xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Node source, InputStream xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Node source, Reader xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Node source, Reader xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Node source, String xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Node source, String xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Node source, File xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Node source, File xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Node source, InputStream xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Node source, InputStream xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Node source, Reader xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Node source, Reader xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Node source, String xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Node source, String xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Node source, File xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Node source, File xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Node source, InputStream xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Node source, InputStream xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Node source, Reader xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Node source, Reader xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public String evaluate(Document source, String xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(Document source, String xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public String evaluate(Document source, File xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(Document source, File xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public String evaluate(Document source, InputStream xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(Document source, InputStream xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public String evaluate(Document source, Reader xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(Document source, Reader xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public void evaluate(Document source, String xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Document source, String xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Document source, File xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Document source, File xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Document source, InputStream xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Document source, InputStream xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Document source, Reader xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Document source, Reader xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Document source, String xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Document source, String xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Document source, File xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Document source, File xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Document source, InputStream xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Document source, InputStream xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Document source, Reader xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Document source, Reader xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Document source, String xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Document source, String xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Document source, File xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Document source, File xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Document source, InputStream xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Document source, InputStream xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Document source, Reader xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Document source, Reader xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Document source, String xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Document source, String xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Document source, File xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Document source, File xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Document source, InputStream xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Document source, InputStream xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Document source, Reader xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Document source, Reader xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public String evaluate(InputStream source, String xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(InputStream source, String xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public String evaluate(InputStream source, File xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(InputStream source, File xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public String evaluate(InputStream source, InputStream xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(InputStream source, InputStream xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public String evaluate(InputStream source, Reader xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(InputStream source, Reader xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public void evaluate(InputStream source, String xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(InputStream source, String xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(InputStream source, File xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(InputStream source, File xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(InputStream source, InputStream xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(InputStream source, InputStream xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(InputStream source, Reader xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(InputStream source, Reader xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(InputStream source, String xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(InputStream source, String xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(InputStream source, File xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(InputStream source, File xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(InputStream source, InputStream xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(InputStream source, InputStream xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(InputStream source, Reader xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(InputStream source, Reader xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(InputStream source, String xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(InputStream source, String xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(InputStream source, File xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(InputStream source, File xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(InputStream source, InputStream xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(InputStream source, InputStream xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(InputStream source, Reader xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(InputStream source, Reader xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(InputStream source, String xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(InputStream source, String xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(InputStream source, File xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(InputStream source, File xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(InputStream source, InputStream xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(InputStream source, InputStream xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(InputStream source, Reader xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(InputStream source, Reader xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public String evaluate(Reader source, String xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(Reader source, String xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public String evaluate(Reader source, File xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(Reader source, File xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public String evaluate(Reader source, InputStream xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(Reader source, InputStream xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public String evaluate(Reader source, Reader xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(Reader source, Reader xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public void evaluate(Reader source, String xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Reader source, String xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Reader source, File xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Reader source, File xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Reader source, InputStream xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Reader source, InputStream xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Reader source, Reader xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Reader source, Reader xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Reader source, String xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Reader source, String xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Reader source, File xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Reader source, File xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Reader source, InputStream xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Reader source, InputStream xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Reader source, Reader xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Reader source, Reader xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Reader source, String xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Reader source, String xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Reader source, File xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Reader source, File xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Reader source, InputStream xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Reader source, InputStream xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Reader source, Reader xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Reader source, Reader xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Reader source, String xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Reader source, String xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Reader source, File xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Reader source, File xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Reader source, InputStream xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Reader source, InputStream xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(Reader source, Reader xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(Reader source, Reader xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public String evaluate(File source, String xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(File source, String xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public String evaluate(File source, File xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(File source, File xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public String evaluate(File source, InputStream xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(File source, InputStream xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public String evaluate(File source, Reader xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(File source, Reader xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public void evaluate(File source, String xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(File source, String xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(File source, File xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(File source, File xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(File source, InputStream xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(File source, InputStream xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(File source, Reader xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(File source, Reader xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(File source, String xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(File source, String xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(File source, File xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(File source, File xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(File source, InputStream xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(File source, InputStream xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(File source, Reader xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(File source, Reader xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(File source, String xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(File source, String xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(File source, File xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(File source, File xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(File source, InputStream xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(File source, InputStream xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(File source, Reader xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(File source, Reader xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(File source, String xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(File source, String xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(File source, File xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(File source, File xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(File source, InputStream xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(File source, InputStream xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(File source, Reader xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(File source, Reader xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public String evaluate(String source, String xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(String source, String xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public String evaluate(String source, File xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(String source, File xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public String evaluate(String source, InputStream xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(String source, InputStream xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public String evaluate(String source, Reader xquery) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        return this.evaluate(source, xquery, false);
    }

    public String evaluate(String source, Reader xquery, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.evaluate(source, xquery, (OutputStream)bout, resultAsXml);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (XQueryException e) {
            throw e;
        }
        catch (XQueryNotValidException e) {
            throw e;
        }
        catch (XQueryEvaluateException e) {
            throw e;
        }
        catch (XQueryEvaluateNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XQueryException(e.getMessage(), e);
        }
    }

    public void evaluate(String source, String xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(String source, String xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(String source, File xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(String source, File xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(String source, InputStream xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(String source, InputStream xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(String source, Reader xquery, OutputStream out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(String source, Reader xquery, OutputStream out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(String source, String xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(String source, String xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(String source, File xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(String source, File xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(String source, InputStream xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(String source, InputStream xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(String source, Reader xquery, Writer out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(String source, Reader xquery, Writer out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(String source, String xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(String source, String xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(String source, File xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(String source, File xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(String source, InputStream xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(String source, InputStream xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(String source, Reader xquery, File out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(String source, Reader xquery, File out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(String source, String xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(String source, String xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(String source, File xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(String source, File xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(String source, InputStream xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(String source, InputStream xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }

    public void evaluate(String source, Reader xquery, Node out) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, false));
    }

    public void evaluate(String source, Reader xquery, Node out, boolean resultAsXml) throws XQueryException, XQueryNotValidException, XQueryEvaluateException, XQueryEvaluateNotFoundException {
        this._evaluate(this._buildXdmNode(source), this._buildEvaluator(xquery), this._buildDestination(out, resultAsXml));
    }
}

