/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.XMLException;
import org.openspcoop2.utils.xml.XSDSchemaCollection;
import org.slf4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XSDUtils {
    private AbstractXMLUtils xmlUtils;

    public XSDUtils(AbstractXMLUtils xmlUtils) {
        this.xmlUtils = xmlUtils;
    }

    public boolean isXSDSchema(byte[] xsd) throws XMLException {
        try {
            if (!this.xmlUtils.isDocument(xsd)) {
                return false;
            }
            Document docXML = this.xmlUtils.newDocument(xsd);
            Element elemXML = docXML.getDocumentElement();
            return this.isXSDSchema(elemXML);
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public boolean isXSDSchema(Document xsd) throws XMLException {
        Element elemXML = xsd.getDocumentElement();
        return this.isXSDSchema(elemXML);
    }

    public boolean isXSDSchema(Element xsd) throws XMLException {
        return this.isXSDSchema((Node)xsd);
    }

    public boolean isXSDSchema(Node xsd) throws XMLException {
        try {
            if (xsd == null) {
                throw new XMLException("Schema xsd da verificare non definito");
            }
            if (!"schema".equals(xsd.getLocalName())) {
                return false;
            }
            return "http://www.w3.org/2001/XMLSchema".equals(xsd.getNamespaceURI());
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public String getTargetNamespace(byte[] xsd) throws XMLException {
        try {
            if (!this.xmlUtils.isDocument(xsd)) {
                throw new XMLException("Schema xsd non e' un documento valido");
            }
            Document docXML = this.xmlUtils.newDocument(xsd);
            Element elemXML = docXML.getDocumentElement();
            return this.getTargetNamespace(elemXML);
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public String getTargetNamespace(Document xsd) throws XMLException {
        Element elemXML = xsd.getDocumentElement();
        return this.getTargetNamespace(elemXML);
    }

    public String getTargetNamespace(Element xsd) throws XMLException {
        return this.getTargetNamespace((Node)xsd);
    }

    public String getTargetNamespace(Node xsd) throws XMLException {
        try {
            if (xsd == null) {
                throw new XMLException("Schema xsd non e' un documento valido");
            }
            if (!"schema".equals(xsd.getLocalName())) {
                throw new XMLException("Root element non e' uno schema xsd (" + xsd.getLocalName() + ")");
            }
            String targetNamespace = this.xmlUtils.getAttributeValue(xsd, "targetNamespace");
            return targetNamespace;
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public void updateSchemaLocation(Node schemaImportInclude, String newLocation) {
        if (schemaImportInclude != null && schemaImportInclude.getAttributes() != null && schemaImportInclude.getAttributes().getLength() > 0) {
            Attr oldSchemaLocation = (Attr)schemaImportInclude.getAttributes().getNamedItem("schemaLocation");
            this.xmlUtils.removeAttribute(oldSchemaLocation, (Element)schemaImportInclude);
            oldSchemaLocation.setValue(newLocation);
            this.xmlUtils.addAttribute(oldSchemaLocation, (Element)schemaImportInclude);
        }
    }

    public String getImportNamespace(Node xsd) throws XMLException {
        try {
            if (xsd == null) {
                throw new XMLException("Non e' un import valido");
            }
            if (!"import".equals(xsd.getLocalName())) {
                throw new XMLException("Root element non e' un import di uno schema xsd (" + xsd.getLocalName() + ")");
            }
            String targetNamespace = this.xmlUtils.getAttributeValue(xsd, "namespace");
            return targetNamespace;
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public String getImportSchemaLocation(Node xsd) throws XMLException {
        try {
            if (xsd == null) {
                throw new XMLException("Non e' un import valido");
            }
            if (!"import".equals(xsd.getLocalName())) {
                throw new XMLException("Root element non e' un import di uno schema xsd (" + xsd.getLocalName() + ")");
            }
            String targetNamespace = this.xmlUtils.getAttributeValue(xsd, "schemaLocation");
            return targetNamespace;
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public boolean isSchemaWithOnlyImports(Node xsd) throws XMLException {
        if (!this.isXSDSchema(xsd)) {
            throw new XMLException("Il parametro fornito non \u00e8 uno schema");
        }
        List<Node> listChild = this.xmlUtils.getNotEmptyChildNodes(xsd, false);
        if (listChild == null || listChild.isEmpty()) {
            return false;
        }
        boolean schemaConSoloImports = true;
        for (int j = 0; j < listChild.size(); ++j) {
            if ("import".equals(listChild.get(j).getLocalName()) && "http://www.w3.org/2001/XMLSchema".equals(listChild.get(j).getNamespaceURI())) continue;
            schemaConSoloImports = false;
            break;
        }
        return schemaConSoloImports;
    }

    public String getIncludeSchemaLocation(Node xsd) throws XMLException {
        try {
            if (xsd == null) {
                throw new XMLException("Non e' un import valido");
            }
            if (!"include".equals(xsd.getLocalName())) {
                throw new XMLException("Root element non e' un include di uno schema xsd (" + xsd.getLocalName() + ")");
            }
            String targetNamespace = this.xmlUtils.getAttributeValue(xsd, "schemaLocation");
            return targetNamespace;
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public boolean isSchemaWithOnlyIncludes(Node xsd) throws XMLException {
        if (!this.isXSDSchema(xsd)) {
            throw new XMLException("Il parametro fornito non \u00e8 uno schema");
        }
        List<Node> listChild = this.xmlUtils.getNotEmptyChildNodes(xsd, false);
        if (listChild == null || listChild.isEmpty()) {
            return false;
        }
        boolean schemaConSoloIncludes = true;
        for (int j = 0; j < listChild.size(); ++j) {
            if ("include".equals(listChild.get(j).getLocalName()) && "http://www.w3.org/2001/XMLSchema".equals(listChild.get(j).getNamespaceURI())) continue;
            schemaConSoloIncludes = false;
            break;
        }
        return schemaConSoloIncludes;
    }

    public boolean isSchemaWithOnlyImportsAndIncludes(Node xsd) throws XMLException {
        if (!this.isXSDSchema(xsd)) {
            throw new XMLException("Il parametro fornito non \u00e8 uno schema");
        }
        List<Node> listChild = this.xmlUtils.getNotEmptyChildNodes(xsd, false);
        if (listChild == null || listChild.isEmpty()) {
            return false;
        }
        boolean schemaConSoloImportsAndIncludes = true;
        for (int j = 0; j < listChild.size(); ++j) {
            if (("import".equals(listChild.get(j).getLocalName()) || "include".equals(listChild.get(j).getLocalName())) && "http://www.w3.org/2001/XMLSchema".equals(listChild.get(j).getNamespaceURI())) continue;
            schemaConSoloImportsAndIncludes = false;
            break;
        }
        return schemaConSoloImportsAndIncludes;
    }

    public List<Node> readImportsAndIncludes(Document xsd) throws XMLException {
        return this.readImportsIncludes(null, xsd, null, true, true);
    }

    public List<Node> readImports(Document xsd) throws XMLException {
        return this.readImportsIncludes(null, xsd, null, true, false);
    }

    public List<Node> readIncludes(Document xsd) throws XMLException {
        return this.readImportsIncludes(null, xsd, null, false, true);
    }

    public List<Node> readImportsAndIncludes(Element xsd) throws XMLException {
        return this.readImportsIncludes(null, null, xsd, true, true);
    }

    public List<Node> readImports(Element xsd) throws XMLException {
        return this.readImportsIncludes(null, null, xsd, true, false);
    }

    public List<Node> readIncludes(Element xsd) throws XMLException {
        return this.readImportsIncludes(null, null, xsd, false, true);
    }

    public List<Node> readImportsAndIncludes(String targetNamespaceSchema, Element xsd) throws XMLException {
        return this.readImportsIncludes(targetNamespaceSchema, null, xsd, true, true);
    }

    public List<Node> readImports(String targetNamespaceSchema, Element xsd) throws XMLException {
        return this.readImportsIncludes(targetNamespaceSchema, null, xsd, true, false);
    }

    public List<Node> readIncludes(String targetNamespaceSchema, Element xsd) throws XMLException {
        return this.readImportsIncludes(targetNamespaceSchema, null, xsd, false, true);
    }

    public List<Node> readImportsAndIncludes(Node xsd) throws XMLException {
        return this.readImportsIncludes(null, null, xsd, true, true);
    }

    public List<Node> readImports(Node xsd) throws XMLException {
        return this.readImportsIncludes(null, null, xsd, true, false);
    }

    public List<Node> readIncludes(Node xsd) throws XMLException {
        return this.readImportsIncludes(null, null, xsd, false, true);
    }

    public List<Node> readImportsAndIncludes(String targetNamespaceSchema, Node xsd) throws XMLException {
        return this.readImportsIncludes(targetNamespaceSchema, null, xsd, true, true);
    }

    public List<Node> readImports(String targetNamespaceSchema, Node xsd) throws XMLException {
        return this.readImportsIncludes(targetNamespaceSchema, null, xsd, true, false);
    }

    public List<Node> readIncludes(String targetNamespaceSchema, Node xsd) throws XMLException {
        return this.readImportsIncludes(targetNamespaceSchema, null, xsd, false, true);
    }

    private List<Node> readImportsIncludes(String targetNamespaceSchema, Document xsdD, Node xsdE, boolean imports, boolean includes) throws XMLException {
        try {
            ArrayList<Node> nodes = new ArrayList<Node>();
            NodeList list = null;
            list = xsdD != null ? xsdD.getChildNodes() : xsdE.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    Node child = list.item(i);
                    if ("schema".equals(child.getLocalName())) {
                        NodeList listDefinition;
                        if (targetNamespaceSchema == null) {
                            try {
                                targetNamespaceSchema = this.getTargetNamespace(child);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if ((listDefinition = child.getChildNodes()) == null) continue;
                        for (int j = 0; j < listDefinition.getLength(); ++j) {
                            Node childDefinition = listDefinition.item(j);
                            if (imports && "import".equals(childDefinition.getLocalName())) {
                                if (targetNamespaceSchema == null) {
                                    try {
                                        targetNamespaceSchema = this.getImportNamespace(childDefinition);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                childDefinition.setUserData("TargetNamespaceSchema", targetNamespaceSchema, null);
                                nodes.add(childDefinition);
                            }
                            if (!includes || !"include".equals(childDefinition.getLocalName())) continue;
                            childDefinition.setUserData("TargetNamespaceSchema", targetNamespaceSchema, null);
                            nodes.add(childDefinition);
                        }
                        continue;
                    }
                    if ("import".equals(child.getLocalName())) {
                        if (!imports) continue;
                        if (targetNamespaceSchema == null) {
                            try {
                                targetNamespaceSchema = this.getImportNamespace(child);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        child.setUserData("TargetNamespaceSchema", targetNamespaceSchema, null);
                        nodes.add(child);
                        continue;
                    }
                    if (!"include".equals(child.getLocalName()) || !includes) continue;
                    if (targetNamespaceSchema == null) {
                        throw new XMLException("Lo schema esegue un include senza definire un targetNamespace.");
                    }
                    child.setUserData("TargetNamespaceSchema", targetNamespaceSchema, null);
                    nodes.add(child);
                }
            }
            return nodes;
        }
        catch (Exception e) {
            throw new XMLException("Riscontrato errore durante la lettura dello schema: " + e.getMessage(), e);
        }
    }

    public void removeImport(Document xsd, Node importNode) {
        this.removeImportsEngine(xsd, null, true, false, importNode);
    }

    public void removeInclude(Document xsd, Node includeNode) {
        this.removeImportsEngine(xsd, null, false, true, includeNode);
    }

    public void removeImport(Element xsd, Node importNode) {
        this.removeImportsEngine(null, xsd, true, false, importNode);
    }

    public void removeInclude(Element xsd, Node includeNode) {
        this.removeImportsEngine(null, xsd, false, true, includeNode);
    }

    public void removeImport(Node xsd, Node importNode) {
        this.removeImportsEngine(null, xsd, true, false, importNode);
    }

    public void removeInclude(Node xsd, Node includeNode) {
        this.removeImportsEngine(null, xsd, false, true, includeNode);
    }

    public void removeImports(Document xsd) {
        this.removeImportsEngine(xsd, null, true, false, null);
    }

    public void removeIncludes(Document xsd) {
        this.removeImportsEngine(xsd, null, false, true, null);
    }

    public void removeImportsAndIncludes(Document xsd) {
        this.removeImportsEngine(xsd, null, true, true, null);
    }

    public void removeImports(Element xsd) {
        this.removeImportsEngine(null, xsd, true, false, null);
    }

    public void removeIncludes(Element xsd) {
        this.removeImportsEngine(null, xsd, false, true, null);
    }

    public void removeImportsAndIncludes(Element xsd) {
        this.removeImportsEngine(null, xsd, true, true, null);
    }

    public void removeImports(Node xsd) {
        this.removeImportsEngine(null, xsd, true, false, null);
    }

    public void removeIncludes(Node xsd) {
        this.removeImportsEngine(null, xsd, false, true, null);
    }

    public void removeImportsAndIncludes(Node xsd) {
        this.removeImportsEngine(null, xsd, true, true, null);
    }

    private void removeImportsEngine(Document xsdD, Node xsdE, boolean imports, boolean includes, Node importIncludeNode) {
        NodeList list = null;
        list = xsdD != null ? xsdD.getChildNodes() : xsdE.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node child = list.item(i);
                if ("schema".equals(child.getLocalName())) {
                    NodeList listDefinition = child.getChildNodes();
                    if (listDefinition == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        Node childDefinition = listDefinition.item(j);
                        if (imports && "import".equals(childDefinition.getLocalName())) {
                            if (importIncludeNode == null) {
                                child.removeChild(childDefinition);
                            } else if (importIncludeNode.equals(childDefinition)) {
                                child.removeChild(childDefinition);
                            }
                        }
                        if (!includes || !"include".equals(childDefinition.getLocalName())) continue;
                        if (importIncludeNode == null) {
                            child.removeChild(childDefinition);
                            continue;
                        }
                        if (!importIncludeNode.equals(childDefinition)) continue;
                        child.removeChild(childDefinition);
                    }
                    continue;
                }
                if ("import".equals(child.getLocalName())) {
                    if (!imports) continue;
                    if (importIncludeNode == null) {
                        if (xsdD != null) {
                            xsdD.removeChild(child);
                            continue;
                        }
                        xsdE.removeChild(child);
                        continue;
                    }
                    if (!importIncludeNode.equals(child)) continue;
                    if (xsdD != null) {
                        xsdD.removeChild(child);
                        continue;
                    }
                    xsdE.removeChild(child);
                    continue;
                }
                if (!"include".equals(child.getLocalName()) || !includes) continue;
                if (importIncludeNode == null) {
                    if (xsdD != null) {
                        xsdD.removeChild(child);
                        continue;
                    }
                    xsdE.removeChild(child);
                    continue;
                }
                if (!importIncludeNode.equals(child)) continue;
                if (xsdD != null) {
                    xsdD.removeChild(child);
                    continue;
                }
                xsdE.removeChild(child);
            }
        }
    }

    public XSDSchemaCollection buildSchemaCollection(Map<String, byte[]> resources, Map<String, List<String>> mappingNamespaceLocations, Logger logger) throws XMLException {
        if (logger != null) {
            // empty if block
        }
        if (resources.size() == 0) {
            throw new XMLException("Schemi non presenti");
        }
        byte[] schemaPerValidazione = null;
        try {
            StringBuilder bf = new StringBuilder();
            bf.append("<xsd:schema targetNamespace=\"http://openspcoop2.org/validazione_engine\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n");
            StringBuilder bfContenitori = new StringBuilder();
            StringBuilder bfImportNormali = new StringBuilder();
            int indexSystemId = 1;
            for (String targetNamespace : mappingNamespaceLocations.keySet()) {
                List<String> splitLocations = mappingNamespaceLocations.get(targetNamespace);
                if (splitLocations.size() == 1) {
                    bfImportNormali.append("\t<xsd:import namespace=\"" + targetNamespace + "\" schemaLocation=\"" + splitLocations.get(0) + "\" />\n");
                    continue;
                }
                String systemIdNewSchema = "System_OpenSPCoop_Id_" + indexSystemId + ".xsd";
                StringBuilder bfStessoNamespace = new StringBuilder();
                bfStessoNamespace.append("<xsd:schema targetNamespace=\"" + targetNamespace + "\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n");
                int insertedSchemas = 0;
                for (int i = 0; i < splitLocations.size(); ++i) {
                    boolean findImportInclude = false;
                    for (int j = 0; j < splitLocations.size(); ++j) {
                        if (j == i) continue;
                        byte[] xsd = resources.get(splitLocations.get(j));
                        Document d = this.xmlUtils.newDocument(xsd);
                        List<Node> imports = this.readImports(d);
                        if (imports != null) {
                            for (Node node : imports) {
                                String schemaLocation;
                                if (node == null || (schemaLocation = this.getImportSchemaLocation(node)) == null) continue;
                                String baseLocation = this.getBaseNameXSDLocation(schemaLocation);
                                if (!splitLocations.get(i).equals(baseLocation)) continue;
                                findImportInclude = true;
                                break;
                            }
                        }
                        if (findImportInclude) break;
                        List<Node> includes = this.readIncludes(d);
                        if (includes != null) {
                            for (Node node : includes) {
                                String schemaLocation;
                                if (node == null || (schemaLocation = this.getIncludeSchemaLocation(node)) == null) continue;
                                String baseLocation = this.getBaseNameXSDLocation(schemaLocation);
                                if (!splitLocations.get(i).equals(baseLocation)) continue;
                                findImportInclude = true;
                                break;
                            }
                        }
                        if (findImportInclude) break;
                    }
                    if (findImportInclude) continue;
                    bfStessoNamespace.append("\t<xsd:include schemaLocation=\"" + splitLocations.get(i) + "\" />\n");
                    ++insertedSchemas;
                }
                bfStessoNamespace.append("</xsd:schema>");
                if (insertedSchemas <= 0) continue;
                bfContenitori.append("\t<xsd:import namespace=\"" + targetNamespace + "\" schemaLocation=\"" + systemIdNewSchema + "\" />\n");
                resources.put(systemIdNewSchema, bfStessoNamespace.toString().getBytes());
                ++indexSystemId;
            }
            bf.append(bfContenitori.toString());
            bf.append(bfImportNormali.toString());
            bf.append("</xsd:schema>");
            schemaPerValidazione = bf.toString().getBytes();
        }
        catch (Exception e) {
            throw new XMLException("Creazione dello schema fallita: " + e.getMessage(), e);
        }
        XSDSchemaCollection collection = new XSDSchemaCollection();
        collection.setSchemaRoot(schemaPerValidazione);
        collection.setResources(resources);
        collection.setMappingNamespaceLocations(mappingNamespaceLocations);
        return collection;
    }

    public void registraMappingNamespaceLocations(byte[] resource, String location, Map<String, List<String>> mappingNamespaceLocations) throws XMLException {
        String targetNamespaceXSD = this.getTargetNamespace(resource);
        if (targetNamespaceXSD != null) {
            mappingNamespaceLocations.computeIfAbsent(targetNamespaceXSD, k -> new ArrayList()).add(location);
        }
    }

    public String getBaseNameXSDLocation(String location) throws MalformedURLException {
        if (location.startsWith("http://") || location.startsWith("https://") || location.startsWith("file://")) {
            URL url = new URL(location);
            File fileUrl = new File(url.getFile());
            return fileUrl.getName();
        }
        File f = new File(location);
        return f.getName();
    }
}

