/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml2json.test;

import com.google.common.base.Charsets;
import java.util.HashMap;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.xml.XMLUtils;
import org.openspcoop2.utils.xml2json.IJson2Xml;
import org.openspcoop2.utils.xml2json.IXml2Json;
import org.openspcoop2.utils.xml2json.MappedXml2Json;
import org.openspcoop2.utils.xml2json.Xml2JsonFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Xml2JsonTest {
    public static void main(String[] args) throws Exception {
        Xml2JsonTest.test();
    }

    public static void test() throws Exception {
        String xmlString = Utilities.getAsString(Xml2JsonTest.class.getResource("file.xml"), Charsets.ISO_8859_1.name());
        HashMap<String, String> xmlToJsonNamespaces = new HashMap<String, String>(1);
        xmlToJsonNamespaces.put("http://www.link.it/", "b");
        xmlToJsonNamespaces.put("http://www.link.it/employee", "a");
        System.out.println("XML iniziale: " + xmlString);
        IXml2Json xml2json = Xml2JsonFactory.getXml2JsonJsonML();
        IJson2Xml json2xml = Xml2JsonFactory.getJson2XmlJsonML();
        Xml2JsonTest.test(xmlString, "JSONML (String)", xml2json, json2xml);
        xml2json = Xml2JsonFactory.getXml2JsonMapped(xmlToJsonNamespaces);
        json2xml = Xml2JsonFactory.getJson2XmlMapped(xmlToJsonNamespaces);
        Xml2JsonTest.test(xmlString, "Mapped (String)", xml2json, json2xml);
        xml2json = Xml2JsonFactory.getXml2JsonMapped(new HashMap<String, String>(1));
        ((MappedXml2Json)xml2json).getConfiguration().setIgnoreNamespaces(true);
        json2xml = Xml2JsonFactory.getJson2XmlMapped(new HashMap<String, String>(1));
        Xml2JsonTest.test(xmlString, "Mapped (String) senza prefissi e namespace", xml2json, json2xml);
        xml2json = Xml2JsonFactory.getXml2JsonBadgerFish();
        json2xml = Xml2JsonFactory.getJson2XmlBadgerFish();
        Xml2JsonTest.test(xmlString, "BadgerFish (String)", xml2json, json2xml);
        XMLUtils instance = XMLUtils.getInstance();
        Element node = instance.newElement(xmlString.getBytes());
        IXml2Json xml2json2 = Xml2JsonFactory.getXml2JsonJsonML();
        IJson2Xml json2xml2 = Xml2JsonFactory.getJson2XmlJsonML();
        Xml2JsonTest.test(instance, node, "JSONML (Node)", xml2json2, json2xml2);
        xml2json2 = Xml2JsonFactory.getXml2JsonMapped(xmlToJsonNamespaces);
        json2xml2 = Xml2JsonFactory.getJson2XmlMapped(xmlToJsonNamespaces);
        Xml2JsonTest.test(instance, node, "Mapped (Node)", xml2json2, json2xml2);
        xml2json2 = Xml2JsonFactory.getXml2JsonMapped(new HashMap<String, String>(1));
        ((MappedXml2Json)xml2json2).getConfiguration().setIgnoreNamespaces(true);
        json2xml2 = Xml2JsonFactory.getJson2XmlMapped(new HashMap<String, String>(1));
        Xml2JsonTest.test(instance, node, "Mapped (Node) senza prefissi e namespace", xml2json2, json2xml2);
        xml2json2 = Xml2JsonFactory.getXml2JsonBadgerFish();
        json2xml2 = Xml2JsonFactory.getJson2XmlBadgerFish();
        Xml2JsonTest.test(instance, node, "BadgerFish (Node)", xml2json2, json2xml2);
    }

    private static void test(String xml, String library, IXml2Json xml2json, IJson2Xml json2xml) throws Exception {
        System.out.println("---------------" + library + "-------------");
        String json = xml2json.xml2json(xml);
        System.out.println("Library [" + library + "]. XML -> Json: " + json);
        String xmlAfter = json2xml.json2xml(json);
        System.out.println("Library [" + library + "]. Json-> XML: " + xmlAfter);
        System.out.println("---------------" + library + "-------------");
    }

    private static void test(XMLUtils xmlUtils, Node xml, String library, IXml2Json xml2json, IJson2Xml json2xml) throws Exception {
        System.out.println("---------------" + library + "-------------");
        String json = xml2json.xml2json(xml);
        System.out.println("Library [" + library + "]. XML -> Json: " + json);
        Node xmlNode = json2xml.json2xmlNode(json);
        String xmlAfter = xmlUtils.toString(xmlNode);
        System.out.println("Library [" + library + "]. Json-> XML: " + xmlAfter);
        System.out.println("---------------" + library + "-------------");
    }
}

