/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.ResultContainer;

public abstract class OutputField {
    private static ResourceBundle langPack = null;
    private static int commentIdx = 0;
    private String name = "comment." + ++commentIdx;
    protected String displayText;
    protected String explanatoryText;
    protected ResultContainer resultContainer;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayText() {
        if (langPack != null) {
            return langPack.getString(this.getName() + ".displayText");
        }
        return this.displayText;
    }

    public void setDisplayText(String displayText) {
        this.displayText = displayText;
    }

    public String getExplanatoryText() {
        if (langPack != null) {
            try {
                return langPack.getString(this.getName() + ".explanatoryText");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return this.explanatoryText;
    }

    public void setExplanatoryText(String explanatoryText) {
        this.explanatoryText = explanatoryText;
    }

    public void setResultContainer(ResultContainer resultContainer) {
        this.resultContainer = resultContainer;
    }

    public abstract boolean validate(InstallerContext var1) throws ValidationException;

    public abstract boolean validateObject();

    public static boolean isTrue(String value) {
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
    }

    public static boolean isFalse(String value) {
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no");
    }

    public static boolean requiredBoolean(String value) {
        return OutputField.isTrue(value) || OutputField.isFalse(value);
    }

    public static boolean optionalBoolean(String value) {
        return value == null || OutputField.isTrue(value) || OutputField.isFalse(value);
    }

    static {
        try {
            langPack = ResourceBundle.getBundle("resources.LanguagePack");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

