/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.input;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.ValidationException;
import org.tp23.antinstaller.input.InputException;
import org.tp23.antinstaller.input.InputField;

public class ValidatedTextInput
extends InputField {
    private String regex;
    private Pattern pattern;

    public void setValue(String dir) {
        this.setInputResult(dir);
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
        try {
            this.pattern = Pattern.compile(regex);
        }
        catch (BuildException ex) {
            throw new InputException("Invalid regex in Validated text input");
        }
    }

    public boolean validate(InstallerContext cxt) throws ValidationException {
        try {
            if (this.getInputResult() == null) {
                return false;
            }
            String toTest = this.getInputResult();
            Matcher matcher = this.pattern.matcher(toTest);
            boolean matches = matcher.matches();
            return matches;
        }
        catch (Throwable e) {
            cxt.log(e);
            return false;
        }
    }

    public boolean validateObject() {
        if (this.getDisplayText() == null) {
            System.out.println("Validated:displayText must be set");
            return false;
        }
        if (this.getProperty() == null) {
            System.out.println("Validated:property must be set");
            return false;
        }
        if (this.getDefaultValue() == null) {
            System.out.println("Validated:defaultValue must be set");
            return false;
        }
        if (this.getRegex() == null) {
            System.out.println("Validated:regex must be set");
            return false;
        }
        return true;
    }
}

