/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.renderer.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import org.tp23.antinstaller.input.DirectoryInput;
import org.tp23.antinstaller.input.OutputField;
import org.tp23.antinstaller.renderer.swing.AIButton;
import org.tp23.antinstaller.renderer.swing.AILabel;
import org.tp23.antinstaller.renderer.swing.AIShortTextField;
import org.tp23.antinstaller.renderer.swing.SizeConstants;
import org.tp23.antinstaller.renderer.swing.SwingOutputFieldRenderer;
import org.tp23.gui.GBCF;
import org.tp23.gui.widget.DefaultingDirectoryChooser;

public class DirectoryInputRenderer
extends SwingOutputFieldRenderer {
    private static final ResourceBundle res = ResourceBundle.getBundle("org.tp23.antinstaller.renderer.Res");
    private static final String EMPTY_STRING = "";
    protected DirectoryInput inputField;
    private boolean createMode;
    private DefaultingDirectoryChooser chooser = null;
    protected AILabel fieldLabel = new AILabel();
    protected AIShortTextField jTextField = new AIShortTextField();
    protected AIButton browseButton = new AIButton();
    protected JPanel browsePanel = new JPanel();
    private JPanel parent;

    public void initComponent(JPanel parent) {
        this.parent = parent;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOutputField(OutputField inputField) {
        this.inputField = (DirectoryInput)inputField;
        this.inputField.setValue(this.inputField.getDefaultValue(true));
        this.createMode = OutputField.isTrue(this.inputField.getCreate());
    }

    public void updateInputField() {
        if (!this.inputField.getDefaultValue(true).equals(this.jTextField.getText())) {
            this.inputField.setEditted(true);
        }
        this.inputField.setValue(this.jTextField.getText());
    }

    public void updateDefaultValue() {
        if (!this.inputField.isEditted()) {
            this.jTextField.setText(this.inputField.getDefaultValue(true));
        }
    }

    private void jbInit() throws Exception {
        BorderLayout bl = new BorderLayout();
        this.browsePanel.setLayout(bl);
        this.fieldLabel.setText(this.inputField.getDisplayText());
        this.jTextField.setText(this.inputField.getDefaultValue(true));
        this.browsePanel.add((Component)this.jTextField, "Center");
        this.browsePanel.add((Component)this.browseButton, "East");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String dirPath;
                File selectedFile = null;
                if (DirectoryInputRenderer.this.chooser == null) {
                    DirectoryInputRenderer.this.chooser = new DefaultingDirectoryChooser(DirectoryInputRenderer.this.createMode);
                    DirectoryInputRenderer.this.chooser.setFileHidingEnabled(false);
                }
                if ((dirPath = DirectoryInputRenderer.this.jTextField.getText()) == null) {
                    dirPath = DirectoryInputRenderer.EMPTY_STRING;
                }
                if ((dirPath = dirPath.trim()).length() == 0) {
                    dirPath = DirectoryInputRenderer.this.inputField.getDefaultValue(true);
                    DirectoryInputRenderer.this.jTextField.setText(dirPath);
                }
                DirectoryInputRenderer.this.chooser.setDefaultDirectory(new File(dirPath));
                int returnVal = DirectoryInputRenderer.this.chooser.showDialog(DirectoryInputRenderer.this.parent, e.getActionCommand());
                if (returnVal == 0) {
                    selectedFile = DirectoryInputRenderer.this.chooser.getSelectedFile();
                }
                if (selectedFile != null) {
                    DirectoryInputRenderer.this.jTextField.setText(selectedFile.getAbsolutePath());
                    DirectoryInputRenderer.this.inputField.setValue(selectedFile.getAbsolutePath());
                    DirectoryInputRenderer.this.inputField.setEditted(true);
                }
            }
        });
        this.browseButton.setText(res.getString("selectFolder"));
        this.browseButton.setPreferredSize(new Dimension(150, SizeConstants.FIELD_HEIGHT));
        this.jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DirectoryInputRenderer.this.updateInputField();
            }
        });
    }

    public int addSelf(JPanel content, GBCF cf, int row, boolean overflow) {
        content.add((Component)this.fieldLabel, cf.getCell(row, 0));
        content.add((Component)this.browsePanel, cf.getCell(row, 1));
        if (overflow) {
            this.jTextField.setOverflow(SizeConstants.OVERFLOW_SHORT_FIELD_SIZE);
        }
        return ++row;
    }

    public void renderError() {
        this.jTextField.requestFocus();
    }
}

