/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.runtime.exe;

import java.io.File;
import org.tp23.antinstaller.InstallerContext;
import org.tp23.antinstaller.runtime.SimpleLogger;
import org.tp23.antinstaller.runtime.exe.ExecuteFilter;

public class CreateLoggerFilter
implements ExecuteFilter {
    public static final String LOG_FILE_NAME = "ant.install.log";

    public void exec(InstallerContext ctx) {
        SimpleLogger logger = new SimpleLogger();
        ctx.setLogger(logger);
        try {
            String defaultName = "./ant.install.log";
            File defaultFile = new File(defaultName);
            try {
                if (!defaultFile.exists()) {
                    defaultFile.createNewFile();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (defaultFile.canWrite()) {
                logger.setFileName(defaultName);
            } else {
                String tempDir = ctx.getFileRoot().getAbsolutePath();
                logger.setFileName(tempDir + System.getProperty("file.separator") + LOG_FILE_NAME);
            }
            ctx.log("Ant basedir:" + ctx.getFileRoot().getCanonicalPath());
        }
        catch (Throwable ex1) {
            ex1.printStackTrace();
            logger.close();
        }
    }
}

