/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.velocity;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.ExtProperties;
import org.restlet.representation.Representation;

public class RepresentationResourceLoader
extends ResourceLoader {
    private static final Map<String, Representation> store = new ConcurrentHashMap<String, Representation>();
    private final Representation defaultRepresentation;

    public static Map<String, Representation> getStore() {
        return store;
    }

    public RepresentationResourceLoader(Representation defaultRepresentation) {
        this.defaultRepresentation = defaultRepresentation;
    }

    public long getLastModified(Resource resource) {
        Representation original = RepresentationResourceLoader.getStore().get(resource.getName());
        return original == null ? 0L : original.getModificationDate().getTime();
    }

    public boolean isSourceModified(Resource resource) {
        return this.getLastModified(resource) != resource.getLastModified();
    }

    public Reader getResourceReader(String source, String encoding) throws ResourceNotFoundException {
        try {
            Representation resultRepresentation = RepresentationResourceLoader.getStore().get(source);
            if (resultRepresentation == null) {
                resultRepresentation = this.defaultRepresentation;
            }
            if (resultRepresentation == null) {
                throw new ResourceNotFoundException("Could not locate resource '" + source + "'");
            }
            return resultRepresentation.getReader();
        }
        catch (IOException ioe) {
            throw new ResourceNotFoundException((Throwable)ioe);
        }
    }

    public void init(ExtProperties configuration) {
    }
}

