/*
 * Decompiled with CFR 0.152.
 */
package org.jminix.console.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jminix.console.resource.AbstractListResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationsResource
extends AbstractListResource {
    @Override
    protected String getTemplateName() {
        return "operations";
    }

    protected List<Map<String, Object>> getList() {
        String domain = this.unescape(this.getDecodedAttribute("domain"));
        String mbean = this.unescape(this.getDecodedAttribute("mbean"));
        try {
            MBeanServerConnection server = this.getServer();
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            for (MBeanOperationInfo info : server.getMBeanInfo(new ObjectName(domain + ":" + mbean)).getOperations()) {
                HashMap<String, Object> pair = new HashMap<String, Object>();
                Object role = info.getDescriptor().getFieldValue("role");
                if (role == null && info.getName().startsWith("get") && info.getSignature().length == 0 || "getter".equals(role)) continue;
                StringBuilder sb = new StringBuilder(info.getName() + "(");
                boolean first = true;
                for (MBeanParameterInfo p : info.getSignature()) {
                    if (!first) {
                        sb.append(",");
                    } else {
                        first = false;
                    }
                    sb.append(p.getType());
                }
                sb.append(")");
                pair.put("operation", info);
                pair.put("declaration", sb.toString());
                result.add(pair);
            }
            Collections.sort(result, new Comparator<Map<String, Object>>(){

                @Override
                public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                    return ((String)o1.get("declaration")).compareTo((String)o2.get("declaration"));
                }
            });
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
    }
}

