/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import org.ajax4jsf.component.UIPoll;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.context.AjaxContextImpl;
import org.ajax4jsf.event.AjaxEvent;
import org.ajax4jsf.javascript.JSLiteral;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.renderkit.AbstractProgressBarRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIProgressBar
extends UIPoll {
    private final Log logger = LogFactory.getLog(UIProgressBar.class);
    public static final String COMPONENT_TYPE = "org.richfaces.ProgressBar";
    public static final String COMPONENT_FAMILY = "org.richfaces.ProgressBar";
    public static final String FORCE_PERCENT_PARAM = "forcePercent";
    private static final String PERCENT_PARAM = "percent";
    private static final String _maxValue = "maxValue";
    private static final String _minValue = "minValue";
    private static final String _enabled = "enabled";
    private static final String _interval = "interval";
    private static final String _completeClass = "completeClass";
    private static final String _remainClass = "remainClass";
    private static final String _styleClass = "styleClass";
    private static final String _markup = "markup";
    private static final String _context = "context";

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        block6: {
            Object reRender;
            Set ajaxRegions;
            Map params;
            AjaxContext ajaxContext;
            FacesContext facesContext;
            block7: {
                String clientId;
                block5: {
                    ActionListener[] listeners;
                    facesContext = FacesContext.getCurrentInstance();
                    ajaxContext = AjaxContextImpl.getCurrentInstance((FacesContext)facesContext);
                    params = facesContext.getExternalContext().getRequestParameterMap();
                    if (!params.containsKey(clientId = this.getClientId(facesContext))) {
                        return;
                    }
                    if (!(event instanceof ActionEvent)) break block5;
                    for (ActionListener l : listeners = this.getActionListeners()) {
                        l.processAction((ActionEvent)event);
                    }
                    break block6;
                }
                if (!(event instanceof AjaxEvent)) break block6;
                if (params.containsKey(FORCE_PERCENT_PARAM) || !params.containsKey(PERCENT_PARAM)) break block7;
                Number value = this.getNumber(this.getAttributes().get("value"));
                ajaxContext.removeRenderedArea(clientId);
                ajaxContext.setResponseData(this.getResponseData(value, facesContext));
                AjaxRendererUtils.addRegionsFromComponent((UIComponent)this, (FacesContext)facesContext);
                break block6;
            }
            if (!params.containsKey(FORCE_PERCENT_PARAM)) break block6;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Force state: " + this.getClientId(facesContext)));
            }
            ajaxContext.addComponentToAjaxRender((UIComponent)this);
            String forcedState = (String)params.get(FORCE_PERCENT_PARAM);
            if ("complete".equals(forcedState) && (ajaxRegions = AjaxRendererUtils.asSet(reRender = this.getAttributes().get("reRenderAfterComplete"))) != null) {
                for (String id : ajaxRegions) {
                    ajaxContext.addComponentToAjaxRender((UIComponent)this, id);
                }
            }
        }
    }

    private Map<Object, Object> getResponseData(Number value, FacesContext facesContext) {
        AbstractProgressBarRenderer renderer = (AbstractProgressBarRenderer)this.getRenderer(facesContext);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("value", value);
        map.put(_interval, this.getInterval());
        if (this.getAttributes().get("style") != null) {
            map.put("style", this.getAttributes().get("style"));
        }
        boolean enabled = (Boolean)this.getAttributes().get(_enabled);
        map.put(_enabled, new Boolean(enabled));
        if (!this.isSimple(renderer)) {
            map.put(_markup, this.getMarkup(facesContext, renderer));
            map.put(_context, this.getContext(renderer, value));
        }
        this.addStyles2Responce(map, _completeClass, this.getAttributes().get(_completeClass));
        this.addStyles2Responce(map, _remainClass, this.getAttributes().get(_remainClass));
        this.addStyles2Responce(map, _styleClass, this.getAttributes().get(_styleClass));
        return map;
    }

    private JSLiteral getContext(AbstractProgressBarRenderer renderer, Number percent) {
        StringBuffer buffer = new StringBuffer("{");
        buffer.append("value:");
        buffer.append(ScriptUtils.toScript((Object)percent.toString())).append(",");
        buffer.append("minValue:");
        buffer.append(ScriptUtils.toScript((Object)this.getAttributes().get(_minValue).toString())).append(",");
        buffer.append("maxValue:");
        buffer.append(ScriptUtils.toScript((Object)this.getAttributes().get(_maxValue).toString()));
        String parameters = renderer.getParameters((UIComponent)this);
        if (parameters != null) {
            buffer.append(",");
            buffer.append(parameters);
        }
        buffer.append("}");
        return new JSLiteral(buffer.toString());
    }

    private boolean isSimple(AbstractProgressBarRenderer renderer) {
        return renderer.isSimpleMarkup((UIComponent)this);
    }

    private JSLiteral getMarkup(FacesContext context, AbstractProgressBarRenderer renderer) {
        JSLiteral literal = null;
        try {
            StringBuffer markup = renderer.getMarkup(context, (UIComponent)this);
            if (markup != null) {
                literal = new JSLiteral(markup.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return literal;
    }

    private void addStyles2Responce(Map<Object, Object> map, String key, Object className) {
        if (className != null) {
            map.put(key, className);
        }
    }

    public Number getNumber(Object v) {
        Number result = null;
        if (v != null) {
            try {
                if (v instanceof String) {
                    result = Double.parseDouble((String)v);
                } else {
                    Number n = (Number)v;
                    if (n instanceof BigDecimal || n instanceof Double || n instanceof Float) {
                        result = Float.valueOf(n.floatValue());
                    } else if (n instanceof Integer || n instanceof Long) {
                        result = n.longValue();
                    }
                }
            }
            catch (Exception e) {
                e.getMessage();
            }
            return result;
        }
        return new Integer(0);
    }
}

