/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.core;

import org.openspcoop2.pdd.config.ConfigurazioneNodiRuntimeInit;
import org.openspcoop2.pdd.config.InvokerNodiRuntime;
import org.openspcoop2.pdd.logger.filetrace.FileTraceGovWayState;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.web.ctrlstat.config.ConsoleProperties;
import org.openspcoop2.web.ctrlstat.core.InitListener;

public class InitRuntimeConfigReader
extends ConfigurazioneNodiRuntimeInit {
    private ConsoleProperties consoleProperties;

    public InitRuntimeConfigReader(ConsoleProperties consoleProperties, boolean reInitSecretMaps) throws UtilsException {
        super(InitListener.getLog(), consoleProperties.getConfigurazioneNodiRuntime(), reInitSecretMaps, consoleProperties.getBYOKEnvSecretsConfig(), consoleProperties.isBYOKEnvSecretsConfigRequired());
        this.consoleProperties = consoleProperties;
    }

    protected boolean isCompleted(String alias) {
        boolean finished = false;
        InvokerNodiRuntime invoker = new InvokerNodiRuntime(InitListener.log, this.configurazioneNodiRuntime);
        this.analizeFileTraceGovWayState(invoker, alias, this.consoleProperties);
        if (InitListener.getFileTraceGovWayState() != null) {
            finished = true;
        }
        return finished;
    }

    private void analizeFileTraceGovWayState(InvokerNodiRuntime invoker, String alias, ConsoleProperties consoleProperties) {
        try {
            String tmp = invoker.invokeJMXMethod(alias, consoleProperties.getJmxPdDConfigurazioneSistemaType(alias), consoleProperties.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), consoleProperties.getJmxPdDConfigurazioneSistemaNomeMetodoGetFileTrace(alias));
            InitListener.setFileTraceGovWayState(FileTraceGovWayState.toConfig((String)tmp, (boolean)true));
        }
        catch (Exception e) {
            InitListener.logDebug(e.getMessage(), e);
        }
    }

    protected String getDescrizione() {
        return "secrets,filetrace";
    }
}

