/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.core;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.struts.upload.FormFile;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.mime.MimeTypes;

public class SerialiableFormFile
implements FormFile,
Serializable {
    private static final long serialVersionUID = 1L;
    private String contentType;
    private String fileName;
    private byte[] content;

    public SerialiableFormFile(FormFile ff) throws UtilsException {
        try {
            this.contentType = ff.getContentType();
            this.fileName = ff.getFileName();
            this.content = ff.getFileData();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    public SerialiableFormFile(String fileName, byte[] content) throws UtilsException {
        this(SerialiableFormFile.getContentType(fileName), fileName, content);
    }

    public SerialiableFormFile(String contentType, String fileName, byte[] content) {
        this.fileName = fileName;
        this.content = content;
        this.contentType = contentType;
    }

    private static String getContentType(String fileName) throws UtilsException {
        String mimeType = null;
        if (fileName.contains(".")) {
            String ext = null;
            try {
                ext = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
            }
            catch (Exception exception) {
                // empty catch block
            }
            MimeTypes mimeTypes = MimeTypes.getInstance();
            mimeType = ext != null && mimeTypes.existsExtension(ext) ? mimeTypes.getMimeType(ext) : "application/x-download";
        } else {
            mimeType = "application/x-download";
        }
        return mimeType;
    }

    public void destroy() {
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getFileData() throws FileNotFoundException, IOException {
        return this.content;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getFileSize() {
        return this.content.length;
    }

    public InputStream getInputStream() throws FileNotFoundException, IOException {
        return new ByteArrayInputStream(this.content);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFileSize(int arg0) {
    }
}

