/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.gestori;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Date;
import javax.jms.QueueSession;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.web.ctrlstat.core.DBManager;
import org.openspcoop2.web.ctrlstat.costanti.OperationsParameter;
import org.openspcoop2.web.lib.queue.ClassQueue;
import org.openspcoop2.web.lib.queue.costanti.OperationStatus;
import org.openspcoop2.web.lib.queue.dao.FilterParameter;
import org.openspcoop2.web.lib.queue.dao.Operation;
import org.openspcoop2.web.lib.queue.dao.Parameter;
import org.slf4j.Logger;

public class GestioneOperazione {
    private DBManager dbManager;
    private Connection connectionDB;
    private QueueSession sessionJMS;
    private Operation operation;
    private ClassQueue operationManager;
    private Logger log;
    private String idGestore;
    private String tipoOperazioneCRUD;

    public GestioneOperazione(DBManager db, Connection c, QueueSession s, Operation o, ClassQueue operationManager, Logger l, String tipoOperazioneCRUD, String idGestore) {
        this.dbManager = db;
        this.connectionDB = c;
        this.sessionJMS = s;
        this.operation = o;
        this.operationManager = operationManager;
        this.log = l;
        this.idGestore = idGestore;
        this.tipoOperazioneCRUD = tipoOperazioneCRUD != null ? "." + tipoOperazioneCRUD : "";
    }

    public void error(String msg) throws Exception {
        this.error(msg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String msgParam, Exception e) throws Exception {
        Object msgErrore = msgParam;
        if (e != null) {
            PrintWriter pw = null;
            ByteArrayOutputStream out = null;
            try {
                out = new ByteArrayOutputStream();
                pw = new PrintWriter(out);
                e.printStackTrace(pw);
                pw.flush();
                out.flush();
            }
            finally {
                try {
                    if (pw != null) {
                        pw.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
            msgErrore = (String)msgErrore + "\n" + out.toString();
        }
        if (e != null && e instanceof ConnectException) {
            this.log.warn("[" + this.idGestore + "]" + this.tipoOperazioneCRUD + " " + msgParam, (Throwable)e);
        } else if (e != null && Utilities.existsInnerException((Throwable)e, ConnectException.class)) {
            this.log.warn("[" + this.idGestore + "]" + this.tipoOperazioneCRUD + " " + msgParam, (Throwable)e);
        } else if (e != null) {
            this.log.error("[" + this.idGestore + "]" + this.tipoOperazioneCRUD + " " + msgParam, (Throwable)e);
        } else {
            this.log.error("[" + this.idGestore + "]" + this.tipoOperazioneCRUD + " " + msgParam);
        }
        this.operation.setStatus(OperationStatus.ERROR);
        this.operation.setDetails((String)msgErrore);
        this.operation.setTimeExecute((Date)new Timestamp(System.currentTimeMillis()));
        this.operationManager.updateOperation(this.operation);
        this.sessionJMS.rollback();
        this.dbManager.releaseConnection(this.connectionDB);
    }

    public void invalid(String msg) throws Exception {
        this.log.error("[" + this.idGestore + "]" + this.tipoOperazioneCRUD + " " + msg);
        this.operation.setStatus(OperationStatus.INVALID);
        this.operation.setDetails(msg);
        this.operation.setTimeExecute((Date)new Timestamp(System.currentTimeMillis()));
        this.operationManager.updateOperation(this.operation);
        this.sessionJMS.commit();
        this.dbManager.releaseConnection(this.connectionDB);
    }

    public void waitBeforeInvalid(String msg) throws Exception {
        this.log.warn("[" + this.idGestore + "]" + this.tipoOperazioneCRUD + " " + msg);
        if (!"add".equals(this.operation.getOperation())) {
            this.operation.setStatus(OperationStatus.INVALID);
            this.operation.setDetails(msg);
        } else if (this.operation.getWaitTime() > this.operationManager.getDefaultWaitTime()) {
            this.log.debug("L operazione " + this.operation.toString() + " ha superato il WAIT_TIME(" + this.operationManager.getDefaultWaitTime() + ") setto operazione come INVALID.");
            this.operation.setStatus(OperationStatus.INVALID);
            this.operation.setDetails("Superato WAIT_TIME(" + this.operationManager.getDefaultWaitTime() + ") <<>> Old details:" + msg);
        } else {
            this.operation.setStatus(OperationStatus.WAIT);
            this.operation.setWaitTime(this.operation.getWaitTime() + 1);
            this.operation.setDetails(msg);
        }
        this.operation.setTimeExecute((Date)new Timestamp(System.currentTimeMillis()));
        this.operationManager.updateOperation(this.operation);
        switch (this.operation.getStatus()) {
            case WAIT: {
                this.sessionJMS.rollback();
                break;
            }
            default: {
                this.sessionJMS.commit();
            }
        }
        this.dbManager.releaseConnection(this.connectionDB);
    }

    public void success(String msg) throws Exception {
        this.log.info("[" + this.idGestore + "]" + this.tipoOperazioneCRUD + " " + msg);
        this.operation.setStatus(OperationStatus.SUCCESS);
        this.operation.setDetails(msg);
        this.operation.setTimeExecute((Date)new Timestamp(System.currentTimeMillis()));
        this.operationManager.updateOperation(this.operation);
        this.sessionJMS.commit();
        this.dbManager.releaseConnection(this.connectionDB);
    }

    public void delete() throws Exception {
        this.operation.setStatus(OperationStatus.DELETED);
        this.operation.setDetails("[" + this.idGestore + "]" + this.tipoOperazioneCRUD + " Operazione Marcata come DELETED");
        this.operation.setTimeExecute(new Date(System.currentTimeMillis()));
        this.operationManager.updateOperation(this.operation);
        this.sessionJMS.commit();
        this.dbManager.releaseConnection(this.connectionDB);
    }

    public boolean existsOperationNotCompleted(String tipoOperazione, String hostname, FilterParameter filtro) throws Exception {
        return this.operationManager.existsOperationNotCompleted(tipoOperazione, hostname, filtro);
    }

    public FilterParameter getFilterChangeIDSoggetto(String tipoSogg, String nomeSogg, String oldTipoSogg, String oldNomeSogg) {
        FilterParameter filtro = new FilterParameter();
        Parameter param = new Parameter();
        param.setName(OperationsParameter.OGGETTO.getNome());
        param.setValue("soggetto");
        filtro.addFilterParameter(param);
        Parameter paramTipoSoggetto = new Parameter();
        paramTipoSoggetto.setName(OperationsParameter.TIPO_SOGGETTO.getNome());
        paramTipoSoggetto.setValue(tipoSogg);
        filtro.addFilterParameter(paramTipoSoggetto);
        Parameter paramNomeSoggetto = new Parameter();
        paramNomeSoggetto.setName(OperationsParameter.NOME_SOGGETTO.getNome());
        paramNomeSoggetto.setValue(nomeSogg);
        filtro.addFilterParameter(paramNomeSoggetto);
        Parameter paramOldTipoSoggetto = new Parameter();
        paramOldTipoSoggetto.setName(OperationsParameter.OLD_TIPO_SOGGETTO.getNome());
        paramOldTipoSoggetto.setValue(oldTipoSogg);
        filtro.addFilterParameter(paramOldTipoSoggetto);
        Parameter paramOldNomeSoggetto = new Parameter();
        paramOldNomeSoggetto.setName(OperationsParameter.OLD_NOME_SOGGETTO.getNome());
        paramOldNomeSoggetto.setValue(oldNomeSogg);
        filtro.addFilterParameter(paramOldNomeSoggetto);
        return filtro;
    }
}

